/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.internal;

import ilog.rules.res.model.IlrAlreadyExistException;
import ilog.rules.res.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.res.model.IlrMutableRepository;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.internal.IlrDeploymentOperation;
import ilog.rules.res.model.internal.IlrDeploymentReport;
import ilog.rules.res.model.internal.IlrEntityContainer;
import ilog.rules.res.model.internal.IlrModelImplLocalization;
import ilog.rules.res.model.internal.IlrMutableRepositoryImpl;
import ilog.rules.res.model.internal.IlrMutableRuleAppInformationImpl;
import ilog.rules.res.model.internal.IlrMutableRulesetArchiveInformationImpl;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.IlrRepositoryDAO;
import ilog.rules.res.persistence.IlrTransaction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;

public class IlrRuleAppsDeployer {
    public static final String MAJOR_VERSION_POLICY = "MAJOR_VERSION_POLICY";
    public static final String MINOR_VERSION_POLICY = "MINOR_VERSION_POLICY";
    public static final String ADD_AT_END_MERGING_POLICY = "ADD_AT_END_MERGING_POLICY";
    public static final String REPLACE_MERGING_POLICY = "REPLACE_MERGING_POLICY";
    public static final String ADD_AT_END_RULESET_MERGING_POLICY = "ADD_AT_END_RULESET_MERGING_POLICY";
    public static final String REPLACE_RULESET_MERGING_POLICY = "REPLACE_RULESET_MERGING_POLICY";

    public static void validatePolicy(String policy) {
        if (!(ADD_AT_END_MERGING_POLICY.equals(policy) || REPLACE_MERGING_POLICY.equals(policy) || ADD_AT_END_RULESET_MERGING_POLICY.equals(policy) || REPLACE_RULESET_MERGING_POLICY.equals(policy))) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.MERGING_POLICY_NOT_SUPPORTED, new String[]{policy});
        }
    }

    public IlrDeploymentReport deploy(IlrMutableRepository repository, String mergingPolicy, String versioningPolicy, Set<IlrMutableRuleAppInformation> ruleApps) {
        if (ADD_AT_END_MERGING_POLICY.equals(mergingPolicy)) {
            return this.addAtEndRuleApps(repository, versioningPolicy, ruleApps);
        }
        if (REPLACE_MERGING_POLICY.equals(mergingPolicy)) {
            return this.replaceRuleApps(repository, ruleApps);
        }
        if (ADD_AT_END_RULESET_MERGING_POLICY.equals(mergingPolicy)) {
            return this.addAtEndRulesets(repository, versioningPolicy, ruleApps);
        }
        if (REPLACE_RULESET_MERGING_POLICY.equals(mergingPolicy)) {
            return this.replaceRulesets(repository, ruleApps);
        }
        throw new IlrIllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.MERGING_POLICY_NOT_SUPPORTED, new String[]{mergingPolicy});
    }

    public IlrDeploymentReport addAtEndRuleApps(IlrMutableRepository repository, String versioningPolicy, Set<IlrMutableRuleAppInformation> ruleApps) {
        if (ruleApps == null) {
            throw new NullPointerException();
        }
        if (versioningPolicy == null || !versioningPolicy.equals(MAJOR_VERSION_POLICY) && !versioningPolicy.equals(MINOR_VERSION_POLICY)) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.VERSIONING_POLICY_NOT_SUPPORTED, new String[]{versioningPolicy});
        }
        ArrayList<IlrMutableRepositoryImpl.EntityOperation> operations = new ArrayList<IlrMutableRepositoryImpl.EntityOperation>();
        IlrEntityContainer<IlrMutableRuleAppInformation> container = new IlrEntityContainer<IlrMutableRuleAppInformation>(((IlrMutableRepositoryImpl)repository).ruleAppsContainer);
        ArrayList<IlrMutableRuleAppInformation> ruleAppsOrdered = new ArrayList<IlrMutableRuleAppInformation>(ruleApps);
        Collections.sort(ruleAppsOrdered, IlrMutableRuleAppInformationImpl.CASE_INSENSITIVE_ORDER);
        for (IlrMutableRuleAppInformation ruleApp : ruleAppsOrdered) {
            if (container.containsEntity(ruleApp.getName(), ruleApp.getVersion())) {
                IlrVersion newVersion = this.nextVersion(container.getGreatestEntity(ruleApp.getName()).getVersion(), versioningPolicy);
                operations.add(RuleAppOperation.changePath(container, (IlrMutableRuleAppInformationImpl)ruleApp, newVersion));
                continue;
            }
            operations.add(RuleAppOperation.add(container, (IlrMutableRuleAppInformationImpl)ruleApp));
        }
        return ((IlrMutableRepositoryImpl)repository).commit(operations);
    }

    public IlrDeploymentReport addAtEndRulesets(IlrMutableRepository repository, String versioningPolicy, Set<IlrMutableRuleAppInformation> ruleApps) {
        if (ruleApps == null) {
            throw new NullPointerException();
        }
        if (versioningPolicy == null || !versioningPolicy.equals(MAJOR_VERSION_POLICY) && !versioningPolicy.equals(MINOR_VERSION_POLICY)) {
            throw new IlrIllegalArgumentRuntimeException("ilog.rules.res.model.impl.messages", IlrModelImplLocalization.VERSIONING_POLICY_NOT_SUPPORTED, new String[]{versioningPolicy});
        }
        ArrayList<IlrMutableRepositoryImpl.EntityOperation> operations = new ArrayList<IlrMutableRepositoryImpl.EntityOperation>();
        IlrEntityContainer<IlrMutableRuleAppInformation> raContainer = new IlrEntityContainer<IlrMutableRuleAppInformation>(((IlrMutableRepositoryImpl)repository).ruleAppsContainer);
        for (IlrMutableRuleAppInformation ruleApp : ruleApps) {
            if (raContainer.containsEntity(ruleApp.getName(), ruleApp.getVersion())) {
                IlrMutableRuleAppInformationImpl ra = (IlrMutableRuleAppInformationImpl)raContainer.getEntity(ruleApp.getName(), ruleApp.getVersion());
                IlrEntityContainer<IlrMutableRulesetArchiveInformation> rsContainer = new IlrEntityContainer<IlrMutableRulesetArchiveInformation>(ra.rulesetsContainer);
                ArrayList rulesetsOrdered = new ArrayList(ruleApp.getRulesets());
                Collections.sort(rulesetsOrdered, IlrMutableRulesetArchiveInformationImpl.CASE_INSENSITIVE_ORDER);
                for (IlrMutableRulesetArchiveInformation ruleset : rulesetsOrdered) {
                    if (rsContainer.containsEntity(ruleset.getName(), ruleset.getVersion())) {
                        IlrVersion newVersion = this.nextVersion(rsContainer.getGreatestEntity(ruleset.getName()).getVersion(), versioningPolicy);
                        operations.add(RulesetOperation.changePath(rsContainer, (IlrMutableRulesetArchiveInformationImpl)ruleset, newVersion));
                        continue;
                    }
                    operations.add(RulesetOperation.add(rsContainer, (IlrMutableRulesetArchiveInformationImpl)ruleset));
                    rsContainer.addEntity(ruleset.getName(), ruleset.getVersion(), ruleset);
                }
                operations.add(RuleAppOperation.update((IlrMutableRuleAppInformationImpl)ruleApp));
                continue;
            }
            operations.add(RuleAppOperation.add(raContainer, (IlrMutableRuleAppInformationImpl)ruleApp));
        }
        return ((IlrMutableRepositoryImpl)repository).commit(operations);
    }

    public IlrDeploymentReport replaceRuleApps(IlrMutableRepository repository, Set<IlrMutableRuleAppInformation> ruleApps) {
        if (ruleApps == null) {
            throw new NullPointerException();
        }
        ArrayList<IlrMutableRepositoryImpl.EntityOperation> operations = new ArrayList<IlrMutableRepositoryImpl.EntityOperation>();
        for (IlrMutableRuleAppInformation ruleApp : ruleApps) {
            if (repository.getRuleApp(ruleApp.getName(), ruleApp.getVersion()) != null) {
                operations.add(RuleAppOperation.replace((IlrMutableRuleAppInformationImpl)ruleApp));
                continue;
            }
            operations.add(RuleAppOperation.add(null, (IlrMutableRuleAppInformationImpl)ruleApp));
        }
        return ((IlrMutableRepositoryImpl)repository).commit(operations);
    }

    public IlrDeploymentReport replaceRulesets(IlrMutableRepository repository, Set<IlrMutableRuleAppInformation> ruleApps) {
        if (ruleApps == null) {
            throw new NullPointerException();
        }
        ArrayList<IlrMutableRepositoryImpl.EntityOperation> operations = new ArrayList<IlrMutableRepositoryImpl.EntityOperation>();
        for (IlrMutableRuleAppInformation newRuleApp : ruleApps) {
            IlrMutableRuleAppInformation ruleApp = (IlrMutableRuleAppInformation)repository.getRuleApp(newRuleApp.getName(), newRuleApp.getVersion());
            if (ruleApp != null) {
                for (IlrMutableRulesetArchiveInformation ruleset : newRuleApp.getRulesets()) {
                    if (ruleApp.getRuleset(ruleset.getName(), ruleset.getVersion()) != null) {
                        operations.add(RulesetOperation.replace((IlrMutableRulesetArchiveInformationImpl)ruleset));
                        continue;
                    }
                    operations.add(RulesetOperation.add(null, (IlrMutableRulesetArchiveInformationImpl)ruleset));
                }
                operations.add(RuleAppOperation.update((IlrMutableRuleAppInformationImpl)newRuleApp));
                continue;
            }
            operations.add(RuleAppOperation.add(null, (IlrMutableRuleAppInformationImpl)newRuleApp));
        }
        return ((IlrMutableRepositoryImpl)repository).commit(operations);
    }

    private IlrVersion nextVersion(IlrVersion version, String versioningPolicy) {
        if (MAJOR_VERSION_POLICY.equals(versioningPolicy)) {
            return new IlrVersion(version.getMajor() + 1, 0);
        }
        if (MINOR_VERSION_POLICY.equals(versioningPolicy)) {
            return new IlrVersion(version.getMajor(), version.getMinor() + 1);
        }
        return version;
    }

    private static class RulesetOperation
    implements IlrMutableRepositoryImpl.EntityOperation {
        private final IlrMutableRulesetArchiveInformationImpl ruleset;
        private final int operation;
        private final IlrVersion oldVersion;

        private RulesetOperation(IlrMutableRulesetArchiveInformationImpl ruleset, int operation, IlrVersion oldVersion, String managedXomGeneratedProperty) {
            this.ruleset = ruleset;
            this.operation = operation;
            this.oldVersion = oldVersion;
        }

        private RulesetOperation(IlrMutableRulesetArchiveInformationImpl ruleset, int operation, String managedXomGeneratedProperty) {
            this(ruleset, operation, null, managedXomGeneratedProperty);
        }

        static IlrMutableRepositoryImpl.EntityOperation changePath(IlrEntityContainer<IlrMutableRulesetArchiveInformation> container, IlrMutableRulesetArchiveInformationImpl ruleset, IlrVersion newVersion) {
            IlrVersion oldVersion = ruleset.getVersion();
            IlrMutableRuleAppInformation ruleApp = ruleset.getRuleApp();
            ruleApp.removeRuleset(ruleset);
            ruleset.setVersion(newVersion);
            try {
                ruleApp.addRuleset(ruleset);
            }
            catch (IlrAlreadyExistException e) {
                // empty catch block
            }
            container.addEntity(ruleset.getName(), ruleset.getVersion(), ruleset);
            return new RulesetOperation(ruleset, 2, oldVersion, (String)ruleset.getProperties().get("ruleset.managedxom.uris"));
        }

        static IlrMutableRepositoryImpl.EntityOperation add(IlrEntityContainer<IlrMutableRulesetArchiveInformation> container, IlrMutableRulesetArchiveInformationImpl ruleset) {
            if (container != null) {
                container.addEntity(ruleset.getName(), ruleset.getVersion(), ruleset);
            }
            return new RulesetOperation(ruleset, 1, (String)ruleset.getProperties().get("ruleset.managedxom.uris"));
        }

        static IlrMutableRepositoryImpl.EntityOperation replace(IlrMutableRulesetArchiveInformationImpl ruleset) {
            return new RulesetOperation(ruleset, 3, (String)ruleset.getProperties().get("ruleset.managedxom.uris"));
        }

        @Override
        public void commitOnResourceProvider(IlrRepositoryDAO repositoryDAO, IlrTransaction transaction) throws IlrDAOException {
            switch (this.operation) {
                case 3: {
                    repositoryDAO.removeRuleset(this.ruleset.getCanonicalPath(), transaction);
                }
                case 1: 
                case 2: {
                    repositoryDAO.addRuleset(this.ruleset.getCanonicalPath(), this.ruleset, transaction);
                }
            }
        }

        @Override
        public void commitOnRepository(IlrMutableRepositoryImpl repository) {
            IlrMutableRuleAppInformationImpl ruleApp = (IlrMutableRuleAppInformationImpl)repository.getRuleApp(this.ruleset.getRuleApp().getName(), this.ruleset.getRuleApp().getVersion());
            switch (this.operation) {
                case 3: {
                    IlrMutableRulesetArchiveInformationImpl oldRuleset = (IlrMutableRulesetArchiveInformationImpl)ruleApp.rulesetsContainer.removeEntity(this.ruleset.getName(), this.ruleset.getVersion());
                    oldRuleset.linked(null, true);
                }
                case 1: 
                case 2: {
                    ruleApp.rulesetsContainer.addEntity(this.ruleset.getName(), this.ruleset.getVersion(), this.ruleset);
                    this.ruleset.linked(ruleApp, true);
                }
            }
        }

        @Override
        public void commitOnReport(IlrDeploymentReport report) {
            IlrPath originalPath = new IlrPath(this.ruleset.getRuleApp().getName(), this.ruleset.getRuleApp().getVersion(), this.ruleset.getName(), this.oldVersion != null ? this.oldVersion : this.ruleset.getVersion());
            IlrPath commitedPath = this.ruleset.getCanonicalPath();
            report.addOperation(new IlrDeploymentOperation(originalPath, this.operation, commitedPath, (String)this.ruleset.getProperties().get("ruleset.managedxom.uris")));
        }
    }

    private static class RuleAppOperation
    implements IlrMutableRepositoryImpl.EntityOperation {
        private final IlrMutableRuleAppInformationImpl ruleApp;
        private final int operation;
        private final IlrVersion oldVersion;

        private RuleAppOperation(IlrMutableRuleAppInformationImpl ruleApp, int operation, IlrVersion oldVersion) {
            this.ruleApp = ruleApp;
            this.operation = operation;
            this.oldVersion = oldVersion;
        }

        private RuleAppOperation(IlrMutableRuleAppInformationImpl ruleApp, int operation) {
            this(ruleApp, operation, ruleApp.getVersion());
        }

        static IlrMutableRepositoryImpl.EntityOperation changePath(IlrEntityContainer<IlrMutableRuleAppInformation> container, IlrMutableRuleAppInformationImpl ruleApp, IlrVersion newVersion) {
            IlrVersion oldVersion = ruleApp.getVersion();
            ruleApp.setVersion(newVersion);
            container.addEntity(ruleApp.getName(), ruleApp.getVersion(), ruleApp);
            return new RuleAppOperation(ruleApp, 2, oldVersion);
        }

        static IlrMutableRepositoryImpl.EntityOperation add(IlrEntityContainer<IlrMutableRuleAppInformation> container, IlrMutableRuleAppInformationImpl ruleApp) {
            if (container != null) {
                container.addEntity(ruleApp.getName(), ruleApp.getVersion(), ruleApp);
            }
            return new RuleAppOperation(ruleApp, 1);
        }

        static IlrMutableRepositoryImpl.EntityOperation update(IlrMutableRuleAppInformationImpl ruleApp) {
            return new RuleAppOperation(ruleApp, 0);
        }

        static IlrMutableRepositoryImpl.EntityOperation replace(IlrMutableRuleAppInformationImpl ruleApp) {
            return new RuleAppOperation(ruleApp, 3);
        }

        @Override
        public void commitOnResourceProvider(IlrRepositoryDAO repositoryDAO, IlrTransaction transaction) throws IlrDAOException {
            switch (this.operation) {
                case 3: {
                    repositoryDAO.removeRuleApp(this.ruleApp.getCanonicalPath(), transaction);
                }
                case 1: 
                case 2: {
                    repositoryDAO.addRuleApp(this.ruleApp, transaction);
                    break;
                }
                case 0: {
                    repositoryDAO.updateRuleApp(this.ruleApp, transaction);
                }
            }
        }

        @Override
        public void commitOnRepository(IlrMutableRepositoryImpl repository) {
            switch (this.operation) {
                case 3: {
                    IlrMutableRuleAppInformationImpl oldRuleApp = (IlrMutableRuleAppInformationImpl)repository.ruleAppsContainer.removeEntity(this.ruleApp.getName(), this.ruleApp.getVersion());
                    oldRuleApp.linked(null, true);
                }
                case 1: 
                case 2: {
                    repository.ruleAppsContainer.addEntity(this.ruleApp.getName(), this.ruleApp.getVersion(), this.ruleApp);
                    this.ruleApp.linked(repository, true);
                    break;
                }
                case 0: {
                    IlrMutableRuleAppInformationImpl oldRuleApp = (IlrMutableRuleAppInformationImpl)repository.ruleAppsContainer.getEntity(this.ruleApp.getName(), this.ruleApp.getVersion());
                    oldRuleApp.updateFields(this.ruleApp, true);
                }
            }
        }

        @Override
        public void commitOnReport(IlrDeploymentReport report) {
            IlrPath originalPath = new IlrPath(this.ruleApp.getName(), this.oldVersion, null, null);
            IlrPath commitedPath = this.ruleApp.getCanonicalPath();
            report.addOperation(new IlrDeploymentOperation(originalPath, this.operation, commitedPath, null));
            if (this.operation != 0) {
                int op = 1;
                if (this.operation == 2) {
                    op = 2;
                }
                for (IlrMutableRulesetArchiveInformation ruleset : this.ruleApp.getRulesets()) {
                    IlrPath originalRulesetPath = new IlrPath(this.ruleApp.getName(), this.oldVersion, ruleset.getName(), ruleset.getVersion());
                    IlrPath commitedRulesetPath = ruleset.getCanonicalPath();
                    report.addOperation(new IlrDeploymentOperation(originalRulesetPath, op, commitedRulesetPath, (String)ruleset.getProperties().get("ruleset.managedxom.uris")));
                }
            }
        }
    }
}

