/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.internal;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.res.model.IlrMutableRepository;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRCERulesetArchive;
import ilog.rules.res.model.IlrRESRulesetArchive;
import ilog.rules.res.model.IlrRepository;
import ilog.rules.res.model.IlrRepositoryFactory;
import ilog.rules.res.model.IlrRuleAppInformation;
import ilog.rules.res.model.IlrRulesetArchiveInformation;
import ilog.rules.res.model.IlrRulesetArchiveProperties;
import ilog.rules.res.model.IlrVersion;
import java.util.Date;

public class IlrRulesetArchiveInformationImpl
implements IlrRulesetArchiveInformation {
    private final IlrRepositoryFactory factory;
    private final IlrMutableRulesetArchiveInformation ruleset;

    public IlrRulesetArchiveInformationImpl(IlrRepositoryFactory factory, IlrMutableRulesetArchiveInformation ruleset) {
        this.factory = factory;
        this.ruleset = ruleset;
    }

    @Override
    public IlrRepository getRepository() {
        return this.factory.unmodifiableRepository((IlrMutableRepository)this.ruleset.getRepository());
    }

    @Override
    public IlrRuleAppInformation getRuleApp() {
        return this.factory.unmodifiableRuleApp((IlrMutableRuleAppInformation)this.ruleset.getRuleApp());
    }

    @Override
    public String getName() {
        return this.ruleset.getName();
    }

    @Override
    public IlrVersion getVersion() {
        return this.ruleset.getVersion();
    }

    @Override
    public Date getCreationDate() {
        return this.ruleset.getCreationDate();
    }

    @Override
    public String getDisplayName() {
        return this.ruleset.getDisplayName();
    }

    @Override
    public String getDescription() {
        return this.ruleset.getDescription();
    }

    @Override
    public IlrPath getCanonicalPath() {
        return this.ruleset.getCanonicalPath();
    }

    @Override
    public IlrRulesetArchiveProperties getProperties() {
        return this.ruleset.getProperties();
    }

    @Override
    public IlrRulesetArchive getRulesetArchive() {
        IlrRESRulesetArchive archive = this.ruleset.getRESRulesetArchive();
        if (archive instanceof IlrRCERulesetArchive) {
            return ((IlrRCERulesetArchive)this.ruleset.getRESRulesetArchive()).getRulesetArchive();
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IlrRulesetArchiveInformationImpl)) {
            return false;
        }
        return this.ruleset.equals(((IlrRulesetArchiveInformationImpl)obj).ruleset);
    }

    public int hashCode() {
        return this.ruleset.hashCode();
    }

    public String toString() {
        return this.ruleset.toString();
    }

    @Override
    public IlrRESRulesetArchive getRESRulesetArchive() {
        return this.ruleset.getRESRulesetArchive();
    }
}

