/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.model.xml;

import com.ibm.rules.res.model.XOMInformation;
import com.ibm.rules.res.model.XOMLibraryInformation;
import com.ibm.rules.res.model.XOMResourceId;
import com.ibm.rules.res.model.XOMResourceInformation;
import com.ibm.rules.res.model.internal.XOMInternalNameUtil;
import com.ibm.rules.res.model.internal.XOMLibraryIdImpl;
import com.ibm.rules.res.model.internal.XOMLibraryInformationImpl;
import com.ibm.rules.res.model.internal.XOMResourceIdImpl;
import com.ibm.rules.res.model.internal.XOMResourceInformationImpl;
import com.ibm.rules.res.persistence.internal.SHA1ChecksumProvider;
import ilog.rules.res.model.IlrAlreadyExistException;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrIllegalArgumentRuntimeException;
import ilog.rules.res.model.IlrMutableRuleAppInformation;
import ilog.rules.res.model.IlrMutableRulesetArchiveInformation;
import ilog.rules.res.model.IlrRepositoryFactory;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.model.xml.IlrErrorHandlerImpl;
import ilog.rules.res.model.xml.IlrResourceEntityResolver;
import ilog.rules.res.util.xml.IlrDOMUtil;
import ilog.rules.res.util.xml.IlrXMLSerializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class IlrRuleAppArchiveDescriptor {
    public static final String SCHEMA_LOCATION = "http://schemas.ilog.com/JRules/1.2/RuleAppArchive";
    public static final String ELEMENT_RULEAPP_ARCHIVE = "ruleapp-archive";
    public static final String ELEMENT_RULEAPP = "ruleapp";
    public static final String ELEMENT_RULEAPP_NAME = "ruleapp-name";
    public static final String ELEMENT_RULEAPP_DISPLAY_NAME = "ruleapp-display-name";
    public static final String ELEMENT_RULEAPP_VERSION = "ruleapp-version";
    public static final String ELEMENT_RULEAPP_DESCRIPTION = "ruleapp-description";
    public static final String ELEMENT_RULEAPP_CREATION_DATE = "creation-date";
    public static final String ELEMENT_RULEAPP_PROPERTY = "ruleapp-property";
    public static final String ELEMENT_RULEAPP_PROPERTY_NAME = "ruleapp-property-name";
    public static final String ELEMENT_RULEAPP_PROPERTY_VALUE = "ruleapp-property-value";
    public static final String ELEMENT_RULESET = "ruleset";
    public static final String ELEMENT_RULESET_NAME = "ruleset-name";
    public static final String ELEMENT_RULESET_DISPLAY_NAME = "ruleset-display-name";
    public static final String ELEMENT_RULESET_CREATION_DATE = "creation-date";
    public static final String ELEMENT_RULESET_VERSION = "ruleset-version";
    public static final String ELEMENT_RULESET_DESCRIPTION = "ruleset-description";
    public static final String ELEMENT_RULESET_PROPERTY = "ruleset-property";
    public static final String ELEMENT_RULESET_PROPERTY_NAME = "ruleset-property-name";
    public static final String ELEMENT_RULESET_PROPERTY_VALUE = "ruleset-property-value";
    public static final String ELEMENT_XOM = "xom";
    public static final String ELEMENT_XOM_TYPE = "xom-type";
    public static final String LIBRARY_XOM_TYPE = "Library";
    public static final String RESOURCE_XOM_TYPE = "Resource";
    public static final String ELEMENT_XOM_NAME = "xom-name";
    public static final String ELEMENT_XOM_VERSION = "xom-version";
    public static final String ELEMENT_XOM_SHA1 = "xom-sha1";
    public static final String ELEMENT_XOM_CREATION_DATE = "creation-date";
    public static final String ELEMENT_XOM_URL = "xom-url";
    private DocumentBuilderFactory documentBuilderFactory;
    private final boolean validating;

    public IlrRuleAppArchiveDescriptor() {
        this(true);
    }

    public IlrRuleAppArchiveDescriptor(boolean validating) {
        this.validating = validating;
    }

    public Set<IlrMutableRuleAppInformation> load(Set<XOMInformation> xomInfosToComplete, IlrRepositoryFactory repositoryFactory, InputStream input) throws ParserConfigurationException, SAXException, IOException, IlrAlreadyExistException, IlrFormatException, IlrIllegalArgumentRuntimeException {
        IlrErrorHandlerImpl handler = new IlrErrorHandlerImpl();
        DocumentBuilder documentBuilder = this.createDocumentBuilder(handler);
        Document document = documentBuilder.parse(input);
        if (handler.hasErrors() || handler.hasFatalErrors()) {
            throw handler.getFirstErrorException();
        }
        NodeList ruleApps = IlrDOMUtil.getChildElementsByTagName(document.getDocumentElement(), ELEMENT_RULEAPP);
        HashSet<IlrMutableRuleAppInformation> result = new HashSet<IlrMutableRuleAppInformation>();
        for (int i = 0; i < ruleApps.getLength(); ++i) {
            IlrMutableRuleAppInformation ruleApp = this.loadRuleApp(repositoryFactory, (Element)ruleApps.item(i));
            result.add(ruleApp);
        }
        if (xomInfosToComplete != null) {
            NodeList xoms = IlrDOMUtil.getChildElementsByTagName(document.getDocumentElement(), ELEMENT_XOM);
            for (int i = 0; i < xoms.getLength(); ++i) {
                XOMInformation xom = this.loadXOMInformation(repositoryFactory, (Element)xoms.item(i));
                xomInfosToComplete.add(xom);
            }
        }
        return result;
    }

    public void save(Set<IlrMutableRuleAppInformation> ruleApps, Set<XOMInformation> xomInfos, OutputStream output) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(output, "UTF-8");
        IlrXMLSerializer serializer = new IlrXMLSerializer(writer);
        serializer.writeXMLDeclaration();
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        attributes.put("xsi:noNamespaceSchemaLocation", SCHEMA_LOCATION);
        serializer.writeStartTag(ELEMENT_RULEAPP_ARCHIVE, attributes, true);
        for (IlrMutableRuleAppInformation ruleApp : ruleApps) {
            this.save(ruleApp, serializer);
        }
        if (xomInfos != null) {
            for (XOMInformation xomInfo : xomInfos) {
                this.save(xomInfo, serializer);
            }
        }
        serializer.writeEndTag(ELEMENT_RULEAPP_ARCHIVE);
        writer.flush();
    }

    private synchronized DocumentBuilderFactory getDocumentBuilderFactory() {
        if (this.documentBuilderFactory == null) {
            this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.documentBuilderFactory.setNamespaceAware(true);
            try {
                this.documentBuilderFactory.setAttribute("http://apache.org/xml/features/validation/schema", this.validating ? Boolean.TRUE : Boolean.FALSE);
                this.documentBuilderFactory.setValidating(this.validating);
            }
            catch (IllegalArgumentException e) {
                this.documentBuilderFactory.setValidating(false);
            }
        }
        return this.documentBuilderFactory;
    }

    private DocumentBuilder createDocumentBuilder(ErrorHandler errorHandler) throws ParserConfigurationException {
        DocumentBuilder documentBuilder = this.getDocumentBuilderFactory().newDocumentBuilder();
        documentBuilder.setEntityResolver(new IlrResourceEntityResolver("ilog/rules/res/model/xml"));
        documentBuilder.setErrorHandler(errorHandler);
        return documentBuilder;
    }

    private void save(IlrMutableRuleAppInformation ruleApp, IlrXMLSerializer serializer) throws IOException {
        serializer.writeStartTag(ELEMENT_RULEAPP, true);
        String displayName = ruleApp.getDisplayName();
        if (displayName != null) {
            serializer.writeStartTag(ELEMENT_RULEAPP_DISPLAY_NAME, false);
            serializer.writeBody(displayName);
            serializer.writeEndTag(ELEMENT_RULEAPP_DISPLAY_NAME);
        }
        serializer.writeStartTag(ELEMENT_RULEAPP_NAME, false);
        serializer.writeBody(ruleApp.getName());
        serializer.writeEndTag(ELEMENT_RULEAPP_NAME);
        serializer.writeStartTag(ELEMENT_RULEAPP_VERSION, false);
        serializer.writeBody(ruleApp.getVersion().toString());
        serializer.writeEndTag(ELEMENT_RULEAPP_VERSION);
        serializer.writeStartTag("creation-date", false);
        serializer.writeBody(Long.toString(ruleApp.getCreationDate().getTime()));
        serializer.writeEndTag("creation-date");
        String description = ruleApp.getDescription();
        if (description != null) {
            serializer.writeStartTag(ELEMENT_RULEAPP_DESCRIPTION, false);
            serializer.writeBody(description);
            serializer.writeEndTag(ELEMENT_RULEAPP_DESCRIPTION);
        }
        for (Map.Entry entry : ruleApp.getProperties().entrySet()) {
            serializer.writeStartTag(ELEMENT_RULEAPP_PROPERTY, true);
            serializer.writeStartTag(ELEMENT_RULEAPP_PROPERTY_NAME, false);
            serializer.writeBody((String)entry.getKey());
            serializer.writeEndTag(ELEMENT_RULEAPP_PROPERTY_NAME);
            serializer.writeStartTag(ELEMENT_RULEAPP_PROPERTY_VALUE, false);
            serializer.writeBody((String)entry.getValue());
            serializer.writeEndTag(ELEMENT_RULEAPP_PROPERTY_VALUE);
            serializer.writeEndTag(ELEMENT_RULEAPP_PROPERTY);
        }
        for (IlrMutableRulesetArchiveInformation ruleset : ruleApp.getRulesets()) {
            this.save(ruleset, serializer);
        }
        serializer.writeEndTag(ELEMENT_RULEAPP);
    }

    private void save(XOMInformation xomInfo, IlrXMLSerializer serializer) throws IOException {
        String type = null;
        String sha1 = null;
        ArrayList<String> urls = new ArrayList<String>();
        if (xomInfo instanceof XOMResourceInformation) {
            type = RESOURCE_XOM_TYPE;
            byte[] sha1byte = ((XOMResourceInformation)xomInfo).getSHA1();
            sha1 = sha1byte != null ? SHA1ChecksumProvider.toHexString(sha1byte) : null;
            urls.add(XOMInternalNameUtil.getNameAsFile(xomInfo.getName(), xomInfo.getVersion()));
        } else if (xomInfo instanceof XOMLibraryInformation) {
            String[] resources;
            type = LIBRARY_XOM_TYPE;
            for (String resourceID : resources = ((XOMLibraryInformation)xomInfo).getResources()) {
                XOMResourceId tmp;
                if (!resourceID.startsWith("resuri://")) continue;
                try {
                    tmp = XOMInternalNameUtil.getXOMResourceId(resourceID.substring(XOMResourceId.RES_URI_PROTOCOL_START_LENGTH));
                }
                catch (IlrFormatException e) {
                    throw new IOException(e.getMessage());
                }
                urls.add(XOMInternalNameUtil.getNameAsFile(tmp.getName(), tmp.getVersion()));
            }
        } else {
            return;
        }
        serializer.writeStartTag(ELEMENT_XOM, true);
        serializer.writeStartTag(ELEMENT_XOM_TYPE, false);
        serializer.writeBody(type);
        serializer.writeEndTag(ELEMENT_XOM_TYPE);
        serializer.writeStartTag(ELEMENT_XOM_NAME, false);
        serializer.writeBody(xomInfo.getName());
        serializer.writeEndTag(ELEMENT_XOM_NAME);
        serializer.writeStartTag(ELEMENT_XOM_VERSION, false);
        serializer.writeBody(xomInfo.getVersion().toString());
        serializer.writeEndTag(ELEMENT_XOM_VERSION);
        if (sha1 != null) {
            serializer.writeStartTag(ELEMENT_XOM_SHA1, false);
            serializer.writeBody(sha1);
            serializer.writeEndTag(ELEMENT_XOM_SHA1);
        }
        if (xomInfo.getDate() != null) {
            serializer.writeStartTag("creation-date", false);
            serializer.writeBody(Long.toString(xomInfo.getDate().getTime()));
            serializer.writeEndTag("creation-date");
        }
        for (String url : urls) {
            serializer.writeStartTag(ELEMENT_XOM_URL, false);
            serializer.writeBody(url);
            serializer.writeEndTag(ELEMENT_XOM_URL);
        }
        serializer.writeEndTag(ELEMENT_XOM);
    }

    private void save(IlrMutableRulesetArchiveInformation ruleset, IlrXMLSerializer serializer) throws IOException {
        serializer.writeStartTag(ELEMENT_RULESET, true);
        String displayName = ruleset.getDisplayName();
        if (displayName != null) {
            serializer.writeStartTag(ELEMENT_RULESET_DISPLAY_NAME, false);
            serializer.writeBody(displayName);
            serializer.writeEndTag(ELEMENT_RULESET_DISPLAY_NAME);
        }
        serializer.writeStartTag(ELEMENT_RULESET_NAME, false);
        serializer.writeBody(ruleset.getName());
        serializer.writeEndTag(ELEMENT_RULESET_NAME);
        serializer.writeStartTag(ELEMENT_RULESET_VERSION, false);
        serializer.writeBody(ruleset.getVersion().toString());
        serializer.writeEndTag(ELEMENT_RULESET_VERSION);
        serializer.writeStartTag("creation-date", false);
        serializer.writeBody(Long.toString(ruleset.getCreationDate().getTime()));
        serializer.writeEndTag("creation-date");
        String description = ruleset.getDescription();
        if (description != null) {
            serializer.writeStartTag(ELEMENT_RULESET_DESCRIPTION, false);
            serializer.writeBody(description);
            serializer.writeEndTag(ELEMENT_RULESET_DESCRIPTION);
        }
        for (Map.Entry entry : ruleset.getProperties().entrySet()) {
            serializer.writeStartTag(ELEMENT_RULESET_PROPERTY, true);
            serializer.writeStartTag(ELEMENT_RULESET_PROPERTY_NAME, false);
            serializer.writeBody((String)entry.getKey());
            serializer.writeEndTag(ELEMENT_RULESET_PROPERTY_NAME);
            serializer.writeStartTag(ELEMENT_RULESET_PROPERTY_VALUE, false);
            serializer.writeBody((String)entry.getValue());
            serializer.writeEndTag(ELEMENT_RULESET_PROPERTY_VALUE);
            serializer.writeEndTag(ELEMENT_RULESET_PROPERTY);
        }
        serializer.writeEndTag(ELEMENT_RULESET);
    }

    private IlrMutableRuleAppInformation loadRuleApp(IlrRepositoryFactory repositoryFactory, Element ruleAppElement) throws IlrAlreadyExistException, IlrFormatException, IlrIllegalArgumentRuntimeException {
        Element descriptionElement;
        Element creationDateElement;
        Element versionElement;
        String name = null;
        IlrVersion version = null;
        Date creationDate = null;
        Element nameElement = IlrDOMUtil.getFirstElementByTagName(ruleAppElement, ELEMENT_RULEAPP_NAME);
        if (nameElement != null) {
            name = IlrDOMUtil.textNodesToString(nameElement.getChildNodes());
        }
        if ((versionElement = IlrDOMUtil.getFirstElementByTagName(ruleAppElement, ELEMENT_RULEAPP_VERSION)) != null) {
            String versionStr = IlrDOMUtil.textNodesToString(versionElement.getChildNodes());
            version = IlrVersion.parseVersion(versionStr);
        }
        if ((creationDateElement = IlrDOMUtil.getFirstElementByTagName(ruleAppElement, "creation-date")) != null) {
            String dateStr = IlrDOMUtil.textNodesToString(creationDateElement.getChildNodes());
            creationDate = new Date(Long.parseLong(dateStr));
        }
        IlrMutableRuleAppInformation ruleApp = repositoryFactory.createRuleApp(name, version, creationDate);
        Element displayNameElement = IlrDOMUtil.getFirstElementByTagName(ruleAppElement, ELEMENT_RULEAPP_DISPLAY_NAME);
        if (displayNameElement != null) {
            ruleApp.setDisplayName(IlrDOMUtil.textNodesToString(displayNameElement.getChildNodes()));
        }
        if ((descriptionElement = IlrDOMUtil.getFirstElementByTagName(ruleAppElement, ELEMENT_RULEAPP_DESCRIPTION)) != null) {
            ruleApp.setDescription(IlrDOMUtil.textNodesToString(descriptionElement.getChildNodes()));
        }
        this.loadRuleAppProperties(ruleAppElement, ruleApp);
        NodeList rulesetElements = IlrDOMUtil.getChildElementsByTagName(ruleAppElement, ELEMENT_RULESET);
        for (int i = 0; i < rulesetElements.getLength(); ++i) {
            Element rulesetElement = (Element)rulesetElements.item(i);
            IlrMutableRulesetArchiveInformation ruleset = this.loadRuleset(repositoryFactory, rulesetElement);
            ruleApp.addRuleset(ruleset);
        }
        return ruleApp;
    }

    private XOMInformation loadXOMInformation(IlrRepositoryFactory repositoryFactory, Element xomElement) throws IlrAlreadyExistException, IlrFormatException, IlrIllegalArgumentRuntimeException {
        Element sha1Element;
        Element creationDateElement;
        Element versionElement;
        Element nameElement;
        String type = null;
        String name = null;
        String sha1hex = null;
        IlrVersion version = null;
        Date creationDate = null;
        ArrayList<String> urlList = new ArrayList<String>();
        Element typeElement = IlrDOMUtil.getFirstElementByTagName(xomElement, ELEMENT_XOM_TYPE);
        if (typeElement != null) {
            type = IlrDOMUtil.textNodesToString(typeElement.getChildNodes());
        }
        if ((nameElement = IlrDOMUtil.getFirstElementByTagName(xomElement, ELEMENT_XOM_NAME)) != null) {
            name = IlrDOMUtil.textNodesToString(nameElement.getChildNodes());
        }
        if ((versionElement = IlrDOMUtil.getFirstElementByTagName(xomElement, ELEMENT_XOM_VERSION)) != null) {
            String versionStr = IlrDOMUtil.textNodesToString(versionElement.getChildNodes());
            version = IlrVersion.parseVersion(versionStr);
        }
        if ((creationDateElement = IlrDOMUtil.getFirstElementByTagName(xomElement, "creation-date")) != null) {
            String dateStr = IlrDOMUtil.textNodesToString(creationDateElement.getChildNodes());
            creationDate = new Date(Long.parseLong(dateStr));
        }
        if ((sha1Element = IlrDOMUtil.getFirstElementByTagName(xomElement, ELEMENT_XOM_SHA1)) != null) {
            sha1hex = IlrDOMUtil.textNodesToString(sha1Element.getChildNodes());
        }
        NodeList urlElements = IlrDOMUtil.getChildElementsByTagName(xomElement, ELEMENT_XOM_URL);
        for (int i = 0; i < urlElements.getLength(); ++i) {
            Element urlElement = (Element)urlElements.item(i);
            if (urlElement == null) continue;
            XOMResourceId fileName = XOMInternalNameUtil.fromNameAsFile(IlrDOMUtil.textNodesToString(urlElement.getChildNodes()));
            if (fileName != null) {
                urlList.add("resuri://" + fileName.toString());
                continue;
            }
            urlList.add("resuri://" + IlrDOMUtil.textNodesToString(urlElement.getChildNodes()));
        }
        if (RESOURCE_XOM_TYPE.equals(type)) {
            XOMResourceIdImpl resourceId = new XOMResourceIdImpl(name, version);
            resourceId.setDate(creationDate);
            if (sha1hex != null) {
                resourceId.setSHA1(SHA1ChecksumProvider.fromHexString(sha1hex));
            }
            return new XOMResourceInformationImpl((XOMResourceId)resourceId, (byte[])null);
        }
        if (LIBRARY_XOM_TYPE.equals(type)) {
            XOMLibraryIdImpl libraryId = new XOMLibraryIdImpl(name, version);
            libraryId.setDate(creationDate);
            String[] uris = null;
            if (urlList.size() > 0) {
                uris = urlList.toArray(new String[urlList.size()]);
            }
            return new XOMLibraryInformationImpl(libraryId, uris);
        }
        return null;
    }

    private IlrMutableRulesetArchiveInformation loadRuleset(IlrRepositoryFactory repositoryFactory, Element rulesetElement) throws IlrFormatException, IlrIllegalArgumentRuntimeException {
        Element descriptionElement;
        Element creationDateElement;
        Element versionElement;
        String name = null;
        IlrVersion version = null;
        Date creationDate = null;
        Element nameElement = IlrDOMUtil.getFirstElementByTagName(rulesetElement, ELEMENT_RULESET_NAME);
        if (nameElement != null) {
            name = IlrDOMUtil.textNodesToString(nameElement.getChildNodes());
        }
        if ((versionElement = IlrDOMUtil.getFirstElementByTagName(rulesetElement, ELEMENT_RULESET_VERSION)) != null) {
            String versionStr = IlrDOMUtil.textNodesToString(versionElement.getChildNodes());
            version = IlrVersion.parseVersion(versionStr);
        }
        if ((creationDateElement = IlrDOMUtil.getFirstElementByTagName(rulesetElement, "creation-date")) != null) {
            String dateStr = IlrDOMUtil.textNodesToString(creationDateElement.getChildNodes());
            creationDate = new Date(Long.parseLong(dateStr));
        }
        IlrMutableRulesetArchiveInformation ruleset = repositoryFactory.createRuleset(name, version, creationDate);
        Element displayNameElement = IlrDOMUtil.getFirstElementByTagName(rulesetElement, ELEMENT_RULESET_DISPLAY_NAME);
        if (displayNameElement != null) {
            ruleset.setDisplayName(IlrDOMUtil.textNodesToString(displayNameElement.getChildNodes()));
        }
        if ((descriptionElement = IlrDOMUtil.getFirstElementByTagName(rulesetElement, ELEMENT_RULESET_DESCRIPTION)) != null) {
            ruleset.setDescription(IlrDOMUtil.textNodesToString(descriptionElement.getChildNodes()));
        }
        this.loadRulesetProperties(rulesetElement, ruleset);
        return ruleset;
    }

    private void loadRuleAppProperties(Element ruleAppElement, IlrMutableRuleAppInformation ruleApp) {
        NodeList propertyElements = IlrDOMUtil.getChildElementsByTagName(ruleAppElement, ELEMENT_RULEAPP_PROPERTY);
        for (int i = 0; i < propertyElements.getLength(); ++i) {
            Element propertyElement = (Element)propertyElements.item(i);
            Element propertyNameElement = IlrDOMUtil.getFirstElementByTagName(propertyElement, ELEMENT_RULEAPP_PROPERTY_NAME);
            Element propertyValueElement = IlrDOMUtil.getFirstElementByTagName(propertyElement, ELEMENT_RULEAPP_PROPERTY_VALUE);
            String propertyName = IlrDOMUtil.textNodesToString(propertyNameElement.getChildNodes());
            String propertyValue = IlrDOMUtil.textNodesToString(propertyValueElement.getChildNodes());
            ruleApp.setProperty(propertyName, propertyValue);
        }
    }

    private void loadRulesetProperties(Element rulesetElement, IlrMutableRulesetArchiveInformation ruleset) {
        NodeList propertyElements = IlrDOMUtil.getChildElementsByTagName(rulesetElement, ELEMENT_RULESET_PROPERTY);
        for (int i = 0; i < propertyElements.getLength(); ++i) {
            Element propertyElement = (Element)propertyElements.item(i);
            Element propertyNameElement = IlrDOMUtil.getFirstElementByTagName(propertyElement, ELEMENT_RULESET_PROPERTY_NAME);
            Element propertyValueElement = IlrDOMUtil.getFirstElementByTagName(propertyElement, ELEMENT_RULESET_PROPERTY_VALUE);
            String propertyName = IlrDOMUtil.textNodesToString(propertyNameElement.getChildNodes());
            String propertyValue = IlrDOMUtil.textNodesToString(propertyValueElement.getChildNodes());
            ruleset.setProperty(propertyName, propertyValue);
        }
    }
}

