/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.mprofiler.xml;

import ilog.rules.res.mprofiler.IlrFieldInfo;
import ilog.rules.res.mprofiler.IlrObjectInfo;
import ilog.rules.tools.IlrVersionFullInfo;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class IlrXMLWriter {
    public void write(IlrObjectInfo info, Writer writer) throws IOException {
        ArrayList<IlrObjectInfo> infos = new ArrayList<IlrObjectInfo>();
        infos.add(info);
        infos.addAll(info.getLinkedObjectsInfo());
        this.write(infos, writer);
    }

    public void write(List<? extends IlrObjectInfo> infos, Writer writer) throws IOException {
        writer = new BufferedWriter(writer);
        writer.write("<memory jrules-version='" + IlrVersionFullInfo.getFullVersionNumber() + "'>\n");
        for (IlrObjectInfo ilrObjectInfo : infos) {
            this.writeObjectInfo(ilrObjectInfo, writer);
        }
        writer.write("</memory>\n");
        writer.flush();
    }

    protected void writeObjectInfo(IlrObjectInfo info, Writer writer) throws IOException {
        String valueAttr = this.toValueAttr(info.getValue());
        StringBuffer buffer = new StringBuffer();
        buffer.append("<object id='");
        buffer.append(info.getId());
        buffer.append("' size='");
        buffer.append(info.getSize());
        buffer.append("' class='");
        buffer.append(info.getObjectClassName());
        buffer.append("'");
        buffer.append(valueAttr);
        buffer.append(">\n");
        for (IlrFieldInfo fieldInfo : info.getFields()) {
            if (fieldInfo.isPrimitive()) {
                buffer.append(" <field name='");
                buffer.append(fieldInfo.getName());
                buffer.append("' class='");
                buffer.append(fieldInfo.getObjectClassName());
                buffer.append("'");
                buffer.append(this.toValueAttr(fieldInfo.getValue()));
                buffer.append("/>\n");
                continue;
            }
            if (fieldInfo.getObjectInfo() == null) {
                buffer.append("<field name='");
                buffer.append(fieldInfo.getName());
                buffer.append("' class='");
                buffer.append(fieldInfo.getObjectClassName());
                buffer.append("' />\n");
                continue;
            }
            buffer.append("<field name='");
            buffer.append(fieldInfo.getName());
            buffer.append("' id='");
            buffer.append(fieldInfo.getObjectInfo().getId());
            buffer.append("' />\n");
        }
        for (IlrObjectInfo entryInfo : info.getArrayEntries()) {
            buffer.append("<array-entry id='");
            buffer.append(entryInfo.getId() + "'/>\n");
        }
        buffer.append("</object>\n");
        writer.write(buffer.toString());
    }

    protected String toValueAttr(String value) {
        if (value == null) {
            return "";
        }
        return " value='" + this.toXMLString(value) + "'";
    }

    protected String toXMLString(String string) {
        String result = string.replaceAll("&", "&amp;");
        result = result.replaceAll("<", "&lt;");
        result = result.replaceAll("'", "&apos;");
        result = result.replaceAll(">", "&gt;");
        return result;
    }
}

