/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.file.helper;

import ilog.rules.archive.IlrRulesetArchive;
import ilog.rules.res.model.internal.IlrReadOnlyProperties;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.impl.IlrDAOLocalization;
import ilog.rules.res.persistence.impl.file.security.IlrDeletePrivilegedAction;
import ilog.rules.res.persistence.impl.file.security.IlrFileInputStreamPrivilegedAction;
import ilog.rules.res.persistence.impl.file.security.IlrFileOutputStreamPrivilegedAction;
import ilog.rules.res.util.IlrRulesetArchiveExtractor;
import ilog.rules.res.util.io.IlrFileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PrivilegedActionException;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class IlrFile {
    private static final String ENCODING = "UTF-8";
    public static final String CREATION_DATE_FILE_NAME = "creation_date.txt";
    public static final String DISPLAY_NAME_FILE_NAME = "display_name.txt";
    public static final String DESCRIPTION_FILE_NAME = "description.txt";
    public static final String PROPERTIES_FILE_NAME = "properties.txt";
    public static final String ARCHIVE_FILE_NAME = "ruleset.jar";
    public static final String ARCHIVE_DE_FILE_NAME = "ruleset.dsar";
    public static final String ARCHIVE_DIR_NAME = "archive";
    public static final String XOM_FILE_NAME = "xom.jar";

    public static Date getCreationDate(File file) throws IlrDAOException {
        FileInputStream inputStream = IlrFileInputStreamPrivilegedAction.execute(file);
        if (inputStream == null) {
            return null;
        }
        try {
            String content = IlrFile.getStringContent(file);
            if (content == null || content.length() == 0) {
                throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.CREATION_DATE_FILE_ERROR, new String[]{file.getAbsolutePath()});
            }
            try {
                long creationDate = Long.parseLong(content);
                Date date = new Date(creationDate);
                return date;
            }
            catch (NumberFormatException e) {
                try {
                    throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.CREATION_DATE_FILE_ERROR, new String[]{file.getAbsolutePath()}, e);
                }
                catch (IOException e2) {
                    throw IlrDAOLocalization.newIlrDAOException(IlrDAOLocalization.CREATION_DATE_FILE_ERROR, new String[]{file.getAbsolutePath()}, e2);
                }
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getStringContent(File file) throws IOException {
        byte[] content = IlrFile.getContent(file);
        if (content != null) {
            return new String(content, ENCODING);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getContent(File file) throws IOException {
        FileInputStream inputStream = IlrFileInputStreamPrivilegedAction.execute(file);
        if (inputStream == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        BufferedInputStream buff = new BufferedInputStream(inputStream);
        try {
            byte[] buffer = new byte[2048];
            int i = 0;
            while ((i = buff.read(buffer)) != -1) {
                outputStream.write(buffer, 0, i);
            }
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            try {
                buff.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties(File file) throws IOException {
        Properties props = new Properties();
        FileInputStream inputStream = IlrFileInputStreamPrivilegedAction.execute(file);
        if (inputStream == null) {
            return props;
        }
        BufferedInputStream buff = new BufferedInputStream(inputStream);
        try {
            props.load(buff);
        }
        finally {
            try {
                buff.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCreationDate(File file, long date) throws PrivilegedActionException, IOException {
        FileOutputStream outputStream = IlrFileOutputStreamPrivilegedAction.execute(file);
        try {
            outputStream.write(Long.toString(date).getBytes(ENCODING));
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setContent(File file, String content) throws PrivilegedActionException, IOException {
        if (content != null) {
            IlrFile.setContent(file, content.getBytes(ENCODING));
        } else {
            IlrDeletePrivilegedAction.execute(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContent(File file, byte[] content) throws PrivilegedActionException, IOException {
        FileOutputStream outputStream = IlrFileOutputStreamPrivilegedAction.execute(file);
        try {
            outputStream.write(content);
        }
        finally {
            try {
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void setProperties(File file, IlrReadOnlyProperties props) throws PrivilegedActionException, IOException {
        Properties properties = new Properties();
        for (Map.Entry<String, String> entry : props.entrySet()) {
            properties.put(entry.getKey(), entry.getValue());
        }
        IlrFile.setProperties(file, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProperties(File file, Properties properties) throws PrivilegedActionException, IOException {
        FileOutputStream outputStream = IlrFileOutputStreamPrivilegedAction.execute(file);
        BufferedOutputStream buff = new BufferedOutputStream(outputStream);
        try {
            properties.store(buff, null);
        }
        finally {
            try {
                buff.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File keyToFile(File dir, String key) {
        File result = dir;
        StringTokenizer st = new StringTokenizer(key, "/");
        while (st.hasMoreTokens()) {
            result = new File(result, st.nextToken());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRESRulesetArchive(File file, InputStream stream) throws PrivilegedActionException, IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = IlrFileOutputStreamPrivilegedAction.execute(file);
            IlrFileUtil.copy(stream, outputStream);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IlrRulesetArchive getRulesetArchive(File file) throws IOException {
        FileInputStream inputStream = null;
        try {
            inputStream = IlrFileInputStreamPrivilegedAction.execute(file);
            if (inputStream != null) {
                BufferedInputStream bis = new BufferedInputStream(inputStream);
                IlrRulesetArchive ilrRulesetArchive = IlrRulesetArchiveExtractor.extract(bis);
                return ilrRulesetArchive;
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

