/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.file.security;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public final class IlrDeletePrivilegedAction
implements PrivilegedExceptionAction<Boolean> {
    private final File file;

    private IlrDeletePrivilegedAction(File file) {
        this.file = file;
    }

    @Override
    public Boolean run() {
        return this.delete(this.file) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean execute(File file) throws PrivilegedActionException {
        Boolean result = AccessController.doPrivileged(new IlrDeletePrivilegedAction(file));
        return result;
    }

    private boolean delete(File f) {
        boolean deleted = true;
        File[] subFiles = f.listFiles();
        if (subFiles != null) {
            for (File subFile : subFiles) {
                if (this.delete(subFile)) continue;
                deleted = false;
            }
        }
        if (!f.delete()) {
            deleted = false;
        }
        return deleted;
    }
}

