/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.file.security;

import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.internal.IlrNameValidator;
import java.io.File;
import java.io.FileFilter;

public class IlrDirectoryNameFilter
implements FileFilter {
    private final boolean isRuleApp;

    public IlrDirectoryNameFilter(boolean isRuleApp) {
        this.isRuleApp = isRuleApp;
    }

    @Override
    public boolean accept(File pathname) {
        if (pathname.isDirectory()) {
            try {
                if (this.isRuleApp) {
                    IlrNameValidator.validateRuleAppName(pathname.getName());
                } else {
                    IlrNameValidator.validateRulesetName(pathname.getName());
                }
                return true;
            }
            catch (IlrFormatException ilrFormatException) {
                // empty catch block
            }
        }
        return false;
    }
}

