/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.file.security;

import java.io.File;
import java.io.FileFilter;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class IlrListFilesPrivilegedAction
implements PrivilegedAction<File[]> {
    private final File dir;
    private final FileFilter filter;

    private IlrListFilesPrivilegedAction(File dir, FileFilter filter) {
        this.dir = dir;
        this.filter = filter;
    }

    @Override
    public File[] run() {
        return this.dir.listFiles(this.filter);
    }

    public static File[] execute(File dir, FileFilter filter) {
        return AccessController.doPrivileged(new IlrListFilesPrivilegedAction(dir, filter));
    }
}

