/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.jdbc.helper;

import com.ibm.rules.res.logging.internal.RESLogger;
import ilog.rules.res.persistence.impl.jdbc.IlrDAOConfigurator;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDatabaseUtility;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class IlrConfigParametersTable {
    private static final RESLogger LOGGER = RESLogger.getRESLogger("com.ibm.rules.res.persistence.sql", "ilog.rules.res.persistence.impl.messages");
    private static final String SQLST_SELECT_CONFIG_PARAMS = "select_application_config_group";
    private static final String SQLST_INSERT_CONFIG_PARAM = "insert_application_config_param";
    private static final String SQLST_DELETE_CONFIG_PARAM = "delete_application_config_param";
    private static final String SQLST_UPDATE_CONFIG_PARAM = "update_application_config";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean insert(IlrDAOConfigurator configurator, Connection connection, String parameterKey, String parameterValue) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_INSERT_CONFIG_PARAM);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, parameterKey);
            statement.setString(2, parameterValue);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(parameterKey);
                parameterValues.add(parameterValue);
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> select(IlrDAOConfigurator configurator, Connection connection) throws SQLException {
        HashMap<String, String> hashMap;
        String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_CONFIG_PARAMS);
        PreparedStatement statement = null;
        ResultSet rs = null;
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            statement = connection.prepareStatement(sqlStatement);
            rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, new ArrayList<String>());
            while (rs.next()) {
                params.put(rs.getString(1), rs.getString(2));
            }
            hashMap = params;
        }
        catch (Throwable throwable) {
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            throw throwable;
        }
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean update(IlrDAOConfigurator configurator, Connection connection, String parameterKey, String parameterValue) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_UPDATE_CONFIG_PARAM);
        PreparedStatement statement = null;
        try {
            boolean done;
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, parameterKey);
            statement.setString(2, parameterValue);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(parameterKey);
                parameterValues.add(parameterValue);
            }
            boolean bl = done = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) > 0;
            if (!done) {
                done = IlrConfigParametersTable.insert(configurator, connection, parameterKey, parameterValue);
            }
            boolean bl2 = done;
            return bl2;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(IlrDAOConfigurator configurator, Connection connection, String parameterKey) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_DELETE_CONFIG_PARAM);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setString(1, parameterKey);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(parameterKey);
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }
}

