/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.impl.jdbc.helper;

import com.ibm.rules.res.logging.internal.RESLogger;
import com.ibm.rules.res.util.internal.StreamUtil;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrVersion;
import ilog.rules.res.persistence.impl.jdbc.IlrDAOConfigurator;
import ilog.rules.res.persistence.impl.jdbc.helper.IlrDatabaseUtility;
import ilog.rules.res.util.io.IlrFileUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;

public class IlrRulesetResourcesTable {
    private static final RESLogger LOGGER = RESLogger.getRESLogger("com.ibm.rules.res.persistence.sql", "ilog.rules.res.persistence.impl.messages");
    private static final String SQLST_SELECT_RULESET_ARCHIVE = "select_ruleset_archive";
    private static final String SQLST_DELETE_RULESET_ARCHIVE = "delete_ruleset_archive";
    private static final String SQLST_INSERT_RULESET_ARCHIVE = "insert_ruleset_archive";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] get(IlrDAOConfigurator configurator, Connection connection, IlrPath rulesetPath) throws SQLException, IOException {
        ResultSet rs;
        PreparedStatement statement;
        block5: {
            InputStream stream;
            block6: {
                byte[] byArray;
                String sqlStatement = configurator.getSQLStatement(SQLST_SELECT_RULESET_ARCHIVE);
                statement = null;
                rs = null;
                try {
                    statement = connection.prepareStatement(sqlStatement);
                    statement.setString(1, rulesetPath.getRuleAppName());
                    IlrVersion raversion = rulesetPath.getRuleAppVersion();
                    statement.setInt(2, raversion.getMajor());
                    statement.setInt(3, raversion.getMinor());
                    statement.setString(4, rulesetPath.getRulesetName());
                    IlrVersion rsversion = rulesetPath.getRulesetVersion();
                    statement.setInt(5, rsversion.getMajor());
                    statement.setInt(6, rsversion.getMinor());
                    ArrayList<String> parameterValues = new ArrayList<String>();
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        parameterValues.add(rulesetPath.getRuleAppName());
                        parameterValues.add(String.valueOf(String.valueOf(raversion.getMajor())));
                        parameterValues.add(String.valueOf(String.valueOf(raversion.getMinor())));
                        parameterValues.add(rulesetPath.getRulesetName());
                        parameterValues.add(String.valueOf(rsversion.getMajor()));
                        parameterValues.add(String.valueOf(rsversion.getMinor()));
                    }
                    if (!(rs = IlrDatabaseUtility.executeQuery(statement, sqlStatement, parameterValues)).next()) break block5;
                    stream = rs.getBinaryStream(1);
                    if (stream != null) break block6;
                    byArray = null;
                }
                catch (Throwable throwable) {
                    IlrDatabaseUtility.closeStatement(statement);
                    IlrDatabaseUtility.closeResultSet(rs);
                    throw throwable;
                }
                IlrDatabaseUtility.closeStatement(statement);
                IlrDatabaseUtility.closeResultSet(rs);
                return byArray;
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IlrFileUtil.copy(stream, baos);
            byte[] byArray = baos.toByteArray();
            IlrDatabaseUtility.closeStatement(statement);
            IlrDatabaseUtility.closeResultSet(rs);
            return byArray;
        }
        byte[] byArray = null;
        IlrDatabaseUtility.closeStatement(statement);
        IlrDatabaseUtility.closeResultSet(rs);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(IlrDAOConfigurator configurator, Connection connection, int rulesetId) throws SQLException {
        String sqlStatement = configurator.getSQLStatement(SQLST_DELETE_RULESET_ARCHIVE);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setInt(1, rulesetId);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(String.valueOf(String.valueOf(rulesetId)));
            }
            boolean bl = IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues) == 1;
            return bl;
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(IlrDAOConfigurator configurator, Connection connection, int rulesetId, InputStream stream) throws SQLException, IOException {
        byte[] data = StreamUtil.toByteArray(stream);
        String sqlStatement = configurator.getSQLStatement(SQLST_INSERT_RULESET_ARCHIVE);
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(sqlStatement);
            statement.setInt(1, rulesetId);
            statement.setBinaryStream(2, StreamUtil.toStream(data), data.length);
            ArrayList<String> parameterValues = new ArrayList<String>();
            if (LOGGER.isLoggable(Level.FINEST)) {
                parameterValues.add(String.valueOf(String.valueOf(rulesetId)));
                parameterValues.add(data.toString());
            }
            IlrDatabaseUtility.executeUpdate(statement, sqlStatement, parameterValues);
        }
        finally {
            IlrDatabaseUtility.closeStatement(statement);
        }
    }
}

