/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.trace.impl.mem;

import ilog.rules.res.model.trace.IlrDWTrace;
import ilog.rules.res.persistence.impl.IlrTraceQueryImpl;
import ilog.rules.res.persistence.trace.IlrCriteria;
import ilog.rules.res.persistence.trace.IlrTraceDAO;
import ilog.rules.res.persistence.trace.IlrTraceDAOException;
import ilog.rules.res.persistence.trace.IlrTraceIterator;
import ilog.rules.res.persistence.trace.IlrTraceQuery;
import ilog.rules.res.persistence.trace.impl.IlrTraceLocalization;
import ilog.rules.res.persistence.trace.impl.mem.IlrInMemoryTraceIterator;
import ilog.rules.res.session.IlrSessionRequest;
import ilog.rules.res.session.IlrSessionResponse;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class IlrInMemoryTraceDAO
implements IlrTraceDAO {
    private final ConcurrentHashMap<String, IlrDWTrace> traces;

    public IlrInMemoryTraceDAO(ConcurrentHashMap<String, IlrDWTrace> traces) {
        this.traces = traces;
    }

    @Override
    public void beginTransaction() throws IlrTraceDAOException {
    }

    @Override
    public void commit() throws IlrTraceDAOException {
    }

    @Override
    public void rollback() {
    }

    @Override
    public void close() {
    }

    @Override
    public void saveTrace(IlrDWTrace trace, IlrSessionRequest request, IlrSessionResponse response) throws IlrTraceDAOException {
        if (this.traces.containsKey(trace.getExecutionId())) {
            throw IlrTraceLocalization.newIlrTraceDAOException();
        }
        this.traces.put(trace.getExecutionId(), trace);
    }

    @Override
    public IlrTraceIterator findAllTraces() throws IlrTraceDAOException {
        HashSet<IlrDWTrace> allTraces = new HashSet<IlrDWTrace>(this.traces.values());
        return new IlrInMemoryTraceIterator(allTraces);
    }

    @Override
    public void deleteAllTraces() throws IlrTraceDAOException {
        this.traces.clear();
    }

    @Override
    public void deleteTraces(IlrTraceQuery query) throws IlrTraceDAOException {
        IlrTraceIterator it = this.findTraces(query);
        while (it.hasNext()) {
            IlrDWTrace t = (IlrDWTrace)it.next();
            this.traces.remove(t.getExecutionId());
        }
    }

    @Override
    public IlrTraceQuery createQuery() {
        return new IlrTraceQueryImpl();
    }

    private Set<IlrDWTrace> filterTraces(IlrTraceQueryImpl query) throws IlrTraceDAOException {
        Iterator<IlrDWTrace> it = this.traces.values().iterator();
        HashSet<IlrDWTrace> res = new HashSet<IlrDWTrace>();
        IlrCriteria crit = query.getCriteria();
        while (it.hasNext()) {
            IlrDWTrace t = it.next();
            try {
                if (crit != null && !crit.matches(t)) continue;
                res.add(t);
            }
            catch (Exception e) {
                throw IlrTraceLocalization.newIlrTraceDAOException(e);
            }
        }
        return res;
    }

    @Override
    public IlrTraceIterator findTraces(IlrTraceQuery query) throws IlrTraceDAOException {
        if (!(query instanceof IlrTraceQueryImpl)) {
            String queryClass = query.getClass().getName();
            String daoToString = this.toString();
            throw IlrTraceLocalization.newIlrTraceDAOException(IlrTraceLocalization.INVALID_QUERY_TYPE, new String[]{queryClass, daoToString});
        }
        IlrTraceQueryImpl fileQuery = (IlrTraceQueryImpl)query;
        Set<IlrDWTrace> filtered = this.filterTraces(fileQuery);
        return new IlrInMemoryTraceIterator(filtered);
    }

    @Override
    public IlrDWTrace findByExecutionId(String executionId) throws IlrTraceDAOException {
        if (executionId != null) {
            return this.traces.get(executionId);
        }
        return null;
    }
}

