/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.persistence.trace.impl.mem;

import ilog.rules.res.model.trace.IlrDWTrace;
import ilog.rules.res.persistence.trace.IlrTraceIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;

public class IlrInMemoryTraceIterator
implements IlrTraceIterator {
    List<IlrDWTrace> traces;
    int currentIndex = -1;

    public IlrInMemoryTraceIterator(Set<IlrDWTrace> traces) {
        this.traces = new ArrayList<IlrDWTrace>(traces);
    }

    @Override
    public boolean hasNext() {
        return this.currentIndex < this.traces.size() - 1;
    }

    @Override
    public IlrDWTrace next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.currentIndex;
        return this.traces.get(this.currentIndex);
    }

    @Override
    public boolean absolute(int index) {
        if (index > this.traces.size() - 1) {
            return false;
        }
        this.currentIndex = index;
        return true;
    }

    @Override
    public boolean relative(int rows) {
        int rel = this.currentIndex + rows;
        if (rel > this.traces.size() - 1) {
            return false;
        }
        this.currentIndex = rel;
        return true;
    }

    @Override
    public int size() {
        return this.traces.size();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

