/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session;

import com.ibm.rules.res.xu.client.internal.XUClient;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.util.ffdc.FFDCLogger;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.session.IlrManagementSession;
import ilog.rules.res.session.IlrSessionCreationException;
import ilog.rules.res.session.IlrSessionException;
import ilog.rules.res.session.IlrStatefulSession;
import ilog.rules.res.session.IlrStatelessSession;
import ilog.rules.res.session.impl.IlrSessionFactoryBase;
import ilog.rules.res.session.impl.pojo.IlrManagementSessionPOJO;
import ilog.rules.res.session.impl.pojo.IlrStatefulSessionPOJO;
import ilog.rules.res.session.impl.pojo.IlrStatelessSessionPOJO;
import ilog.rules.res.session.util.IlrSessionLocalization;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.cci.ConnectionFactory;

public class IlrPOJOSessionFactory
extends IlrSessionFactoryBase {
    private static final String XU_CF_LOOKUP_FAILURE_ID = "219";
    private WeakReference<ConnectionFactory> connectionFactoryRef;
    private final String xuConnFactoryJNDIName;
    protected transient WeakReference<XUClient> xuClientRef = null;

    public IlrPOJOSessionFactory() {
        this("java:comp/env/eis/XUConnectionFactory", null);
    }

    public IlrPOJOSessionFactory(String xuConnFactoryJNDIName, ClassLoader xomCL) {
        super(xomCL);
        this.xuConnFactoryJNDIName = xuConnFactoryJNDIName == null ? "java:comp/env/eis/XUConnectionFactory" : xuConnFactoryJNDIName;
    }

    @Override
    public IlrStatelessSession createStatelessSession() throws IlrSessionCreationException {
        try {
            return new IlrStatelessSessionPOJO(this, this.getXUClient(), this.getXOMClassLoader());
        }
        catch (Exception e) {
            throw new IlrSessionCreationException(e);
        }
    }

    @Override
    public IlrStatefulSession createStatefulSession(IlrPath rulesetPath, Serializable userData, Map<String, Object> initParameters, boolean forceUptodate, boolean enableInterceptor) throws IlrSessionCreationException {
        try {
            return new IlrStatefulSessionPOJO(this.getXUClient(), this, rulesetPath, userData, initParameters, forceUptodate, enableInterceptor);
        }
        catch (Exception e) {
            throw new IlrSessionCreationException(e);
        }
    }

    @Override
    public IlrManagementSession createManagementSession() throws IlrSessionCreationException {
        return new IlrManagementSessionPOJO(this.getXUClient(), this.getXOMClassLoader());
    }

    public ConnectionFactory getConnectionFactory() {
        if (this.connectionFactoryRef != null) {
            return (ConnectionFactory)this.connectionFactoryRef.get();
        }
        return null;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactoryRef = new WeakReference<ConnectionFactory>(connectionFactory);
    }

    @Override
    protected synchronized XUClient getXUClient() throws IlrSessionCreationException {
        XUClient xuClient = null;
        if (this.xuClientRef != null) {
            xuClient = (XUClient)this.xuClientRef.get();
        }
        if (xuClient == null) {
            xuClient = this.createXUClient();
            this.xuClientRef = new WeakReference<XUClient>(xuClient);
        }
        return xuClient;
    }

    protected XUClient createXUClient() throws IlrSessionCreationException {
        XUClient result;
        ConnectionFactory connectionFactory = this.getConnectionFactory();
        if (connectionFactory == null) {
            try {
                connectionFactory = this.findConnectionFactory(this.xuConnFactoryJNDIName);
                this.setConnectionFactory(connectionFactory);
            }
            catch (Exception e) {
                throw new IlrSessionCreationException(e);
            }
        }
        try {
            result = XUClient.createXUClient(connectionFactory);
        }
        catch (XUException e) {
            throw new IlrSessionCreationException(e);
        }
        return result;
    }

    protected ConnectionFactory findConnectionFactory(String xuConnectionFactoryJndiName) throws NamingException, IlrSessionException {
        Object result;
        InitialContext icontext = new InitialContext();
        try {
            result = icontext.lookup(xuConnectionFactoryJndiName);
        }
        catch (NamingException e) {
            FFDCLogger.log((Throwable)e, (Object)this, (String)this.getClass().getName(), (String)XU_CF_LOOKUP_FAILURE_ID, (Object[])new Object[]{"xuConnectionFactoryJndiName=" + xuConnectionFactoryJndiName});
            throw e;
        }
        finally {
            if (icontext != null) {
                icontext.close();
            }
        }
        if (!(result instanceof ConnectionFactory)) {
            throw new IlrSessionException(IlrSessionLocalization.SESSION_NO_CONNECTION_FACTORY, new String[]{xuConnectionFactoryJndiName});
        }
        return (ConnectionFactory)result;
    }

    public void forceXULookup() throws IlrSessionCreationException {
        this.getXUClient();
    }
}

