/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.config.internal;

import ilog.rules.res.session.config.IlrPersistenceConfig;
import ilog.rules.res.session.config.IlrPersistenceType;
import ilog.rules.res.session.config.internal.IlrDatasourcePersistenceConfigImpl;
import ilog.rules.res.session.config.internal.IlrFilePersistenceConfigImpl;
import ilog.rules.res.session.config.internal.IlrJDBCPersistenceConfigImpl;
import ilog.rules.res.session.internal.IlrIllegalPersistenceTypeException;
import ilog.rules.res.session.util.IlrSessionLocalization;
import java.util.Map;

public class IlrPersistenceConfigImpl
implements IlrPersistenceConfig {
    public static final String PERSISTENCE_TYPE = "persistenceType";
    public static final String PERSISTENCE_PROPERTIES = "persistenceProperties";
    private String customPersistenceType;
    private IlrPersistenceType persistenceType;
    private final IlrFilePersistenceConfigImpl filePersistenceConfig;
    private final IlrDatasourcePersistenceConfigImpl datasourcePersistenceConfig;
    private final IlrJDBCPersistenceConfigImpl jdbcPersistenceConfig;

    IlrPersistenceConfigImpl(Map<String, Object> xuProperties) {
        String type = (String)xuProperties.get(PERSISTENCE_TYPE);
        try {
            this.persistenceType = IlrPersistenceType.parse(type);
        }
        catch (IlrIllegalPersistenceTypeException e) {
            this.customPersistenceType = type;
        }
        this.filePersistenceConfig = new IlrFilePersistenceConfigImpl(xuProperties);
        this.datasourcePersistenceConfig = new IlrDatasourcePersistenceConfigImpl(xuProperties);
        this.jdbcPersistenceConfig = new IlrJDBCPersistenceConfigImpl(xuProperties);
    }

    @Override
    public IlrPersistenceType getPersistenceType() {
        return this.persistenceType;
    }

    public String getCustomPersistenceType() {
        return this.customPersistenceType;
    }

    public void setCustomPersistenceType(String type) {
        this.persistenceType = null;
        this.customPersistenceType = type;
    }

    @Override
    public void setPersistenceType(IlrPersistenceType type) {
        if (type == null) {
            throw new IlrIllegalPersistenceTypeException("ilog.rules.res.session.messages", IlrSessionLocalization.PERSISTENCE_TYPE_NOT_VALID_ERROR, new String[]{String.valueOf("null")});
        }
        this.persistenceType = type;
        this.customPersistenceType = null;
    }

    @Override
    public IlrFilePersistenceConfigImpl getFilePersistenceConfig() {
        return this.filePersistenceConfig;
    }

    @Override
    public IlrJDBCPersistenceConfigImpl getJDBCPersistenceConfig() {
        return this.jdbcPersistenceConfig;
    }

    @Override
    public IlrDatasourcePersistenceConfigImpl getDatasourcePersistenceConfig() {
        return this.datasourcePersistenceConfig;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":{persistenceType=" + (Object)((Object)this.persistenceType) + ", customerPersistenceType=" + this.customPersistenceType + "," + this.filePersistenceConfig + "," + this.jdbcPersistenceConfig + "," + this.datasourcePersistenceConfig + "}";
    }
}

