/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.config.internal;

import ilog.rules.res.session.config.IlrPluginConfig;
import ilog.rules.res.session.config.internal.IlrPluginConfigImpl;
import ilog.rules.res.session.config.internal.IlrPluginConfigs;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class IlrPluginConfigsImpl
extends LinkedList<IlrPluginConfig>
implements IlrPluginConfigs {
    private static final long serialVersionUID = 1L;

    public IlrPluginConfigsImpl(List<IlrPluginConfig> pluginConfigs) {
        super(pluginConfigs);
    }

    public IlrPluginConfigsImpl() {
    }

    @Override
    public boolean containsPluginConfig(String pluginClassName) {
        return this.getPluginConfigsByClass(pluginClassName).size() > 0;
    }

    @Override
    public List<IlrPluginConfig> getPluginConfigsByClass(String pluginClassName) {
        LinkedList<IlrPluginConfig> foundConfigs = new LinkedList<IlrPluginConfig>();
        if (pluginClassName != null) {
            for (IlrPluginConfig config : this) {
                if (!pluginClassName.equals(config.getPluginClassName())) continue;
                foundConfigs.add(config);
            }
        }
        return Collections.unmodifiableList(foundConfigs);
    }

    @Override
    public IlrPluginConfigImpl addPluginConfig(String pluginClassName) {
        IlrPluginConfigImpl config = this.createPluginConfig(pluginClassName);
        this.add(config);
        return config;
    }

    @Override
    public IlrPluginConfigImpl createPluginConfig(String pluginClassName) {
        if (pluginClassName == null) {
            throw new IllegalArgumentException("null");
        }
        IlrPluginConfigImpl result = new IlrPluginConfigImpl(pluginClassName);
        return result;
    }
}

