/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.config.internal;

import com.ibm.rules.res.util.internal.PropertiesConverter;
import ilog.rules.res.session.config.IlrPoolConfig;
import ilog.rules.res.session.config.internal.IlrPropertyMapConfig;
import java.util.Map;

public class IlrPoolConfigImpl
extends IlrPropertyMapConfig
implements IlrPoolConfig {
    private final String keyMaxSize;
    private final String keyWaitTimeout;

    IlrPoolConfigImpl(String poolName, Map<String, Object> xuProperties, String keyMaxSize, int defaultMaxSize, String keyWaitTimeout, long defaultWaitTimeout) {
        super(IlrPoolConfigImpl.buildInitialProperties(poolName, xuProperties, keyMaxSize, defaultMaxSize, keyWaitTimeout, defaultWaitTimeout));
        this.keyMaxSize = keyMaxSize;
        this.keyWaitTimeout = keyWaitTimeout;
    }

    private static Map<String, String> buildInitialProperties(String poolName, Map<String, Object> xuProperties, String keyMaxSize, int defaultMaxSize, String keyWaitTimeout, long defaultWaitTimeout) {
        String strProps = (String)xuProperties.get(poolName);
        Map<String, String> initialProperties = PropertiesConverter.toMap(strProps);
        if (!initialProperties.containsKey(keyMaxSize)) {
            initialProperties.put(keyMaxSize, Integer.toString(defaultMaxSize));
        }
        if (!initialProperties.containsKey(keyWaitTimeout)) {
            initialProperties.put(keyWaitTimeout, Long.toString(defaultWaitTimeout));
        }
        return initialProperties;
    }

    @Override
    public int getMaxSize() {
        return this.getIntProperty(this.keyMaxSize);
    }

    @Override
    public void setMaxSize(int size) {
        this.setIntProperty(this.keyMaxSize, size);
    }

    @Override
    public long getWaitTimeout() {
        return this.getLongProperty(this.keyWaitTimeout);
    }

    @Override
    public void setWaitTimeout(long t) {
        this.setLongProperty(this.keyWaitTimeout, t);
    }
}

