/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.impl;

import com.ibm.rules.res.xu.client.internal.XUClient;
import com.ibm.rules.res.xu.client.internal.XUManagementSession;
import com.ibm.rules.res.xu.client.internal.XURuleEngineSession;
import com.ibm.rules.res.xu.client.internal.XUSession;
import com.ibm.rules.res.xu.internal.XUException;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRepositoryFactory;
import ilog.rules.res.model.mbean.impl.IlrJMXProxyRepositoryFactoryImpl;
import ilog.rules.res.session.IlrManagementSession;
import ilog.rules.res.session.IlrSessionException;
import ilog.rules.res.session.util.IlrSessionLocalization;

public abstract class IlrManagementSessionBase
implements IlrManagementSession {
    private final XUClient xuClient;
    private final ClassLoader xomClassLoader;

    @Override
    public IlrRepositoryFactory getRepositoryFactory() throws IlrSessionException {
        return new IlrJMXProxyRepositoryFactoryImpl(null);
    }

    public IlrManagementSessionBase(XUClient xuClient, ClassLoader classLoader) {
        this.xuClient = xuClient;
        this.xomClassLoader = classLoader;
    }

    protected XUClient getXUClient() {
        return this.xuClient;
    }

    @Override
    public IlrPath[] solveRulesetPath(IlrPath[] rulesetPaths) throws IlrSessionException {
        if (rulesetPaths == null) {
            return null;
        }
        IlrPath[] canonicalRulesetPaths = new IlrPath[rulesetPaths.length];
        XUManagementSession sess = null;
        try {
            sess = this.createManagementSession();
            for (int i = 0; i < rulesetPaths.length; ++i) {
                canonicalRulesetPaths[i] = sess.solveRulesetPath(rulesetPaths[i]);
            }
            IlrPath[] i = canonicalRulesetPaths;
            return i;
        }
        catch (XUException e) {
            throw new IlrSessionException(e);
        }
        finally {
            IlrManagementSessionBase.closeXUSession(sess);
        }
    }

    @Override
    public void invalidate(IlrPath[] rulesetPaths) throws IlrSessionException {
        if (rulesetPaths == null) {
            return;
        }
        XUManagementSession sess = null;
        try {
            sess = this.createManagementSession();
            for (int i = 0; i < rulesetPaths.length; ++i) {
                IlrPath canonicalPath = rulesetPaths[i];
                this.checkRulesetPath(canonicalPath);
                sess.notifyRulesetArchiveChanged(canonicalPath);
            }
        }
        catch (XUException e) {
            throw new IlrSessionException(e);
        }
        finally {
            IlrManagementSessionBase.closeXUSession(sess);
        }
    }

    @Override
    public void invalidate(IlrPath rulesetPath) throws IlrSessionException {
        this.invalidate(new IlrPath[]{rulesetPath});
    }

    protected ClassLoader getXOMClassLoader() {
        return this.xomClassLoader;
    }

    @Override
    public void loadUptodateRuleset(IlrPath rulesetPath) throws IlrSessionException {
        if (rulesetPath == null) {
            return;
        }
        XURuleEngineSession xuEngineSession = null;
        try {
            xuEngineSession = this.xuClient.createRuleEngineSession(rulesetPath, this.getXOMClassLoader(), null, null, "8.7.1.0");
            xuEngineSession.loadUptodateRuleset();
        }
        catch (XUException re) {
            try {
                throw new IlrSessionException(re);
            }
            catch (Throwable throwable) {
                IlrManagementSessionBase.closeXUSession(xuEngineSession);
                throw throwable;
            }
        }
        IlrManagementSessionBase.closeXUSession(xuEngineSession);
    }

    private static void closeXUSession(XUSession xuSession) throws IlrSessionException {
        if (xuSession != null) {
            try {
                xuSession.close();
            }
            catch (XUException e) {
                throw new IlrSessionException(e);
            }
        }
    }

    protected void checkRulesetPath(IlrPath rulesetPath) throws IlrSessionException {
        if (rulesetPath == null) {
            throw new IlrSessionException(IlrSessionLocalization.SESSION_MANAGE_RULESETPATH_NULL_ERROR, new String[]{String.valueOf("null")});
        }
        if (!rulesetPath.isCanonical()) {
            throw new IlrSessionException(new IllegalArgumentException(rulesetPath.toString()));
        }
    }

    protected XUManagementSession createManagementSession() throws XUException {
        return this.getXUClient().createManagementSession("8.7.1.0");
    }
}

