/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.impl;

import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.session.IlrSessionResponse;
import ilog.rules.res.session.IlrWarning;
import ilog.rules.res.session.ruleset.IlrExecutionTrace;
import ilog.rules.res.xu.cci.IlrConnectionId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class IlrSessionResponseImpl
implements IlrSessionResponse {
    private static final long serialVersionUID = 1L;
    protected Map<String, Object> outputParameters;
    protected Map<String, Object> inputParameters = new HashMap<String, Object>();
    protected String canonicalRsPathStr;
    private final IlrConnectionId connectionId;
    protected Serializable userData;
    protected String interceptorClassNameUsed;
    protected List<IlrWarning> warnings = new ArrayList<IlrWarning>();
    protected String outputString;
    protected Properties rulesetProperties;
    protected String executionId;
    protected IlrExecutionTrace executionTrace;

    public IlrSessionResponseImpl() {
        this.outputParameters = new HashMap<String, Object>();
        this.connectionId = null;
    }

    IlrSessionResponseImpl(Map<String, Object> outputParameters, String outputString, Serializable userData, String canonicalRsPathStr, Properties rulesetProperties, IlrConnectionId connectionId, String executionId) {
        this.outputParameters = outputParameters;
        this.outputString = outputString;
        this.userData = userData;
        this.canonicalRsPathStr = canonicalRsPathStr;
        this.rulesetProperties = rulesetProperties;
        this.connectionId = connectionId;
        this.executionId = executionId;
    }

    public final Map<String, Object> getInputParameters() {
        return this.inputParameters;
    }

    @Override
    public final Map<String, Object> getOutputParameters() {
        return this.outputParameters;
    }

    public final Object getOutputParameter(String name) {
        return this.outputParameters.get(name);
    }

    @Override
    public final IlrPath getCanonicalRulesetPath() {
        IlrPath res = null;
        if (this.canonicalRsPathStr != null) {
            try {
                res = IlrPath.parsePath(this.canonicalRsPathStr);
            }
            catch (IlrFormatException ilrFormatException) {
                // empty catch block
            }
        }
        return res;
    }

    @Override
    public Serializable getConnectionId() {
        return this.connectionId.getUUID().toString();
    }

    @Override
    public Serializable getUserData() {
        return this.userData;
    }

    public void setUserData(Serializable userData) {
        this.userData = userData;
    }

    @Override
    public List<IlrWarning> getWarnings() {
        return this.warnings;
    }

    public void setWarnings(List<IlrWarning> warnings) {
        this.warnings = warnings;
    }

    @Override
    public String getInterceptorClassNameUsed() {
        return this.interceptorClassNameUsed;
    }

    public void setInterceptorClassNameUsed(String interceptorClassNameUsed) {
        this.interceptorClassNameUsed = interceptorClassNameUsed;
    }

    @Override
    public String getRulesetExecutionOutput() {
        return this.outputString;
    }

    public void setOutputString(String outputString) {
        this.outputString = outputString;
    }

    @Override
    public Properties getRulesetProperties() {
        return this.rulesetProperties;
    }

    public void setRulesetProperties(Properties rulesetProperties) {
        this.rulesetProperties = rulesetProperties;
    }

    public void setCanonicalRsPathStr(String canonicalRsPathStr) {
        this.canonicalRsPathStr = canonicalRsPathStr;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public IlrExecutionTrace getRulesetExecutionTrace() {
        return this.executionTrace;
    }

    public void setRulesetExecutionTrace(IlrExecutionTrace executionTrace) {
        this.executionTrace = executionTrace;
    }

    public void setOutputParameters(Map<String, Object> outputParameters) {
        this.outputParameters = outputParameters;
    }
}

