/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.impl;

import com.ibm.rules.res.xu.client.internal.XUClient;
import com.ibm.rules.res.xu.client.internal.XURuleEngineSession;
import com.ibm.rules.res.xu.client.internal.XURulesetParameter;
import com.ibm.rules.res.xu.client.internal.XUWarning;
import com.ibm.rules.res.xu.internal.XUException;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.IlrRulesetParameter;
import ilog.rules.res.session.IlrSessionException;
import ilog.rules.res.session.IlrSessionRequest;
import ilog.rules.res.session.IlrSessionResponse;
import ilog.rules.res.session.IlrStatefulSession;
import ilog.rules.res.session.IlrTraceFilter;
import ilog.rules.res.session.IlrWarning;
import ilog.rules.res.session.impl.IlrSessionFactoryBase;
import ilog.rules.res.session.impl.IlrSessionRequestImpl;
import ilog.rules.res.session.impl.IlrSessionResponseImpl;
import ilog.rules.res.session.impl.IlrSessionWarningImpl;
import ilog.rules.res.session.impl.IlrTraceFilterImpl;
import ilog.rules.res.session.impl.IlrWarningListenerImpl;
import ilog.rules.res.session.impl.trace.IlrTraceBuilder;
import ilog.rules.res.session.interceptor.IlrSessionInterceptorException;
import ilog.rules.res.session.util.IlrInterceptorHelper;
import ilog.rules.res.session.util.IlrSessionLocalization;
import ilog.rules.res.xu.cci.IlrConnectionId;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.logging.Level;

public class IlrStatefulSessionBase
implements IlrStatefulSession {
    public static final String ILOG_RULES_FIRED_RULES_COUNT = "ilog.rules.firedRulesCount";
    private final IlrPath rulesetPath;
    private final Serializable userData;
    private final Map<String, String> rulesetArchivePropertiesMap;
    protected final Properties rulesetArchiveProperties;
    private boolean traceEnabled = false;
    private IlrTraceFilter traceFilter = new IlrTraceFilterImpl();
    private final boolean interceptorEnabled;
    private final boolean forceUptodate;
    protected final IlrSessionFactoryBase sessionFactory;
    private final IlrInterceptorHelper interceptorHelper;
    protected final XUClient clientFactory;
    protected XURuleEngineSession xuSession;
    protected final IlrWarningListenerImpl warningListener = new IlrWarningListenerImpl();
    protected IlrConnectionId connId;
    protected String canonicalRulesetPath;
    protected long execId;
    protected char[] executionId;
    protected Map<Object, UUID> uuids = new WeakHashMap<Object, UUID>();

    public IlrStatefulSessionBase(XUClient xuClient, IlrSessionFactoryBase sessionFactory, IlrPath rsPath, Serializable userData, Map<String, Object> initParameters, boolean forceUptodate, boolean interceptorEnabled) throws IlrSessionInterceptorException, XUException {
        this(xuClient, sessionFactory, rsPath, userData, initParameters, forceUptodate, interceptorEnabled, null);
    }

    public IlrStatefulSessionBase(XUClient xuClient, IlrSessionFactoryBase sessionFactory, IlrPath rsPath, Serializable userData, Map<String, Object> initParameters, boolean forceUptodate, boolean interceptorEnabled, ClassLoader xomClassLoader) throws IlrSessionInterceptorException, XUException {
        IlrInterceptorHelper interceptorH = null;
        if (interceptorEnabled) {
            interceptorH = IlrStatefulSessionBase.initInterceptorAndTransformRSPath(this, rsPath, userData, initParameters, sessionFactory);
        }
        IlrPath executedRSPath = interceptorEnabled ? interceptorH.getExecutedRulesetPath() : rsPath;
        this.xuSession = null;
        try {
            ClassLoader classLoader = xomClassLoader != null ? xomClassLoader : sessionFactory.getXOMClassLoader();
            this.xuSession = xuClient.createRuleEngineSession(executedRSPath, classLoader, null, userData, "8.7.1.0");
            this.xuSession.addXUWarningListener(this.warningListener);
            if (forceUptodate) {
                this.xuSession.loadUptodateRuleset();
            }
            this.rulesetArchivePropertiesMap = this.xuSession.getRulesetArchiveProperties();
            this.rulesetArchiveProperties = new Properties();
            if (this.rulesetArchivePropertiesMap != null) {
                this.rulesetArchiveProperties.putAll(this.rulesetArchivePropertiesMap);
            }
        }
        catch (XUException e) {
            if (this.xuSession != null) {
                this.xuSession.close();
                this.xuSession = null;
            }
            throw e;
        }
        this.rulesetPath = executedRSPath;
        this.interceptorHelper = interceptorH;
        this.sessionFactory = sessionFactory;
        this.userData = userData;
        this.clientFactory = xuClient;
        this.forceUptodate = forceUptodate;
        this.interceptorEnabled = interceptorEnabled;
    }

    private static IlrInterceptorHelper initInterceptorAndTransformRSPath(IlrStatefulSession session, IlrPath rsPath, Serializable userData, Map<String, Object> initParameters, IlrSessionFactoryBase sessionFactory) throws IlrSessionInterceptorException {
        IlrInterceptorHelper helper = new IlrInterceptorHelper();
        helper.initialize(rsPath, session, sessionFactory);
        helper.getContext().setRequest(null);
        helper.invokeTranformPathInterceptors(rsPath, userData, initParameters);
        return helper;
    }

    @Override
    public IlrPath getRulesetPath() {
        return this.rulesetPath;
    }

    @Override
    public Serializable getUserData() {
        return this.userData;
    }

    @Override
    public boolean isInterceptorEnabled() {
        return this.interceptorEnabled;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    @Override
    public void setTraceEnabled(boolean enabled) {
        this.traceEnabled = enabled;
    }

    @Override
    public IlrTraceFilter getTraceFilter() {
        return this.traceFilter;
    }

    @Override
    public void setTraceFilter(IlrTraceFilter filter) {
        this.traceFilter = filter;
    }

    @Override
    public String getOutput() throws IlrSessionException {
        try {
            return this.xuSession.getOutput();
        }
        catch (XUException e) {
            throw new IlrSessionException(e);
        }
    }

    @Override
    public IlrSessionResponse execute() throws IlrSessionException {
        return this.execute(null, null, false, null);
    }

    @Override
    public IlrSessionResponse execute(Map<String, Object> inputParameters) throws IlrSessionException {
        return this.execute(inputParameters, null, false, null);
    }

    @Override
    public IlrSessionResponse execute(Map<String, Object> inputParameters, String taskName) throws IlrSessionException {
        return this.execute(inputParameters, taskName, false, null);
    }

    public final Map<String, Object> fastExecute(Map<String, Object> params) throws XUException {
        this.xuSession.setParameters(params);
        return this.xuSession.execute();
    }

    @Override
    public IlrSessionResponse execute(Map<String, Object> inputParameters, String taskName, boolean isBOMAccess) throws IlrSessionException {
        return this.execute(inputParameters, taskName, isBOMAccess, null);
    }

    public IlrSessionResponse execute(Map<String, Object> inputParameters, String taskName, boolean isBOMAccess, String executionId) throws IlrSessionException {
        IlrSessionRequest actualRequest = this.invokeBeforeInterceptors(this.createInitialRequest(inputParameters, taskName, isBOMAccess, executionId));
        IlrTraceBuilder traceBuilder = IlrTraceBuilder.createFromTraceAndDWOptions(actualRequest, this.rulesetArchivePropertiesMap);
        IlrSessionResponse response = this.execute(actualRequest, traceBuilder);
        response = this.invokeAfterInterceptors(response);
        this.persistDWTrace(actualRequest, response, traceBuilder);
        response.getWarnings().addAll(traceBuilder.getWarningsRelatedToDW());
        return response;
    }

    private void persistDWTrace(IlrSessionRequest request, IlrSessionResponse response, IlrTraceBuilder traceHelper) throws IlrSessionException {
        if (traceHelper.isDWEnabled()) {
            traceHelper.persistDWTrace(request, response, this.sessionFactory);
        }
    }

    private IlrSessionResponse invokeAfterInterceptors(IlrSessionResponse response) throws IlrSessionInterceptorException {
        if (this.interceptorEnabled) {
            response = this.interceptorHelper.invokeAfterInterceptors(response);
        }
        return response;
    }

    private void copyXUWarningsInResponse(IlrSessionResponse response) {
        for (XUWarning w : this.warningListener.getWarnings()) {
            response.getWarnings().add(IlrSessionWarningImpl.createFromXUWarning(w));
        }
    }

    private IlrSessionRequest invokeBeforeInterceptors(IlrSessionRequest initialRequest) throws IlrSessionInterceptorException {
        IlrSessionRequest execRequest = initialRequest;
        if (this.interceptorEnabled) {
            this.interceptorHelper.getContext().setRequest(initialRequest);
            this.interceptorHelper.invokeBeforeInterceptors();
            execRequest = this.interceptorHelper.getContext().getRequest();
        }
        return execRequest;
    }

    private IlrSessionRequestImpl createInitialRequest(Map<String, Object> inputParameters, String taskName, boolean isBOMAccess, String executionId) {
        return new IlrSessionRequestImpl(this.rulesetPath, this.interceptorEnabled, this.traceEnabled, this.traceFilter, this.userData, this.forceUptodate, inputParameters, taskName, isBOMAccess, executionId);
    }

    @Override
    public List<UUID> insertJavaObjects(List<Object> objects) throws IlrSessionException {
        return this.insert(objects, 0);
    }

    @Override
    public List<UUID> insertXMLObjects(List<String> objects) throws IlrSessionException {
        return this.insert(objects, 1);
    }

    protected List<UUID> insert(List<?> objects, int type) throws IlrSessionException {
        ArrayList<Object> clientInput = new ArrayList<Object>(objects.size() * 3);
        ArrayList<UUID> uuids = new ArrayList<UUID>(objects.size());
        for (Object object : objects) {
            UUID uuid = this.getUUID(object);
            clientInput.add(uuid);
            clientInput.add(type);
            clientInput.add(object);
            uuids.add(uuid);
        }
        try {
            this.xuSession.insert(clientInput);
            return uuids;
        }
        catch (XUException e) {
            throw new IlrSessionException(e);
        }
    }

    @Override
    public void update(List<UUID> uuids) throws IlrSessionException {
        for (UUID uuid : uuids) {
            try {
                this.xuSession.updateById(uuid);
            }
            catch (XUException e) {
                throw new IlrSessionException(e);
            }
        }
    }

    @Override
    public void retract(List<UUID> uuids) throws IlrSessionException {
        for (UUID uuid : uuids) {
            try {
                this.xuSession.retractById(uuid);
            }
            catch (XUException e) {
                throw new IlrSessionException(e);
            }
        }
    }

    @Override
    public void reset() throws IlrSessionException {
        try {
            this.xuSession.reset();
        }
        catch (XUException e) {
            throw new IlrSessionException(e);
        }
    }

    @Override
    public void resetRuleflow() throws IlrSessionException {
        try {
            this.xuSession.resetRuleflow();
        }
        catch (XUException e) {
            throw new IlrSessionException(e);
        }
    }

    @Override
    public List<IlrWarning> getWarnings(boolean clear) {
        List<XUWarning> resourceWarnings = this.warningListener.getWarnings();
        ArrayList<IlrWarning> res = new ArrayList<IlrWarning>();
        if (resourceWarnings != null) {
            for (XUWarning w : resourceWarnings) {
                res.add(IlrSessionWarningImpl.createFromXUWarning(w));
            }
        }
        if (clear) {
            this.warningListener.clearWarnings();
        }
        return res;
    }

    @Override
    public List<Object> getWorkingMemory() throws IlrSessionException {
        try {
            return this.xuSession.getWorkingMemory();
        }
        catch (XUException e) {
            throw new IlrSessionException(e);
        }
    }

    @Override
    public Map<UUID, Object> getWorkingMemoryUUIDs() throws IlrSessionException {
        HashMap<UUID, Object> result = new HashMap<UUID, Object>();
        try {
            Map<Object, Object> workingMemory = this.xuSession.getWorkingMemoryById();
            for (Map.Entry<Object, Object> entry : workingMemory.entrySet()) {
                result.put((UUID)entry.getKey(), entry.getValue());
            }
            return result;
        }
        catch (XUException e) {
            throw new IlrSessionException(e);
        }
    }

    @Override
    public void close() {
        try {
            if (this.xuSession != null) {
                this.xuSession.close();
            }
        }
        catch (XUException e) {
            IlrSessionLocalization.LOGGER.log(Level.WARNING, IlrSessionLocalization.EXCEPTION_ON_CLOSE, new String[]{e.getMessage()}, e);
        }
    }

    protected UUID getUUID(Object object) {
        UUID uuid = this.uuids.get(object);
        if (uuid == null) {
            uuid = UUID.randomUUID();
            this.uuids.put(object, uuid);
        }
        return uuid;
    }

    public ClassLoader getManagedXOMClassLoader() throws IlrSessionException {
        try {
            return this.xuSession.getManagedXOMClassLoader();
        }
        catch (XUException e) {
            throw new IlrSessionException(e);
        }
    }

    public final Map<String, String> getOutputParametersAsBOM() throws IlrSessionException {
        byte dir = 6;
        try {
            return this.xuSession.getParametersAsXMLBOM(dir, null, true);
        }
        catch (XUException e) {
            throw new IlrSessionException(e);
        }
    }

    @Override
    public Collection<IlrRulesetParameter> getRulesetSignature() throws IlrSessionException {
        try {
            Collection<XURulesetParameter> params = this.xuSession.getRulesetParameters();
            ArrayList<IlrRulesetParameter> result = new ArrayList<IlrRulesetParameter>(params.size());
            result.addAll(params);
            return result;
        }
        catch (XUException e) {
            throw new IlrSessionException(e);
        }
    }

    @Override
    public Map<String, String> getRulesetArchiveProperties() throws IlrSessionException {
        return this.rulesetArchivePropertiesMap;
    }

    private synchronized IlrConnectionId getConnectionId() throws XUException {
        if (this.connId == null) {
            this.connId = this.xuSession.getConnectionId();
        }
        return this.connId;
    }

    protected final synchronized String getCanonicalRulesetPath() throws XUException {
        if (this.canonicalRulesetPath == null) {
            this.canonicalRulesetPath = this.xuSession.getCanonicalRulesetPath();
        }
        return this.canonicalRulesetPath;
    }

    private synchronized String nextExecutionId() throws XUException {
        String connId = this.getConnectionId().getUUID().toString();
        int n = connId.length();
        if (this.executionId == null) {
            this.executionId = new char[n + 8 + 1];
            System.arraycopy(connId.toCharArray(), 0, this.executionId, 0, n);
        }
        char[] countHex = Long.toHexString(this.execId++).toCharArray();
        System.arraycopy(countHex, 0, this.executionId, n, countHex.length);
        return new String(this.executionId, 0, n + countHex.length);
    }

    protected final IlrSessionResponseImpl execute(IlrSessionRequest rq, IlrTraceBuilder traceBuilder) throws IlrSessionException {
        IlrSessionResponseImpl rp;
        traceBuilder.startExecutionStopwatch();
        traceBuilder.configureTraceInXUSession(this.xuSession);
        try {
            Map<String, Object> out = this.execute(rq.getTaskName(), rq.getInputParameters(), rq.isBOMAccess(), !rq.isTraceEnabled(), traceBuilder);
            String execId = rq.getExecutionId();
            if (execId == null) {
                execId = this.nextExecutionId();
            }
            rp = new IlrSessionResponseImpl(out, this.xuSession.getOutput(), rq.getUserData(), this.getCanonicalRulesetPath(), this.rulesetArchiveProperties, this.getConnectionId(), execId);
        }
        catch (XUException e) {
            throw new IlrSessionException(e);
        }
        traceBuilder.buildResults(rq, rp, this.xuSession);
        rp.executionTrace = traceBuilder.getExecutionTrace();
        this.copyXUWarningsInResponse(rp);
        return rp;
    }

    private Map<String, Object> execute(String taskName, Map<String, Object> inputParameters, boolean bomParameters, boolean askForNumRulesFired, IlrTraceBuilder traceBuilder) throws XUException {
        Map<String, Object> resultMap;
        Map<String, String> bParams;
        if (inputParameters != null) {
            if (bomParameters) {
                bParams = new HashMap<String, String>();
                for (Map.Entry<String, Object> entry : inputParameters.entrySet()) {
                    bParams.put(entry.getKey(), (String)entry.getValue());
                }
                this.xuSession.setParametersAsXMLBOM(bParams);
            } else {
                this.xuSession.setParameters(inputParameters);
            }
            if (traceBuilder.isDWEnabled() && traceBuilder.isInputParametersIncluded()) {
                traceBuilder.serializeInputParametersAndKeepResult(inputParameters, this.xuSession);
            }
        }
        Map<String, Object> xomOutputParams = taskName == null ? this.xuSession.execute() : this.xuSession.executeTask(taskName);
        if (bomParameters) {
            bParams = this.xuSession.getParametersAsXMLBOM((byte)2, null, false);
            resultMap = new HashMap<String, Object>();
            for (Map.Entry<String, Object> entry : bParams.entrySet()) {
                resultMap.put(entry.getKey(), entry.getValue());
            }
        } else {
            resultMap = xomOutputParams;
        }
        if (askForNumRulesFired) {
            resultMap.put(ILOG_RULES_FIRED_RULES_COUNT, this.xuSession.getFiredRulesCount());
        }
        return resultMap;
    }

    public XURuleEngineSession getXURuleEngineSession() {
        return this.xuSession;
    }

    @Override
    public final boolean isRulesetUptodate() throws IlrSessionException {
        try {
            return this.xuSession.isRulesetUptodate();
        }
        catch (XUException e) {
            throw new IlrSessionException(e);
        }
    }
}

