/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.impl.trace;

import ilog.rules.res.session.IlrSessionException;
import ilog.rules.res.session.util.IlrSessionLocalization;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class IlrTraceOptionsParser {
    public static final String PROPERTY_VALUE_SEPARATOR = "=";
    public static final String VALUES_SEPARATOR = ",";

    public static Map<String, String> extractBAMFiltersProperties(String theBAMFilter) throws IlrSessionException {
        if (theBAMFilter == null) {
            throw new IllegalArgumentException();
        }
        if (theBAMFilter.endsWith(PROPERTY_VALUE_SEPARATOR)) {
            throw new IlrSessionException(IlrSessionLocalization.SESSION_BAM_EXCEPTION_INVALID_FILTERS, new String[]{theBAMFilter});
        }
        HashMap<String, String> returnedValue = new HashMap<String, String>();
        String[] filters = theBAMFilter.split(PROPERTY_VALUE_SEPARATOR);
        if (filters.length > 1) {
            int currentIndex = 0;
            String propertyName = filters[currentIndex];
            ++currentIndex;
            while (currentIndex < filters.length) {
                String nextToken = filters[currentIndex];
                if (++currentIndex == filters.length) {
                    returnedValue.put(propertyName, nextToken);
                    continue;
                }
                String[] tokens = nextToken.split(VALUES_SEPARATOR);
                if (tokens.length == 1) {
                    throw new IlrSessionException(IlrSessionLocalization.SESSION_BAM_EXCEPTION_INVALID_FILTERS, new String[]{theBAMFilter});
                }
                StringBuffer rebuiltValue = new StringBuffer();
                for (int i = 0; i < tokens.length - 1; ++i) {
                    rebuiltValue.append(tokens[i]);
                    if (i >= tokens.length - 2) continue;
                    rebuiltValue.append(VALUES_SEPARATOR);
                }
                returnedValue.put(propertyName, rebuiltValue.toString());
                propertyName = tokens[tokens.length - 1];
            }
        } else {
            throw new IlrSessionException(IlrSessionLocalization.SESSION_BAM_EXCEPTION_INVALID_FILTERS, new String[]{theBAMFilter});
        }
        return returnedValue;
    }

    public static List<String> parseInOutParametersSerializationFilters(Map<String, String> rulesetProperties) {
        String inOutFilters = rulesetProperties.get("monitoring.inout.filters");
        LinkedList<String> inOutParamsSerializationFilters = null;
        if (inOutFilters != null) {
            inOutParamsSerializationFilters = new LinkedList<String>();
            String[] splittedSerFilters = inOutFilters.split("[;,]");
            inOutParamsSerializationFilters.addAll(Arrays.asList(splittedSerFilters));
        }
        return inOutParamsSerializationFilters;
    }
}

