/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.session.util;

import com.ibm.rules.res.persistence.internal.PersistencePropertiesConverter;
import com.ibm.rules.res.util.internal.PropertiesConverter;
import com.ibm.rules.res.xu.client.internal.XUManagementSession;
import com.ibm.rules.res.xu.internal.XUException;
import ilog.rules.res.persistence.IlrDAOException;
import ilog.rules.res.persistence.IlrRepositoryDAO;
import ilog.rules.res.persistence.impl.IlrRepositoryDAOFactoryImpl;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class IlrPersistenceFactory {
    public static final String PERSISTENCE_TYPE = "persistenceType";
    public static final String PERSISTENCE_PROPERTIES = "persistenceProperties";

    public IlrRepositoryDAO createRepositoryDAO(Map<String, String> parsedProps) throws IlrDAOException, IOException {
        IlrRepositoryDAO persistenceProvider;
        IlrRepositoryDAOFactoryImpl daoFactory = new IlrRepositoryDAOFactoryImpl();
        String persistenceType = parsedProps.get(PERSISTENCE_TYPE);
        if ("jdbc".equals(persistenceType)) {
            persistenceProvider = daoFactory.getDriverRepositoryDAO(IlrPersistenceFactory.class.getClassLoader(), parsedProps.get("DRIVER_CLASS_NAME"), parsedProps.get("URL"), parsedProps.get("USER"), parsedProps.get("PASSWORD"), parsedProps.get("CRYPTED_PASSWORD"));
        } else if ("file".equals(persistenceType)) {
            if (parsedProps.get("DIRECTORY") == null) {
                persistenceProvider = daoFactory.getFileRepositoryDAO();
            } else {
                File file = new File(parsedProps.get("DIRECTORY"));
                persistenceProvider = daoFactory.getFileRepositoryDAO(file.getCanonicalPath());
            }
        } else if ("datasource".equals(parsedProps.get(PERSISTENCE_TYPE))) {
            persistenceProvider = daoFactory.getDataSourceRepositoryDAO(parsedProps.get("JNDI_NAME"), false);
        } else {
            Map<String, String> obfuscatedProps = PersistencePropertiesConverter.obfuscate(parsedProps);
            throw new IllegalArgumentException(obfuscatedProps.toString());
        }
        return persistenceProvider;
    }

    public Map<String, String> getPersistenceProperties(XUManagementSession managementSession) throws XUException {
        Map<String, Object> xuProperties = managementSession.getConnectorConfigProperties();
        String persistenceProperties = (String)xuProperties.get(PERSISTENCE_PROPERTIES);
        if (persistenceProperties == null) {
            return new HashMap<String, String>();
        }
        Map<String, String> result = PropertiesConverter.toMap(persistenceProperties);
        result.put(PERSISTENCE_TYPE, (String)xuProperties.get(PERSISTENCE_TYPE));
        return result;
    }
}

