/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.trace;

import ilog.rules.res.model.IlrPath;
import ilog.rules.res.model.trace.IlrDWTrace;
import ilog.rules.res.session.ruleset.IlrExecutionEvent;
import ilog.rules.res.session.ruleset.IlrRuleInformation;
import ilog.rules.res.session.ruleset.IlrTaskInformation;
import ilog.rules.res.session.ruleset.impl.IlrExecutionTraceImpl;
import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class IlrDWTraceImpl
implements IlrDWTrace,
Serializable {
    private static final long serialVersionUID = 1L;
    private final IlrPath requestRulesetPath;
    private final IlrPath executedRulesetPath;
    private final Map<String, String> rulesetProperties;
    private final String userData;
    private final Long totalRules;
    private final Long totalTasks;
    private final String executionOutput;
    private final Map<String, String> inputParameters;
    private final Map<String, String> outputParameters;
    private final String executionId;
    private final IlrExecutionTraceImpl executionTrace;

    public IlrDWTraceImpl(IlrExecutionTraceImpl executionTrace, IlrPath requestRulesetPath, IlrPath executedRulesetPath, Map<String, String> rulesetProperties, String userData, Long nbRules, Long nbTasks, String executionOutput, Map<String, String> inputParameters, Map<String, String> outputParameters, String executionId) {
        this.requestRulesetPath = requestRulesetPath;
        this.executedRulesetPath = executedRulesetPath;
        this.rulesetProperties = this.unmodifiableCopyOrNull(rulesetProperties);
        this.userData = userData;
        this.totalRules = nbRules;
        this.totalTasks = nbTasks;
        this.executionOutput = executionOutput;
        this.inputParameters = this.unmodifiableCopyOrNull(inputParameters);
        this.outputParameters = this.unmodifiableCopyOrNull(outputParameters);
        this.executionId = executionId;
        this.executionTrace = executionTrace;
    }

    private Map<String, String> unmodifiableCopyOrNull(Map<String, String> outputParameters) {
        return outputParameters != null ? Collections.unmodifiableMap(outputParameters) : null;
    }

    @Override
    public IlrPath getRequestRulesetPath() {
        return this.requestRulesetPath;
    }

    @Override
    public IlrPath getExecutedRulesetPath() {
        return this.executedRulesetPath;
    }

    @Override
    public Map<String, String> getRulesetProperties() {
        return this.rulesetProperties;
    }

    @Override
    public String getUserData() {
        return this.userData;
    }

    @Override
    public Long getNbRules() {
        return this.getTotalRules();
    }

    @Override
    public Long getTotalRules() {
        return this.totalRules;
    }

    @Override
    public Long getNbTasks() {
        return this.getTotalTasks();
    }

    @Override
    public Long getTotalTasks() {
        return this.totalTasks;
    }

    @Override
    public String getExecutionOutput() {
        return this.executionOutput;
    }

    @Override
    public Map<String, String> getInputParameters() {
        return this.inputParameters;
    }

    @Override
    public Map<String, String> getOutputParameters() {
        return this.outputParameters;
    }

    @Override
    public String getExecutionId() {
        return this.executionId;
    }

    @Override
    public Long getTotalRulesFired() {
        if (this.executionTrace != null) {
            return this.executionTrace.getTotalRulesFired();
        }
        return null;
    }

    @Override
    public Long getTotalRulesNotFired() {
        if (this.executionTrace != null) {
            return this.executionTrace.getTotalRulesNotFired();
        }
        return null;
    }

    @Override
    public Long getTotalTasksExecuted() {
        if (this.executionTrace != null) {
            return this.executionTrace.getTotalTasksExecuted();
        }
        return null;
    }

    @Override
    public Long getTotalTasksNotExecuted() {
        if (this.executionTrace != null) {
            return this.executionTrace.getTotalTasksNotExecuted();
        }
        return null;
    }

    @Override
    public Date getExecutionDate() {
        if (this.executionTrace != null) {
            return this.executionTrace.getExecutionDate();
        }
        return null;
    }

    @Override
    public Long getExecutionDuration() {
        if (this.executionTrace != null) {
            return this.executionTrace.getExecutionDuration();
        }
        return null;
    }

    @Override
    public Collection<Object> getWorkingMemory() {
        if (this.executionTrace != null) {
            return this.executionTrace.getWorkingMemory();
        }
        return null;
    }

    @Override
    public Set<IlrRuleInformation> getRulesNotFired() {
        if (this.executionTrace != null) {
            return this.executionTrace.getRulesNotFired();
        }
        return null;
    }

    @Override
    public Set<IlrTaskInformation> getTasksNotExecuted() {
        if (this.executionTrace != null) {
            return this.executionTrace.getTasksNotExecuted();
        }
        return null;
    }

    @Override
    public Map<String, IlrRuleInformation> getRules() {
        if (this.executionTrace != null) {
            return this.executionTrace.getRules();
        }
        return null;
    }

    @Override
    public Map<String, IlrTaskInformation> getTasks() {
        if (this.executionTrace != null) {
            return this.executionTrace.getTasks();
        }
        return null;
    }

    @Override
    public List<IlrExecutionEvent> getExecutionEvents() {
        if (this.executionTrace != null) {
            return this.executionTrace.getExecutionEvents();
        }
        return null;
    }

    @Override
    public InetAddress getInetAddress() {
        if (this.executionTrace != null) {
            return this.executionTrace.getInetAddress();
        }
        return null;
    }

    @Override
    public Properties getSystemProperties() {
        if (this.executionTrace != null) {
            return this.executionTrace.getSystemProperties();
        }
        return null;
    }

    public String toString() {
        return "IlrDWTraceImpl [requestRulesetPath=" + this.requestRulesetPath + ", executedRulesetPath=" + this.executedRulesetPath + ", rulesetProperties=" + this.rulesetProperties + ", userData=" + this.userData + ", totalRules=" + this.totalRules + ", totalTasks=" + this.totalTasks + ", executionOutput=" + this.executionOutput + ", inputParameters=" + this.inputParameters + ", outputParameters=" + this.outputParameters + ", executionId=" + this.executionId + ", executionTrace=" + this.executionTrace + "]";
    }

    public IlrExecutionTraceImpl getExecutionTrace() {
        return this.executionTrace;
    }
}

