/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.util.classloader;

import ilog.rules.res.util.classloader.IlrURLResourceStreamHandler;
import ilog.rules.res.util.io.IlrFileUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class IlrClassLoader
extends ClassLoader {
    private final byte[] jar;

    public IlrClassLoader(ClassLoader parent, byte[] jar) throws IOException {
        super(parent);
        this.jar = jar;
    }

    @Override
    public Class<?> findClass(String name) throws ClassNotFoundException {
        String entryName = name.replace('.', '/') + ".class";
        byte[] data = this.loadData(entryName);
        Class<?> c = null;
        if (data != null) {
            c = this.defineClass(name, data, 0, data.length);
        }
        if (c != null && name.equals(c.getName())) {
            return c;
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    protected URL findResource(String name) {
        byte[] data = this.loadData(name);
        if (data != null) {
            try {
                return new URL("binary", null, -1, name, new IlrURLResourceStreamHandler(data));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        final URL url = this.findResource(name);
        if (url == null) {
            return super.findResources(name);
        }
        return new Enumeration<URL>(){
            private boolean end = false;

            @Override
            public URL nextElement() {
                if (this.end) {
                    throw new NoSuchElementException();
                }
                this.end = true;
                return url;
            }

            @Override
            public boolean hasMoreElements() {
                return !this.end;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadData(String name) {
        ZipInputStream jis = null;
        try {
            jis = new JarInputStream(new ByteArrayInputStream(this.jar));
            ZipEntry entry = null;
            while (true) {
                if ((entry = ((JarInputStream)jis).getNextEntry()) != null) {
                    if (!entry.isDirectory() && entry.getName().equals(name)) {
                        ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
                        IlrFileUtil.copy((InputStream)jis, baos);
                        jis.closeEntry();
                        byte[] byArray = baos.toByteArray();
                        return byArray;
                    }
                    jis.closeEntry();
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
        }
        finally {
            if (jis != null) {
                try {
                    jis.close();
                }
                catch (IOException e) {}
            }
        }
        return null;
    }
}

