/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.util.io;

import com.ibm.rules.res.message.internal.XXMessageCode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class IlrFileUtil {
    public static final void copyToDir(File file, File outDir) throws IOException {
        File outFile = new File(outDir, file.getName());
        if (file.isDirectory()) {
            if (!(outFile.exists() && outFile.isDirectory() || outFile.mkdir())) {
                throw new IOException("Cannot create directory:" + outFile);
            }
            for (File subFile : file.listFiles()) {
                IlrFileUtil.copyToDir(subFile, outFile);
            }
        } else {
            IlrFileUtil.copy(file, outFile);
        }
    }

    public static final boolean delete(File file, boolean recursive) {
        if (file.isDirectory() && recursive) {
            for (File subFile : file.listFiles()) {
                if (IlrFileUtil.delete(subFile, recursive)) continue;
                return false;
            }
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copy(File inputFile, File outputFile) throws IOException {
        InputStream input = null;
        try {
            input = new BufferedInputStream(new FileInputStream(inputFile));
            IlrFileUtil.copy(input, outputFile);
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copy(InputStream input, File outputFile) throws IOException {
        OutputStream output = null;
        try {
            output = new BufferedOutputStream(new FileOutputStream(outputFile));
            IlrFileUtil.copy(input, output);
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static final void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[1024];
        int i = 0;
        while ((i = input.read(buffer)) != -1) {
            output.write(buffer, 0, i);
        }
    }

    public static final File createTempDir(File parentDir, String pprefix, String psuffix) throws IOException {
        String suffix = psuffix;
        String prefix = pprefix;
        if (prefix == null) {
            prefix = "tmp";
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            String tmpDirname = prefix + i + suffix;
            File tmpDir = new File(parentDir, tmpDirname);
            if (tmpDir.exists() || !tmpDir.mkdir()) continue;
            return tmpDir;
        }
        throw new IOException(XXMessageCode.HELPER.getLocalizedMessage(XXMessageCode.ERROR_CANNOT_CREATE_TEMP_DIRECTORY));
    }

    public static boolean rdiff(File dir1, File dir2) throws IOException {
        boolean result = false;
        for (File file1 : dir1.listFiles()) {
            File file2 = new File(dir2, file1.getName());
            if (file1.isDirectory()) {
                if (!file2.exists()) {
                    result = true;
                    continue;
                }
                if (file2.isDirectory()) {
                    if (!IlrFileUtil.rdiff(file1, file2)) continue;
                    result = true;
                    continue;
                }
                result = true;
                continue;
            }
            if (!file2.exists()) {
                result = true;
                continue;
            }
            if (file2.isFile()) {
                if (!IlrFileUtil.diff(file1, file2)) continue;
                result = true;
                continue;
            }
            result = true;
        }
        return result;
    }

    public static final boolean diff(File file1, File file2) throws IOException {
        int c2;
        int c1;
        boolean result = false;
        if (file1.length() != file2.length()) {
            return true;
        }
        FileInputStream input1 = new FileInputStream(file1);
        FileInputStream input2 = new FileInputStream(file2);
        while ((c1 = ((InputStream)input1).read()) != -1) {
            c2 = ((InputStream)input2).read();
            if (c1 == c2) continue;
            result = true;
        }
        while ((c2 = ((InputStream)input2).read()) != -1) {
            result = true;
        }
        ((InputStream)input1).close();
        ((InputStream)input2).close();
        return result;
    }

    public static final int countFiles(File file) {
        if (file.isFile()) {
            return 1;
        }
        File[] files = file.listFiles();
        if (files == null) {
            return 0;
        }
        int n = 0;
        for (File f : files) {
            if (f.isDirectory()) {
                n += IlrFileUtil.countFiles(f);
                continue;
            }
            ++n;
        }
        return n;
    }
}

