/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.util.zip;

import ilog.rules.res.util.io.IlrFileUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class IlrZIPUtil {
    public static void unzip(File zipFile, File outputDir) throws IOException {
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> entries = zip.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                File dir = new File(outputDir, entry.getName());
                dir.mkdirs();
                continue;
            }
            File outputFile = new File(outputDir, entry.getName());
            File parent = outputFile.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            IlrFileUtil.copy(zip.getInputStream(entry), outputFile);
        }
        zip.close();
    }

    public static Map<String, byte[]> toMap(ZipInputStream zipInput) throws IOException {
        HashMap<String, byte[]> entriesData = new HashMap<String, byte[]>();
        ZipEntry entry = null;
        while ((entry = zipInput.getNextEntry()) != null) {
            if (entry.isDirectory()) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            IlrFileUtil.copy((InputStream)zipInput, baos);
            entriesData.put(entry.getName(), baos.toByteArray());
            zipInput.closeEntry();
        }
        return entriesData;
    }
}

