/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.dataconnector.internal;

import com.ibm.rules.engine.connector.DataConnector;
import com.ibm.rules.engine.connector.DataConnectorException;
import com.ibm.rules.engine.connector.DataConnectorFactory;
import com.ibm.rules.engine.service.EngineService;
import ilog.rules.res.xu.dataconnector.internal.PropertiesDataConnector;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;

public class IlrPropertiesFileDataConnectorFactory
implements DataConnectorFactory {
    private static final long serialVersionUID = 1L;
    public static final String REPOSITORY_PATH = "repository";
    public static final String FILE_NAME = "propsdcf.name";
    public static final String TYPE = "propsdcf.type";
    public static final String TYPE_XML = "xml";
    public static final String TYPE_TEXT = "text";
    protected File repositoryDir;

    public void initialize(Map<String, String> properties) throws DataConnectorException {
        String sdir = properties.get(REPOSITORY_PATH);
        if (sdir == null) {
            throw new DataConnectorException();
        }
        this.repositoryDir = new File(sdir);
    }

    public DataConnector createDataConnector(String dconnName, Map<String, String> props) throws DataConnectorException {
        boolean xmlLut;
        if (this.repositoryDir == null) {
            throw new DataConnectorException();
        }
        String stype = props.get(TYPE);
        if (stype == null || stype.equals(TYPE_TEXT)) {
            xmlLut = false;
        } else if (stype.equals(TYPE_XML)) {
            xmlLut = true;
        } else {
            throw new DataConnectorException();
        }
        Properties properties = new Properties();
        InputStream input = null;
        try {
            File pfile = new File(this.repositoryDir, props.get(FILE_NAME));
            input = new FileInputStream(pfile);
            if (xmlLut) {
                properties.loadFromXML(input);
            } else {
                properties.load(input);
            }
        }
        catch (IOException e) {
            throw new DataConnectorException((Exception)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
        return new PropertiesDataConnector(properties);
    }

    public void close() {
        this.repositoryDir = null;
    }

    public Class<? extends EngineService> getServiceClass() {
        return null;
    }
}

