/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.event.internal;

import com.ibm.rules.res.xu.info.internal.XUInfoImpl;
import ilog.rules.bres.xu.event.IlrConnectorEvent;
import ilog.rules.bres.xu.event.IlrConnectorEventListener;
import ilog.rules.bres.xu.event.IlrErrorEvent;
import ilog.rules.bres.xu.event.IlrErrorEventListener;
import ilog.rules.bres.xu.event.IlrLocalTransactionEvent;
import ilog.rules.bres.xu.event.IlrLocalTransactionEventListener;
import ilog.rules.bres.xu.event.IlrProfilingConnectionEvent;
import ilog.rules.bres.xu.event.IlrProfilingConnectionEventListener;
import ilog.rules.bres.xu.event.IlrProfilingManagedConnectionEvent;
import ilog.rules.bres.xu.event.IlrProfilingManagedConnectionEventListener;
import ilog.rules.bres.xu.event.IlrProfilingRuleEngineEvent;
import ilog.rules.bres.xu.event.IlrProfilingRuleEngineEventListener;
import ilog.rules.bres.xu.event.IlrProfilingRulesetEvent;
import ilog.rules.bres.xu.event.IlrProfilingRulesetEventListener;
import ilog.rules.bres.xu.event.IlrProfilingRulesetInformationProviderEvent;
import ilog.rules.bres.xu.event.IlrProfilingRulesetInformationProviderEventListener;
import ilog.rules.bres.xu.event.IlrProfilingSessionEvent;
import ilog.rules.bres.xu.event.IlrProfilingSessionEventListener;
import ilog.rules.bres.xu.event.IlrRulesetArchiveEvent;
import ilog.rules.bres.xu.event.IlrRulesetArchiveEventListener;
import ilog.rules.bres.xu.event.IlrRulesetEvent;
import ilog.rules.bres.xu.event.IlrRulesetEventListener;
import ilog.rules.bres.xu.event.IlrWarningEvent;
import ilog.rules.bres.xu.event.IlrWarningEventListener;
import ilog.rules.res.xu.event.IlrConnectionEvent;
import ilog.rules.res.xu.event.IlrConnectionEventListener;
import ilog.rules.res.xu.event.IlrRuleEngineEvent;
import ilog.rules.res.xu.event.IlrRuleEngineEventListener;
import ilog.rules.res.xu.event.internal.IlrXUEventListener;
import ilog.rules.res.xu.event.internal.IlrXUEventMaskParser;
import ilog.rules.res.xu.event.internal.ListenerHandle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;

public final class IlrXUEventDispatcher
implements IlrRulesetArchiveEventListener,
IlrErrorEventListener,
IlrWarningEventListener,
IlrProfilingRulesetEventListener,
IlrProfilingRuleEngineEventListener,
IlrProfilingSessionEventListener,
IlrProfilingConnectionEventListener,
IlrProfilingManagedConnectionEventListener,
IlrProfilingRulesetInformationProviderEventListener,
IlrRuleEngineEventListener,
IlrConnectionEventListener,
IlrConnectorEventListener,
IlrLocalTransactionEventListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private transient IlrXUEventMaskParser eventMaskParser;
    public static final long DEFAULT_DISPATCHER_MASK = 28183L;
    protected transient ArrayList<ListenerHandle> listeners = new ArrayList();
    private transient Object[] roListeners = new Object[0];
    private long dispatcherMask = 28183L;

    public void setMask(long dispatcherMask) {
        this.dispatcherMask = dispatcherMask;
    }

    public void setMask(String masks) {
        this.dispatcherMask = this.getEventMaskParser().parseMasks(masks);
    }

    public String getMask() {
        return this.getEventMaskParser().maskToString(this.dispatcherMask);
    }

    public boolean isEventFired(long eventMask) {
        return (eventMask & this.dispatcherMask) == eventMask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IlrXUEventListener listener, long eventMask) {
        ArrayList<ListenerHandle> arrayList = this.listeners;
        synchronized (arrayList) {
            if (this.listeners.add(new ListenerHandle(listener, eventMask))) {
                this.roListeners = this.listeners.toArray();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(IlrXUEventListener listener, long eventMask, byte priority) {
        ArrayList<ListenerHandle> arrayList = this.listeners;
        synchronized (arrayList) {
            if (priority == 0) {
                if (this.listeners.add(new ListenerHandle(listener, eventMask))) {
                    this.roListeners = this.listeners.toArray();
                }
            } else {
                boolean added = false;
                int size = this.listeners.size();
                for (int i = 0; i < size; ++i) {
                    if (priority <= this.listeners.get((int)i).priority) continue;
                    this.listeners.add(i, new ListenerHandle(listener, eventMask, priority));
                    added = true;
                    break;
                }
                if (!added) {
                    this.listeners.add(new ListenerHandle(listener, eventMask, priority));
                }
                this.roListeners = this.listeners.toArray();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IlrXUEventListener listener, long eventMask) {
        ArrayList<ListenerHandle> arrayList = this.listeners;
        synchronized (arrayList) {
            boolean modified = false;
            int size = this.listeners.size();
            for (int i = 0; i < size; ++i) {
                ListenerHandle listenerH = this.listeners.get(i);
                if (listenerH.listener != listener || listenerH.eventMask != eventMask || this.listeners.remove(i) == null) continue;
                modified = true;
                size = this.listeners.size();
            }
            if (modified) {
                this.roListeners = this.listeners.toArray();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void localTransactionEventRaised(IlrLocalTransactionEvent event) {
        Object[] tmpListeners;
        if (!this.isEventFired(16384L)) {
            return;
        }
        ArrayList<ListenerHandle> arrayList = this.listeners;
        synchronized (arrayList) {
            tmpListeners = this.roListeners;
        }
        for (int i = 0; i < tmpListeners.length; ++i) {
            ListenerHandle listenerH = (ListenerHandle)tmpListeners[i];
            if ((listenerH.eventMask & 0x4000L) <= 0L) continue;
            ((IlrLocalTransactionEventListener)listenerH.listener).localTransactionEventRaised(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectorEventRaised(IlrConnectorEvent event) {
        Object[] tmpListeners;
        if (!this.isEventFired(8192L)) {
            return;
        }
        ArrayList<ListenerHandle> arrayList = this.listeners;
        synchronized (arrayList) {
            tmpListeners = this.roListeners;
        }
        for (int i = 0; i < tmpListeners.length; ++i) {
            ListenerHandle listenerH = (ListenerHandle)tmpListeners[i];
            if ((listenerH.eventMask & 0x2000L) <= 0L) continue;
            ((IlrConnectorEventListener)listenerH.listener).connectorEventRaised(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ruleEngineEventRaised(IlrRuleEngineEvent event) {
        Object[] tmpListeners;
        if (!this.isEventFired(512L)) {
            return;
        }
        ArrayList<ListenerHandle> arrayList = this.listeners;
        synchronized (arrayList) {
            tmpListeners = this.roListeners;
        }
        for (int i = 0; i < tmpListeners.length; ++i) {
            ListenerHandle listenerH = (ListenerHandle)tmpListeners[i];
            if ((listenerH.eventMask & 0x200L) <= 0L) continue;
            ((IlrRuleEngineEventListener)listenerH.listener).ruleEngineEventRaised(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rulesetEventRaised(IlrRulesetEvent event) {
        Object[] tmpListeners;
        if (!this.isEventFired(1024L)) {
            return;
        }
        ArrayList<ListenerHandle> arrayList = this.listeners;
        synchronized (arrayList) {
            tmpListeners = this.roListeners;
        }
        for (int i = 0; i < tmpListeners.length; ++i) {
            ListenerHandle listenerH = (ListenerHandle)tmpListeners[i];
            if ((listenerH.eventMask & 0x400L) <= 0L) continue;
            ((IlrRulesetEventListener)listenerH.listener).rulesetEventRaised(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void warningRaised(IlrWarningEvent event) {
        Object[] tmpListeners;
        if (!this.isEventFired(4L)) {
            return;
        }
        ArrayList<ListenerHandle> arrayList = this.listeners;
        synchronized (arrayList) {
            tmpListeners = this.roListeners;
        }
        for (int i = 0; i < tmpListeners.length; ++i) {
            ListenerHandle listenerH = (ListenerHandle)tmpListeners[i];
            if ((listenerH.eventMask & 4L) <= 0L) continue;
            ((IlrWarningEventListener)listenerH.listener).warningRaised(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void errorRaised(IlrErrorEvent event) {
        Object[] tmpListeners;
        if (!this.isEventFired(2L)) {
            return;
        }
        ArrayList<ListenerHandle> arrayList = this.listeners;
        synchronized (arrayList) {
            tmpListeners = this.roListeners;
        }
        for (int i = 0; i < tmpListeners.length; ++i) {
            ListenerHandle listenerH = (ListenerHandle)tmpListeners[i];
            if ((listenerH.eventMask & 2L) <= 0L) continue;
            ((IlrErrorEventListener)listenerH.listener).errorRaised(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changePerformed(IlrRulesetArchiveEvent event) {
        Object[] tmpListeners;
        if (!this.isEventFired(1L)) {
            return;
        }
        ArrayList<ListenerHandle> arrayList = this.listeners;
        synchronized (arrayList) {
            tmpListeners = this.roListeners;
        }
        for (int i = 0; i < tmpListeners.length; ++i) {
            ListenerHandle listenerH = (ListenerHandle)tmpListeners[i];
            if ((listenerH.eventMask & 1L) <= 0L) continue;
            ((IlrRulesetArchiveEventListener)listenerH.listener).changePerformed(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void profilingRulesetActionPerformed(IlrProfilingRulesetEvent event) {
        Object[] tmpListeners;
        if (!this.isEventFired(8L)) {
            return;
        }
        ArrayList<ListenerHandle> arrayList = this.listeners;
        synchronized (arrayList) {
            tmpListeners = this.roListeners;
        }
        for (int i = 0; i < tmpListeners.length; ++i) {
            ListenerHandle listenerH = (ListenerHandle)tmpListeners[i];
            if ((listenerH.eventMask & 8L) <= 0L) continue;
            ((IlrProfilingRulesetEventListener)listenerH.listener).profilingRulesetActionPerformed(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void profilingRuleEngineActionPerformed(IlrProfilingRuleEngineEvent event) {
        Object[] tmpListeners;
        if (!this.isEventFired(16L)) {
            return;
        }
        ArrayList<ListenerHandle> arrayList = this.listeners;
        synchronized (arrayList) {
            tmpListeners = this.roListeners;
        }
        for (int i = 0; i < tmpListeners.length; ++i) {
            ListenerHandle listenerH = (ListenerHandle)tmpListeners[i];
            if ((listenerH.eventMask & 0x10L) <= 0L) continue;
            ((IlrProfilingRuleEngineEventListener)listenerH.listener).profilingRuleEngineActionPerformed(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void profilingSessionActionPerformed(IlrProfilingSessionEvent event) {
        Object[] tmpListeners;
        if (!this.isEventFired(32L)) {
            return;
        }
        ArrayList<ListenerHandle> arrayList = this.listeners;
        synchronized (arrayList) {
            tmpListeners = this.roListeners;
        }
        for (int i = 0; i < tmpListeners.length; ++i) {
            ListenerHandle listenerH = (ListenerHandle)tmpListeners[i];
            if ((listenerH.eventMask & 0x20L) <= 0L) continue;
            ((IlrProfilingSessionEventListener)listenerH.listener).profilingSessionActionPerformed(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void profilingConnectionActionPerformed(IlrProfilingConnectionEvent event) {
        Object[] tmpListeners;
        if (!this.isEventFired(64L)) {
            return;
        }
        ArrayList<ListenerHandle> arrayList = this.listeners;
        synchronized (arrayList) {
            tmpListeners = this.roListeners;
        }
        for (int i = 0; i < tmpListeners.length; ++i) {
            ListenerHandle listenerH = (ListenerHandle)tmpListeners[i];
            if ((listenerH.eventMask & 0x40L) <= 0L) continue;
            ((IlrProfilingConnectionEventListener)listenerH.listener).profilingConnectionActionPerformed(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void profilingManagedConnectionActionPerformed(IlrProfilingManagedConnectionEvent event) {
        Object[] tmpListeners;
        if (!this.isEventFired(128L)) {
            return;
        }
        ArrayList<ListenerHandle> arrayList = this.listeners;
        synchronized (arrayList) {
            tmpListeners = this.roListeners;
        }
        for (int i = 0; i < tmpListeners.length; ++i) {
            ListenerHandle listenerH = (ListenerHandle)tmpListeners[i];
            if ((listenerH.eventMask & 0x80L) <= 0L) continue;
            ((IlrProfilingManagedConnectionEventListener)listenerH.listener).profilingManagedConnectionActionPerformed(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void profilingRulesetInformationProviderActionPerformed(IlrProfilingRulesetInformationProviderEvent evt) {
        Object[] tmpListeners;
        if (!this.isEventFired(256L)) {
            return;
        }
        ArrayList<ListenerHandle> arrayList = this.listeners;
        synchronized (arrayList) {
            tmpListeners = this.roListeners;
        }
        for (int i = 0; i < tmpListeners.length; ++i) {
            ListenerHandle listenerH = (ListenerHandle)tmpListeners[i];
            if ((listenerH.eventMask & 0x100L) <= 0L) continue;
            IlrProfilingRulesetInformationProviderEventListener l = (IlrProfilingRulesetInformationProviderEventListener)listenerH.listener;
            l.profilingRulesetInformationProviderActionPerformed(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(XUInfoImpl dump) {
        Object[] tmpListeners;
        ArrayList<ListenerHandle> arrayList = this.listeners;
        synchronized (arrayList) {
            tmpListeners = this.roListeners;
        }
        for (int i = 0; i < tmpListeners.length; ++i) {
            ListenerHandle listenerH = (ListenerHandle)tmpListeners[i];
            dump.addEventListener(Long.toHexString(listenerH.eventMask), listenerH.listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionEventRaised(IlrConnectionEvent event) {
        Object[] tmpListeners;
        if (!this.isEventFired(2048L)) {
            return;
        }
        ArrayList<ListenerHandle> arrayList = this.listeners;
        synchronized (arrayList) {
            tmpListeners = this.roListeners;
        }
        for (int i = 0; i < tmpListeners.length; ++i) {
            ListenerHandle listenerH = (ListenerHandle)tmpListeners[i];
            if ((listenerH.eventMask & 0x800L) <= 0L) continue;
            ((IlrConnectionEventListener)listenerH.listener).connectionEventRaised(event);
        }
    }

    protected synchronized IlrXUEventMaskParser getEventMaskParser() {
        if (this.eventMaskParser == null) {
            this.eventMaskParser = new IlrXUEventMaskParser();
            this.eventMaskParser.initialize();
        }
        return this.eventMaskParser;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ArrayList<ListenerHandle> serializableListeners = new ArrayList<ListenerHandle>();
        for (int i = 0; i < this.listeners.size(); ++i) {
            ListenerHandle handle = this.listeners.get(i);
            if (!(handle.listener instanceof Serializable)) continue;
            serializableListeners.add(handle);
        }
        stream.writeObject(serializableListeners);
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.listeners = (ArrayList)in.readObject();
        this.roListeners = this.listeners.toArray();
        in.defaultReadObject();
    }
}

