/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.management;

import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.management.XUManagementPlugin;
import ilog.rules.res.xu.management.IlrMBeanExceptionHelper;
import ilog.rules.res.xu.management.IlrXUManagementMBean;
import ilog.rules.res.xu.management.IlrXUMonitoring;
import java.lang.ref.WeakReference;
import javax.management.OperationsException;

public class IlrXUManagement
extends IlrXUMonitoring
implements IlrXUManagementMBean {
    protected WeakReference<XUManagementPlugin> mPlugin = null;

    public IlrXUManagement(XUManagementPlugin plugin) {
        super(plugin);
        this.mPlugin = new WeakReference<XUManagementPlugin>(plugin);
    }

    protected synchronized XUManagementPlugin getManagementPlugin() {
        XUManagementPlugin p = (XUManagementPlugin)this.mPlugin.get();
        if (p == null) {
            System.err.println("XUManagementPlugin.getPlugin: plugin has been released");
            throw new IllegalStateException();
        }
        return p;
    }

    @Override
    public void notifyRulesetArchiveChanged(String canonicalRulesetPath) throws OperationsException {
        try {
            this.getManagementPlugin().notifyRulesetArchiveChanged(canonicalRulesetPath);
            this.getManagementPlugin().removeStatistics(canonicalRulesetPath);
        }
        catch (XUException e) {
            String code = "XU.ERROR.10033";
            throw IlrMBeanExceptionHelper.createOperationException(code, new Object[]{canonicalRulesetPath, e.getMessage()});
        }
    }
}

