/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.management;

import java.math.BigDecimal;

public class IlrXUStatistics {
    public static final int FIRST_DATE = 0;
    public static final int MIN = 1;
    public static final int COUNT = 2;
    public static final int LAST_DATE = 3;
    public static final int LAST = 4;
    public static final int MAX = 5;
    public static final int TOTAL = 6;
    private final long[] stats;

    public IlrXUStatistics(long[] metrics) {
        if (metrics.length != 7) {
            throw new IllegalStateException();
        }
        this.stats = metrics;
    }

    public IlrXUStatistics(long timestamp, long duration) {
        this.stats = new long[7];
        this.stats[0] = timestamp;
        this.stats[1] = duration;
    }

    public void addMeasurement(long timestamp, long duration) {
        this.stats[2] = this.stats[2] + 1L;
        this.stats[3] = timestamp;
        this.stats[4] = duration;
        if (this.stats[5] < duration) {
            this.stats[5] = duration;
        }
        if (this.stats[1] > duration) {
            this.stats[1] = duration;
        }
        this.stats[6] = this.stats[6] + duration;
    }

    public long getNbExecution() {
        return this.stats[2];
    }

    public long getTotalExecutionTime() {
        return this.stats[6];
    }

    public double getAverageExecutionTime() {
        if (this.getNbExecution() > 0L) {
            return new BigDecimal(this.getTotalExecutionTime()).divide(new BigDecimal(this.getNbExecution()), 3, 6).doubleValue();
        }
        return -1.0;
    }

    public long getMaxExecutionTime() {
        return this.stats[5];
    }

    public long getMinExecutionTime() {
        return this.stats[1];
    }

    public long getLastExecutionTime() {
        return this.stats[4];
    }

    public long getFirstExecutionDate() {
        return this.stats[0];
    }

    public long getLastExecutionDate() {
        return this.stats[3];
    }

    public void unifiedStatistics(IlrXUStatistics xuStats) {
        this.stats[2] = this.stats[2] + xuStats.stats[2];
        this.stats[6] = this.stats[6] + xuStats.stats[6];
        this.stats[1] = Math.min(this.stats[1], xuStats.stats[1]);
        this.stats[5] = Math.max(this.stats[5], xuStats.stats[5]);
        this.stats[0] = Math.min(this.stats[0], xuStats.stats[0]);
        if (this.stats[3] < xuStats.stats[3]) {
            this.stats[3] = xuStats.stats[3];
            this.stats[4] = xuStats.stats[4];
        }
    }

    public long[] toObject() {
        long[] result = new long[7];
        System.arraycopy(this.stats, 0, result, 0, this.stats.length);
        return result;
    }
}

