/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.plugin.internal;

import com.ibm.rules.res.xu.config.internal.XUConfig;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import com.ibm.rules.res.xu.plugin.PluginException;
import com.ibm.rules.res.xu.spi.internal.XUResourceAdapter;
import ilog.rules.bres.xu.event.IlrRulesetArchiveEvent;
import ilog.rules.res.xu.cci.IlrInteractionExtension;
import ilog.rules.res.xu.cci.IlrXUConnectionFactory;
import ilog.rules.res.xu.event.internal.IlrXUEventDispatcher;
import ilog.rules.res.xu.plugin.internal.IlrPlugin;
import ilog.rules.res.xu.ruleset.IlrRulesetUsageInformationMonitor;
import java.util.Properties;

public abstract class IlrAbstractPlugin
implements IlrPlugin {
    protected IlrXUConnectionFactory connectionFactory = null;
    protected Properties properties = new Properties();
    protected LogHandler logHandler = null;
    protected IlrXUEventDispatcher eventDispatcher = null;
    protected XUResourceAdapter adapter;

    @Override
    public void setConnectionFactory(IlrXUConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    @Override
    public void setRulesetUsageInformationMonitor(IlrRulesetUsageInformationMonitor monitor) {
    }

    @Override
    public void setProperties(Properties properties) throws PluginException {
        this.properties = properties;
        this.logHandler.finest("Properties of the plugin " + this.getClass().getName() + ": " + properties);
    }

    @Override
    public void subscribe(IlrXUEventDispatcher eventDispatcher) {
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public void unsubscribe(IlrXUEventDispatcher eventDispatcher) {
    }

    @Override
    public void start() throws PluginException {
        this.logHandler.finest("Starts plugin: " + this.getClass().getName());
    }

    @Override
    public void destroy() throws PluginException {
    }

    @Override
    public void setLogHandler(LogHandler logHandler) {
        this.logHandler = logHandler;
    }

    @Override
    public IlrInteractionExtension getInteractionExtension() {
        return null;
    }

    protected void notifyRulesetArchiveChanged(String canonicalRulesetPath) {
        this.eventDispatcher.changePerformed(new IlrRulesetArchiveEvent(1, canonicalRulesetPath, null));
    }

    @Override
    public void setResourceAdapter(XUResourceAdapter adapter) {
        this.adapter = adapter;
    }

    @Override
    public void setXUConfig(XUConfig cfg) {
    }
}

