/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.ruleset.archive.internal;

import com.ibm.rules.res.logging.internal.XUSourceLogRecord;
import com.ibm.rules.res.xu.client.info.internal.RulesetArchiveInformationCacheInfo;
import com.ibm.rules.res.xu.info.internal.XUInfoImpl;
import com.ibm.rules.res.xu.log.internal.XULogRecordFactory;
import ilog.rules.bres.xu.event.IlrConnectorEvent;
import ilog.rules.bres.xu.event.IlrConnectorEventListener;
import ilog.rules.bres.xu.event.IlrRulesetArchiveEvent;
import ilog.rules.bres.xu.event.IlrRulesetArchiveEventListener;
import ilog.rules.res.xu.ruleset.archive.internal.IlrRulesetArchiveInformationNotFoundException;
import ilog.rules.res.xu.ruleset.archive.internal.IlrXURulesetArchiveInformation;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetPathSolver;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IlrWeakXURulesetArchiveInformationCache
implements IlrRulesetArchiveEventListener,
IlrConnectorEventListener,
Serializable {
    private static final long serialVersionUID = 1L;
    protected transient ArrayList<Entry> entries = new ArrayList();
    protected transient ArrayList<Entry> oldEntries = new ArrayList();
    private transient Logger log;
    protected IlrRulesetPathSolver rulesetPathSolver = null;

    public IlrWeakXURulesetArchiveInformationCache(IlrRulesetPathSolver rulesetPathSolver) {
        this.rulesetPathSolver = rulesetPathSolver;
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    public synchronized void dump(XUInfoImpl xuInfo) {
        RulesetArchiveInformationCacheInfo cacheInfo = xuInfo.getRulesetArchiveInformationCacheInfo();
        for (Entry entry : this.entries) {
            cacheInfo.getRulesetPaths().add(entry.rulesetPath);
        }
        for (Entry entry : this.oldEntries) {
            cacheInfo.getDeprecatedRulesetPaths().add(entry.rulesetPath);
        }
    }

    public synchronized IlrXURulesetArchiveInformation add(String rulesetPath, IlrXURulesetArchiveInformation rulesetArchiveInformation) {
        IlrXURulesetArchiveInformation result = this.get(rulesetPath, rulesetArchiveInformation.getXOMClassLoader());
        if (result == null) {
            this.entries.add(new Entry(rulesetPath, rulesetArchiveInformation));
            result = rulesetArchiveInformation;
        }
        return result;
    }

    public synchronized IlrXURulesetArchiveInformation get(String rulesetPath, ClassLoader xomClassLoader) {
        this.log.log(new XUSourceLogRecord.Entry(new Object[]{rulesetPath, xomClassLoader}));
        Iterator<Entry> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            IlrXURulesetArchiveInformation rulesetArchiveInformation = (IlrXURulesetArchiveInformation)entry.rulesetArchiveInformationReference.get();
            if (rulesetArchiveInformation == null) {
                iterator.remove();
                continue;
            }
            if (!rulesetPath.equals(entry.rulesetPath) || rulesetArchiveInformation.getXOMClassLoader() != xomClassLoader) continue;
            return rulesetArchiveInformation;
        }
        return null;
    }

    public synchronized IlrXURulesetArchiveInformation getDeprecatedRulesetArchiveInformation(String rulesetPath, ClassLoader xomClassLoader) {
        Iterator<Entry> iterator = this.oldEntries.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            IlrXURulesetArchiveInformation rulesetArchiveInformation = (IlrXURulesetArchiveInformation)entry.rulesetArchiveInformationReference.get();
            if (rulesetArchiveInformation == null) {
                iterator.remove();
                continue;
            }
            if (!rulesetPath.equals(entry.rulesetPath) || rulesetArchiveInformation.getXOMClassLoader() != xomClassLoader) continue;
            return rulesetArchiveInformation;
        }
        return null;
    }

    @Override
    public synchronized void connectorEventRaised(IlrConnectorEvent event) {
        String propertyName;
        if (event.getCode() == 0 && ((propertyName = event.getPropertyName()).equals("persistenceProperties") || propertyName.equals("persistenceType"))) {
            this.entries.clear();
        }
    }

    @Override
    public synchronized void changePerformed(IlrRulesetArchiveEvent event) {
        this.log.log(new XUSourceLogRecord.Entry(event));
        String updatedCanonicalRulesetPath = event.getCanonicalRulesetPath();
        Iterator<Entry> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            Entry entry = iterator.next();
            IlrXURulesetArchiveInformation rulesetArchiveInformation = (IlrXURulesetArchiveInformation)entry.rulesetArchiveInformationReference.get();
            if (rulesetArchiveInformation == null) {
                iterator.remove();
                continue;
            }
            String entryCanonicalRulesetPath = rulesetArchiveInformation.getCanonicalPath().toString();
            this.log.log(new XUSourceLogRecord(Level.FINEST, "check: " + entry.rulesetPath, new Object[0]));
            if (entryCanonicalRulesetPath.equals(updatedCanonicalRulesetPath)) {
                iterator.remove();
                this.oldEntries.add(entry);
                continue;
            }
            if (entry.rulesetPath.equals(entryCanonicalRulesetPath)) continue;
            try {
                String newEntryCanonicalRulesetPath = null;
                try {
                    newEntryCanonicalRulesetPath = this.rulesetPathSolver.getCanonicalRulesetPath(entry.rulesetPath);
                    this.log.finest("IlrWeakRulesetInformationCache.updatePerformed  resolve " + entry.rulesetPath + " = " + newEntryCanonicalRulesetPath);
                }
                catch (IlrRulesetArchiveInformationNotFoundException e) {
                    this.log.finest("IlrWeakRulesetInformationCache.updatePerformed: entry has been removed");
                }
                if (newEntryCanonicalRulesetPath != null && entryCanonicalRulesetPath.equals(newEntryCanonicalRulesetPath)) continue;
                this.log.finest("IlrWeakRulesetInformationCache.updatePerformed  entry has changed");
                iterator.remove();
                this.oldEntries.add(entry);
            }
            catch (Exception e) {
                this.log.log(XULogRecordFactory.createXULogRecord(Level.SEVERE, "XU.ERROR.10049", e, new Object[]{entry.rulesetPath}, null));
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.entries = new ArrayList();
        this.oldEntries = new ArrayList();
    }

    protected static class Entry {
        public String rulesetPath = null;
        public WeakReference<IlrXURulesetArchiveInformation> rulesetArchiveInformationReference = null;

        public Entry(String rulesetPath, IlrXURulesetArchiveInformation rulesetInformation) {
            this.rulesetPath = rulesetPath;
            this.rulesetArchiveInformationReference = new WeakReference<IlrXURulesetArchiveInformation>(rulesetInformation);
        }
    }
}

