/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.ruleset.cache.internal;

import com.ibm.rules.res.logging.internal.XULogRecord;
import com.ibm.rules.res.xu.log.internal.XULogRecordFactory;
import ilog.rules.res.xu.ruleset.cache.internal.IlrRulesetCacheImpl;
import java.lang.ref.WeakReference;
import java.util.TimerTask;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IlrMaintenanceTask
extends TimerTask {
    protected WeakReference<IlrRulesetCacheImpl> cacheRef;
    protected WeakReference<Logger> loggerRef;

    public IlrMaintenanceTask(IlrRulesetCacheImpl cache, Logger logger) {
        this.cacheRef = new WeakReference<IlrRulesetCacheImpl>(cache);
        this.loggerRef = new WeakReference<Logger>(logger);
        this.logFinestWithFlush("MaintenanceTask initialized");
    }

    @Override
    public void run() {
        IlrRulesetCacheImpl cache = (IlrRulesetCacheImpl)this.cacheRef.get();
        if (cache == null) {
            this.cancel();
        } else {
            this.logFinestWithFlush("MaintenanceTask run");
            cache.runMaintenanceTask();
        }
    }

    public void logFinestWithFlush(String message) {
        Logger logger = (Logger)this.loggerRef.get();
        if (logger != null) {
            XULogRecord rec = XULogRecordFactory.createXULogRecord(Level.FINEST, message, null, null, null);
            logger.log(rec);
            for (Handler handler : logger.getHandlers()) {
                handler.flush();
            }
        }
    }
}

