/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.ruleset.cache.internal;

import ilog.rules.res.xu.ruleset.IlrXURuleset;
import ilog.rules.res.xu.ruleset.cache.internal.IlrReference;
import ilog.rules.res.xu.ruleset.cache.internal.IlrStrongReference;
import ilog.rules.res.xu.ruleset.cache.internal.IlrWeakReference;

public class IlrRulesetCacheEntry {
    protected String canonicalRulesetPath = null;
    protected ClassLoader xomClassLoader = null;
    protected IlrReference<IlrXURuleset> rulesetReference = null;

    public IlrRulesetCacheEntry(IlrXURuleset executableRuleset, boolean maxIdleTimeOutSupport) {
        this.canonicalRulesetPath = executableRuleset.getCanonicalRulesetPath();
        this.xomClassLoader = executableRuleset.getXOMClassLoader();
        long maxIdleTime = executableRuleset.getRulesetArchiveProperties().getMaxIdleTime();
        this.rulesetReference = maxIdleTime == 0L || maxIdleTimeOutSupport && maxIdleTime != -1L ? new IlrStrongReference<IlrXURuleset>(executableRuleset) : new IlrWeakReference<IlrXURuleset>(executableRuleset);
    }

    public ClassLoader getXOMClassLoader() {
        return this.xomClassLoader;
    }

    public String getCanonicalRulesetPath() {
        return this.canonicalRulesetPath;
    }

    public IlrReference<IlrXURuleset> getRulesetReference() {
        return this.rulesetReference;
    }
}

