/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.ruleset.cache.internal;

import com.ibm.rules.res.xu.info.internal.XUInfoImpl;
import ilog.rules.bres.xu.event.IlrRulesetArchiveEvent;
import ilog.rules.bres.xu.event.IlrRulesetArchiveEventListener;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrPath;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IlrSolvedRulesetPathCache
implements IlrRulesetArchiveEventListener,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, IlrPath> entries = new HashMap<String, IlrPath>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changePerformed(IlrRulesetArchiveEvent event) {
        IlrPath path = event.getIlrPath();
        String ruleset = path.getRulesetName();
        String ruleapp = path.getRuleAppName();
        IlrSolvedRulesetPathCache ilrSolvedRulesetPathCache = this;
        synchronized (ilrSolvedRulesetPathCache) {
            Iterator<Map.Entry<String, IlrPath>> it = this.entries.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, IlrPath> e = it.next();
                IlrPath p = e.getValue();
                if (!p.getRuleAppName().equals(ruleapp) || !p.getRulesetName().equals(ruleset)) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String rulesetPath, String canonicalRulesetPath) {
        try {
            IlrPath p = IlrPath.parsePath(canonicalRulesetPath);
            IlrSolvedRulesetPathCache ilrSolvedRulesetPathCache = this;
            synchronized (ilrSolvedRulesetPathCache) {
                this.entries.put(rulesetPath, p);
            }
        }
        catch (IlrFormatException e) {
            // empty catch block
        }
    }

    public synchronized String get(String rulesetPath) {
        IlrPath p = this.entries.get(rulesetPath);
        if (p == null) {
            return null;
        }
        return p.toString();
    }

    public synchronized void dump(XUInfoImpl dump) {
        for (Map.Entry<String, IlrPath> entry : this.entries.entrySet()) {
            dump.addSolvedRulesetPath(entry.getKey().toString(), entry.getValue().toString());
        }
    }
}

