/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.ruleset.internal;

import com.ibm.rules.res.xu.info.internal.XUInfoImpl;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import com.ibm.rules.res.xu.ruleset.internal.RulesetParsingWork;
import com.ibm.rules.res.xu.ruleset.internal.XURulesetFactory;
import com.ibm.rules.res.xu.ruleset.internal.XURulesetImpl;
import com.ibm.rules.res.xu.util.internal.WeakList;
import com.ibm.rules.res.xu.work.internal.PeriodicWorkManager;
import ilog.rules.bres.xu.profiling.IlrProfilingHelper;
import ilog.rules.res.xu.IlrXUContext;
import ilog.rules.res.xu.event.internal.IlrXUEventDispatcher;
import ilog.rules.res.xu.ruleset.IlrRulesetCache;
import ilog.rules.res.xu.ruleset.IlrRulesetCacheException;
import ilog.rules.res.xu.ruleset.IlrRulesetUsageInformationMonitor;
import ilog.rules.res.xu.ruleset.archive.internal.IlrRulesetArchiveInformationNotFoundException;
import ilog.rules.res.xu.ruleset.archive.internal.IlrXURulesetArchiveInformation;
import ilog.rules.res.xu.ruleset.cache.internal.IlrRulesetCacheImpl;
import ilog.rules.res.xu.ruleset.cache.internal.IlrRulesetCacheListener;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetAlreadyParsingException;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetCreationException;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetUsageInformationMonitorImpl;
import java.util.HashSet;
import java.util.Map;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;

public final class IlrRulesetProvider
implements RulesetParsingWork.Listener {
    protected transient IlrRulesetCache cache;
    protected final XURulesetFactory factory;
    protected final LogHandler logger;
    protected final HashSet<IlrXURulesetArchiveInformation> parsingRulesets = new HashSet();
    protected transient WorkManager workManager;
    protected transient PeriodicWorkManager periodicWorkMgr;
    protected final Map<String, String> rulesetFactoryProperties;
    protected final Map<String, String> rulesetCacheProperties;
    protected final IlrXUEventDispatcher eventDispatcher;
    protected final IlrRulesetUsageInformationMonitor rulesetUsageMonitor;
    protected WeakList<RulesetParsingWork> works = new WeakList();

    public IlrRulesetProvider(LogHandler logger, IlrXUEventDispatcher eventDispatcher, IlrProfilingHelper profiling, Map<String, String> factoryProps, Map<String, String> rulesetCacheProps, Map<String, String> caCacheProps, IlrRulesetUsageInformationMonitorImpl rulesetUsageMonitor, WorkManager workManager) {
        this.logger = logger;
        this.rulesetCacheProperties = rulesetCacheProps;
        this.eventDispatcher = eventDispatcher;
        this.rulesetUsageMonitor = rulesetUsageMonitor;
        this.workManager = workManager;
        this.factory = new XURulesetFactory(logger, eventDispatcher, profiling, factoryProps, caCacheProps, rulesetUsageMonitor);
        this.rulesetFactoryProperties = factoryProps;
        if (rulesetUsageMonitor != null) {
            this.factory.addExecutableRulesetFactoryListener(rulesetUsageMonitor);
        }
    }

    protected final IlrRulesetCache createCache(Map<String, String> properties, IlrXUEventDispatcher dispatcher, IlrRulesetUsageInformationMonitor rulesetUsageMonitor) throws IlrRulesetCacheException {
        String classStr;
        IlrRulesetCache cache = null;
        if (properties != null && (classStr = properties.get("ruleset.cache.class")) != null) {
            try {
                Class<?> clazz = Class.forName(classStr, true, this.getClass().getClassLoader());
                cache = (IlrRulesetCache)clazz.newInstance();
            }
            catch (Throwable e) {
                this.logger.severe("XU.ERROR.16000", e, null, null);
            }
        }
        if (cache == null) {
            this.logger.finest("create default ruleset cache");
            cache = new IlrRulesetCacheImpl();
        }
        if (cache instanceof IlrRulesetCacheImpl) {
            ((IlrRulesetCacheImpl)cache).setPeriodicWorkManager(this.periodicWorkMgr);
        }
        cache.initialize(this.logger.getLogger(), properties, rulesetUsageMonitor);
        IlrRulesetCacheListener listener = new IlrRulesetCacheListener(cache, this.logger);
        dispatcher.addListener(listener, 8193L, (byte)125);
        return cache;
    }

    public final XURulesetImpl getDeprecatedRuleset(String canonicalPath, ClassLoader cl) throws IlrRulesetCacheException {
        return (XURulesetImpl)this.getCache().getDeprecatedRuleset(canonicalPath, cl);
    }

    protected final boolean useWorkManager(IlrXURulesetArchiveInformation archive) {
        if (this.workManager == null) {
            return false;
        }
        String propWM = (String)archive.getProperties().get("workmanager");
        return propWM == null || propWM.equals("true");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final RulesetParsingWork startParsingWork(IlrXURulesetArchiveInformation archive, RulesetParsingWork.Listener listener, IlrXUContext xuCtx) throws IlrRulesetCreationException {
        try {
            RulesetParsingWork work = new RulesetParsingWork(archive, this.factory, xuCtx, this.logger);
            work.addListener(this);
            if (listener != null) {
                work.addListener(listener);
            }
            WeakList<RulesetParsingWork> weakList = this.works;
            synchronized (weakList) {
                this.works.add(work);
                this.works.removeNullTargetReferences();
            }
            this.workManager.startWork((Work)work);
            return work;
        }
        catch (WorkException e) {
            this.parsingStopped(archive);
            throw new IlrRulesetCreationException("XU.ERROR.10009", null, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final XURulesetImpl getRuleset(IlrXURulesetArchiveInformation archive, IlrXUContext xuCtx, boolean waitParsing, RulesetParsingWork.Listener listener) throws IlrRulesetArchiveInformationNotFoundException, IlrRulesetCreationException, IlrRulesetAlreadyParsingException, IlrRulesetCacheException, XUException {
        XURulesetImpl ruleset;
        Object object;
        String canonicalPath = archive.getCanonicalPath().toString();
        this.logger.finest("IlrRulesetProvider.getRuleset " + canonicalPath + " " + waitParsing);
        if (!archive.getProperties().isShareable()) {
            return this.factory.createRuleset(archive, xuCtx);
        }
        ClassLoader cl = archive.getXOMClassLoader();
        while (true) {
            object = this.parsingRulesets;
            synchronized (object) {
                ruleset = (XURulesetImpl)this.getCache().getRuleset(canonicalPath, cl);
                if (ruleset != null) {
                    return ruleset;
                }
                if (this.parsingRulesets.contains(archive)) {
                    if (!waitParsing) throw new IlrRulesetAlreadyParsingException("XU.ERROR.10406", null);
                    try {
                        this.parsingRulesets.wait();
                    }
                    catch (InterruptedException e) {
                        throw new IlrRulesetCreationException("XU.ERROR.10009", null, (Throwable)e);
                    }
                } else {
                    this.parsingRulesets.add(archive);
                    break;
                }
            }
        }
        if (this.useWorkManager(archive)) {
            this.logger.finest("IlrRulesetProvider.getRuleset use the workmanager", null, xuCtx);
            RulesetParsingWork work = this.startParsingWork(archive, listener, xuCtx);
            if (!waitParsing) throw new IlrRulesetAlreadyParsingException("XU.ERROR.10406", null);
            while (true) {
                object = this.parsingRulesets;
                synchronized (object) {
                    try {
                        if (!this.parsingRulesets.contains(archive)) {
                            if (work.getException() != null) {
                                throw work.getException();
                            }
                            return work.getRuleset();
                        }
                        this.parsingRulesets.wait();
                    }
                    catch (InterruptedException e) {
                        throw new IlrRulesetCreationException("XU.ERROR.10009", null, (Throwable)e);
                    }
                }
            }
        }
        this.logger.finest("IlrRulesetProvider.getRuleset doesn't use the workmanager " + this.workManager, null, xuCtx);
        try {
            ruleset = this.factory.createRuleset(archive, xuCtx);
            this.getCache().addRuleset(ruleset);
            object = ruleset;
            return object;
        }
        finally {
            this.parsingStopped(archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dump(XUInfoImpl dump) {
        WeakList<RulesetParsingWork> weakList = this.works;
        synchronized (weakList) {
            for (RulesetParsingWork work : this.works) {
                String canonicalPath = work.getArchive().getCanonicalPath().toString();
                dump.addRulestParsingWorkInfo(canonicalPath, work.getState());
            }
        }
        try {
            if (this.getCache() instanceof IlrRulesetCacheImpl) {
                ((IlrRulesetCacheImpl)this.cache).dump(dump);
            }
        }
        catch (IlrRulesetCacheException e) {
            this.logger.severe("XU.ERROR.16001", e, null, null);
        }
    }

    public final synchronized IlrRulesetCache getCache() throws IlrRulesetCacheException {
        if (this.cache == null) {
            this.cache = this.createCache(this.rulesetCacheProperties, this.eventDispatcher, this.rulesetUsageMonitor);
        }
        return this.cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void parsingStopped(IlrXURulesetArchiveInformation archive) {
        HashSet<IlrXURulesetArchiveInformation> hashSet = this.parsingRulesets;
        synchronized (hashSet) {
            this.parsingRulesets.remove(archive);
            this.parsingRulesets.notifyAll();
        }
    }

    @Override
    public final void workEnded(RulesetParsingWork work) {
        if (work.getState() == 2) {
            try {
                this.getCache().addRuleset(work.getRuleset());
            }
            catch (IlrRulesetCacheException e) {
                this.logger.severe("XU.ERROR.16001", e, null, null);
            }
        }
        this.parsingStopped(work.getArchive());
    }

    public final void setPeriodicWorkManager(PeriodicWorkManager mgr) {
        this.periodicWorkMgr = mgr;
    }
}

