/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.ruleset.internal;

import ilog.rules.res.xu.ruleset.IlrRulesetUsageInformation;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetUsageInformationMonitorImpl;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class IlrRulesetUsageInformationImpl
implements IlrRulesetUsageInformation,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String KEY_EXECUTION_DURATION = "executionDuration";
    public static final String KEY_SET_PARAMETERS_DURATION = "setParametersDuration";
    public static final String KEY_GET_PARAMETERS_DURATION = "getParametersDuration";
    public static final String KEY_LAST_USAGE_TIME = "lastUsageTime";
    public static final String KEY_PARSING_DURATION = "parsingDuration";
    public static final String KEY_EXECUTION_COUNT = "executionCount";
    public static final String KEY_MAXIMUM_EXECUTION_DURATION = "maxExecutionDuration";
    public static final String KEY_RULESET_ESTIMATED_MEMORY_SIZE = "rulesetEstimatedMemorySize";
    long estimatedMemorySize;
    final AtomicLong executionCount = new AtomicLong();
    final AtomicLong executionDuration = new AtomicLong();
    long getParametersDuration;
    long setParametersDuration;
    final AtomicLong longestExecutionDuration = new AtomicLong();
    long parsingDuration;
    final AtomicLong firstExecutionTime = new AtomicLong();
    final AtomicLong shortestExecutionDuration = new AtomicLong();
    final AtomicLong lastExecutionDuration = new AtomicLong();
    private final IlrRulesetUsageInformationMonitorImpl monitor;
    private final String canonicalRulesetPath;

    public IlrRulesetUsageInformationImpl(String canonicalPath, IlrRulesetUsageInformationMonitorImpl monitor) {
        this.monitor = monitor;
        this.canonicalRulesetPath = canonicalPath;
    }

    @Override
    public synchronized long getEstimatedMemorySize() {
        return this.estimatedMemorySize;
    }

    @Override
    public long getExecutionCount() {
        return this.executionCount.longValue();
    }

    @Override
    public long getTotalExecutionDuration() {
        return this.executionDuration.get() / 1000000L;
    }

    @Override
    public synchronized long getTotalGetParametersDuration() {
        return this.getParametersDuration / 1000000L;
    }

    @Override
    public long getLastUsageTime() {
        return this.monitor.getLastTimeUsage(this.canonicalRulesetPath);
    }

    @Override
    public synchronized long getMaximumExecutionDuration() {
        return this.getLongestExecutionDuration();
    }

    @Override
    public long getLongestExecutionDuration() {
        return this.longestExecutionDuration.longValue() / 1000000L;
    }

    @Override
    public synchronized long getParsingDuration() {
        return this.parsingDuration;
    }

    @Override
    public synchronized long getTotalSetParametersDuration() {
        return this.setParametersDuration / 1000000L;
    }

    @Override
    public boolean isIdle() {
        return this.monitor.isIdle(this.canonicalRulesetPath);
    }

    public synchronized void toMap(Map<String, Object> map) {
        map.put(KEY_EXECUTION_DURATION, this.getTotalExecutionDuration());
        map.put(KEY_SET_PARAMETERS_DURATION, this.getTotalSetParametersDuration());
        map.put(KEY_GET_PARAMETERS_DURATION, this.getTotalGetParametersDuration());
        map.put(KEY_LAST_USAGE_TIME, this.getLastUsageTime());
        map.put(KEY_PARSING_DURATION, this.getParsingDuration());
        map.put(KEY_EXECUTION_COUNT, this.getExecutionCount());
        map.put(KEY_MAXIMUM_EXECUTION_DURATION, this.getLongestExecutionDuration());
        map.put(KEY_RULESET_ESTIMATED_MEMORY_SIZE, this.getEstimatedMemorySize());
        map.put("firstExecutionTime", this.getFirstExecutionTime());
        map.put("shortestExecutionDuration", this.getShortestExecutionDuration());
        map.put("lastExecutionDuration", this.getLastExecutionDuration());
    }

    public synchronized Map<String, Object> toMap() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.toMap(map);
        return map;
    }

    @Override
    public long getFirstExecutionTime() {
        return this.firstExecutionTime.longValue();
    }

    @Override
    public long getShortestExecutionDuration() {
        return this.shortestExecutionDuration.longValue() / 1000000L;
    }

    @Override
    public long getLastExecutionDuration() {
        return this.lastExecutionDuration.get() / 1000000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.executionCount.set(0L);
        this.lastExecutionDuration.set(0L);
        this.executionDuration.set(0L);
        this.firstExecutionTime.set(0L);
        this.longestExecutionDuration.set(0L);
        this.shortestExecutionDuration.set(0L);
        IlrRulesetUsageInformationImpl ilrRulesetUsageInformationImpl = this;
        synchronized (ilrRulesetUsageInformationImpl) {
            this.getParametersDuration = 0L;
            this.setParametersDuration = 0L;
        }
    }
}

