/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.ruleset.trace.internal;

import ilog.rules.factory.IlrPropertyList;
import ilog.rules.util.IlrIdConverter;

public class IlrBusinessNameConverter {
    public static String toBusinessName(String technicalName, IlrPropertyList ruleProperties) {
        String rbName;
        if (ruleProperties != null && (rbName = ruleProperties.getString("ilog.rules.business_name", null)) != null && !rbName.equals("")) {
            String pbName = ruleProperties.getString("ilog.rules.package_name", null);
            if (pbName == null || pbName.equals("")) {
                return rbName;
            }
            return pbName + "." + rbName;
        }
        String bname = IlrIdConverter.getBusinessIdentifier(technicalName);
        if (ruleProperties != null && ruleProperties.containsKey("ilog.rules.dt")) {
            int idx;
            int n = bname.length();
            for (idx = n - 1; idx >= 0 && bname.charAt(idx) != ' '; --idx) {
            }
            if (idx >= 0 && idx < n - 1) {
                String id = bname.substring(idx + 1);
                try {
                    String sid = Long.toString(Long.parseLong(id) + 1L);
                    StringBuffer buffer = new StringBuffer();
                    buffer.append(bname.subSequence(0, idx + 1));
                    buffer.append(sid);
                    bname = buffer.toString();
                }
                catch (NumberFormatException e) {
                    return bname;
                }
            }
        }
        return bname;
    }
}

