/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.spi;

import com.ibm.rules.res.message.internal.XUMessageCode;
import com.ibm.rules.res.util.internal.PropertiesConverter;
import com.ibm.rules.res.xu.bom.internal.DocumentBuilderPool;
import com.ibm.rules.res.xu.bom.internal.TransformerPool;
import com.ibm.rules.res.xu.client.internal.XUConfigImpl;
import com.ibm.rules.res.xu.client.internal.jca.JCAPluginsPropertyParser;
import com.ibm.rules.res.xu.client.internal.jca.ParseException;
import com.ibm.rules.res.xu.config.internal.ConnectionPoolConfig;
import com.ibm.rules.res.xu.config.internal.PluginConfig;
import com.ibm.rules.res.xu.config.internal.PoolConfig;
import com.ibm.rules.res.xu.config.internal.RulesetCacheConfig;
import com.ibm.rules.res.xu.config.internal.XUConfig;
import com.ibm.rules.res.xu.engine.cre.internal.ContextFactory;
import com.ibm.rules.res.xu.event.internal.ConnectionEventImpl;
import com.ibm.rules.res.xu.event.internal.RulesetArchiveEventImpl;
import com.ibm.rules.res.xu.event.internal.XUListener;
import com.ibm.rules.res.xu.info.internal.XUInfoImpl;
import com.ibm.rules.res.xu.info.internal.XUInfoScheduler;
import com.ibm.rules.res.xu.internal.LocalizedNotSupportedException;
import com.ibm.rules.res.xu.internal.LocalizedResourceException;
import com.ibm.rules.res.xu.internal.XUException;
import com.ibm.rules.res.xu.log.internal.LogHandler;
import com.ibm.rules.res.xu.persistence.internal.Persistence;
import com.ibm.rules.res.xu.spi.config.internal.SPIPersistenceConfigImpl;
import com.ibm.rules.res.xu.spi.config.internal.SPIXUConfigImpl;
import com.ibm.rules.res.xu.spi.internal.BOMConversionPools;
import com.ibm.rules.res.xu.spi.internal.XUConnectionManager;
import com.ibm.rules.res.xu.spi.internal.XUConnectionWeakSet;
import com.ibm.rules.res.xu.spi.internal.XUResourceAdapter;
import com.ibm.rules.res.xu.util.internal.WeakList;
import com.ibm.rules.res.xu.work.internal.PeriodicWorkManager;
import com.ibm.rules.res.xu.work.internal.WorkManagerImpl;
import ilog.rules.bres.xu.event.IlrConnectorEvent;
import ilog.rules.bres.xu.event.IlrRulesetArchiveEvent;
import ilog.rules.bres.xu.event.IlrRulesetArchiveEventListener;
import ilog.rules.bres.xu.profiling.IlrProfilingHelper;
import ilog.rules.res.model.IlrFormatException;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.mprofiler.IlrMemoryInstrumentation;
import ilog.rules.res.mprofiler.IlrMemoryProfiler;
import ilog.rules.res.mprofiler.xml.IlrXMLWriter;
import ilog.rules.res.xu.IlrXUContext;
import ilog.rules.res.xu.cci.IlrConnectionId;
import ilog.rules.res.xu.cci.IlrConnectionIdGenerator;
import ilog.rules.res.xu.cci.IlrInteractionExtension;
import ilog.rules.res.xu.cci.IlrXUConnection;
import ilog.rules.res.xu.cci.IlrXUConnectionFactory;
import ilog.rules.res.xu.cci.diagnostic.internal.IlrXUDiagnosticResult;
import ilog.rules.res.xu.cci.diagnostic.internal.IlrXUDiagnosticResultImpl;
import ilog.rules.res.xu.event.internal.IlrXUEventDispatcher;
import ilog.rules.res.xu.persistence.IlrPersistenceException;
import ilog.rules.res.xu.persistence.internal.IlrDatasourcePersistenceImpl;
import ilog.rules.res.xu.persistence.internal.IlrFilePersistenceImpl;
import ilog.rules.res.xu.persistence.internal.IlrJDBCPersistenceImpl;
import ilog.rules.res.xu.plugin.internal.IlrPluginManager;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetProvider;
import ilog.rules.res.xu.ruleset.internal.IlrRulesetUsageInformationMonitorImpl;
import ilog.rules.res.xu.spi.IlrManagedXUConnection;
import ilog.rules.res.xu.spi.IlrXUConnectionRequestInfo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;
import javax.security.auth.Subject;

public class IlrManagedXUConnectionFactory
implements ManagedConnectionFactory,
ResourceAdapterAssociation,
ValidatingManagedConnectionFactory,
IlrRulesetArchiveEventListener,
XUResourceAdapter.Listener {
    private static final long serialVersionUID = 1L;
    protected XUConfig config;
    protected XUConnectionManager connManager;
    protected IlrXUEventDispatcher xuEventDispatcher = new IlrXUEventDispatcher();
    protected IlrProfilingHelper profiling = new IlrProfilingHelper(this.xuEventDispatcher);
    protected LogHandler logger = new LogHandler(this.xuEventDispatcher);
    public boolean isFinestLoggable = this.logger.isLoggable(Level.FINEST);
    protected transient XUResourceAdapter resourceAdapter;
    protected IlrXUEventDispatcher resourceAdapterEventDispatcher;
    protected BOMConversionPools bomPools;
    protected transient List<XUListener> xuListeners = new ArrayList<XUListener>();
    protected String connectionFactoryLock = "connectionFactoryLock";
    protected IlrXUConnectionFactory connectionFactory = null;
    private Persistence persistence;
    protected transient IlrPluginManager pluginManager = new IlrPluginManager(this.logger, this.xuEventDispatcher);
    protected ContextFactory contextFactory = new ContextFactory(this.logger);
    protected transient IlrRulesetProvider rulesetProvider = null;
    protected IlrConnectionIdGenerator identifierGenerator = new IlrConnectionIdGenerator();
    protected XUConnectionWeakSet connections = new XUConnectionWeakSet();
    protected WeakList<IlrManagedXUConnection> managedConnections = new WeakList();
    protected Boolean defaultConnectionLogInFactoryLog = Boolean.FALSE;
    protected Boolean jdkLoggingEnabled = Boolean.FALSE;
    protected Boolean systemOutLoggingEnabled = Boolean.FALSE;
    protected IlrConnectionIdGenerator spiConnectionIdGenerator = new IlrConnectionIdGenerator();
    protected String rulesetFactoryProperties = null;
    protected String memoryProfilerIncludedPackageNames = null;
    protected transient XUInfoScheduler infoScheduler;
    protected Boolean duplicateConnectionEventListenerEnabled = Boolean.TRUE;
    protected IlrRulesetUsageInformationMonitorImpl rulesetUsageMonitor;
    public Object connectionManagerLock = new String("ConnectionManager.Lock");

    public IlrManagedXUConnectionFactory() {
        this.xuEventDispatcher.addListener(this.logger, 17400L);
        this.xuEventDispatcher.addListener(this, 1L);
        this.addXUListener(this.pluginManager);
    }

    public void setDocumentBuilderPoolProperties(String props) throws XUException {
        Map<String, String> map = PropertiesConverter.toMap(props);
        this.logger.info("XU.INFO.8001", new Object[]{"documentBuilderPoolProperties", map});
        PoolConfig cfg = this.getXUConfig().getDocumentBuilderPoolConfig();
        for (Map.Entry<String, String> e : map.entrySet()) {
            cfg.putProperty(e.getKey(), e.getValue());
        }
    }

    public String getDocumentBuilderPoolProperties() throws XUException {
        return PropertiesConverter.toString(this.getXUConfig().getDocumentBuilderPoolConfig().toMap());
    }

    public void setTransformerPoolProperties(String props) throws XUException {
        Map<String, String> map = PropertiesConverter.toMap(props);
        this.logger.info("XU.INFO.8001", new Object[]{"transformerPoolProperties", map});
        PoolConfig cfg = this.getXUConfig().getTransformerPoolConfig();
        for (Map.Entry<String, String> e : map.entrySet()) {
            cfg.putProperty(e.getKey(), e.getValue());
        }
    }

    public String getTransformerPoolProperties() throws XUException {
        return PropertiesConverter.toString(this.getXUConfig().getTransformerPoolConfig().toMap());
    }

    public Boolean getRulesetUsageMonitorEnabled() throws XUException {
        return this.getXUConfig().isRulesetUsageMonitorEnabled();
    }

    public Boolean isRulesetUsageMonitorEnabled() throws XUException {
        return this.getXUConfig().isRulesetUsageMonitorEnabled();
    }

    public void setRulesetUsageMonitorEnabled(Boolean enable) throws XUException {
        this.getXUConfig().setRulesetUsageMonitorEnabled(enable);
    }

    public final Boolean getXuDumpSchedulerEnabled() {
        return this.getInfoScheduler().isEnabled();
    }

    public final Boolean isXuDumpSchedulerEnabled() {
        return this.getInfoScheduler().isEnabled();
    }

    public final Long getXuDumpSchedulerInterval() {
        return this.getInfoScheduler().getInterval();
    }

    public final void setXuDumpSchedulerEnabled(Boolean enabled) throws WorkException {
        this.getInfoScheduler().setEnabled(enabled);
    }

    public final void setXuDumpSchedulerInterval(Long interval) {
        this.getInfoScheduler().setInterval(interval);
    }

    public Boolean getProfilingEnabled() throws XUException {
        return this.getXUConfig().isProfilingInfoLogged();
    }

    public Boolean isProfilingEnabled() throws XUException {
        return this.getXUConfig().isProfilingInfoLogged();
    }

    public void setProfilingEnabled(Boolean profilingEnabled) throws XUException {
        this.logFinest(".setProfilingEnabled(" + profilingEnabled + ")", null);
        this.getXUConfig().setProfilingInfoLogged(profilingEnabled);
    }

    public Boolean getDuplicateConnectionEventListenerEnabled() {
        return this.duplicateConnectionEventListenerEnabled;
    }

    public Boolean isDuplicateConnectionEventListenerEnabled() {
        return this.duplicateConnectionEventListenerEnabled;
    }

    public void setDuplicateConnectionEventListenerEnabled(Boolean duplicateConnectionEventListenerEnabled) {
        this.logger.info("XU.INFO.8001", new Object[]{"duplicateConnectionEventListenerEnabled", duplicateConnectionEventListenerEnabled});
        this.duplicateConnectionEventListenerEnabled = duplicateConnectionEventListenerEnabled == false ? Boolean.FALSE : Boolean.TRUE;
        this.sendPropertyChanged("profilingEnabled");
    }

    public LogHandler getLogHandler() {
        return this.logger;
    }

    public IlrProfilingHelper getProfiling() {
        return this.profiling;
    }

    protected final synchronized XUInfoScheduler getInfoScheduler() {
        if (this.infoScheduler == null) {
            this.infoScheduler = new XUInfoScheduler(this);
        }
        return this.infoScheduler;
    }

    public IlrInteractionExtension[] getInteractionExtensions() {
        return this.pluginManager.getInteractionExtensions();
    }

    public Map<String, Object> getConnectorConfigProperties() throws XUException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("traceLevel", this.getTraceLevel().toString());
        result.put("concurrentOpenClose", this.getConcurrentOpenClose());
        result.put("persistenceProperties", this.getPersistenceProperties());
        result.put("persistenceType", this.getPersistenceType());
        result.put("rulesetUsageMonitorEnabled", this.getRulesetUsageMonitorEnabled().toString());
        result.put("memoryProfilerIncludedPackageNames", this.getMemoryProfilerIncludedPackageNames());
        return result;
    }

    public Boolean getAsynchronousRulesetParsing() throws XUException {
        return this.isAsynchronousRulesetParsing();
    }

    public Boolean isAsynchronousRulesetParsing() throws XUException {
        return this.getXUConfig().isAsynchronousRulesetParsingEnabled();
    }

    public void setAsynchronousRulesetParsing(Boolean asynchronousRulesetParsing) throws XUException {
        this.logger.info("XU.INFO.8001", new Object[]{"asynchronousRulesetParsing", asynchronousRulesetParsing});
        this.getXUConfig().setAsynchronousRulesetParsingEnabled(asynchronousRulesetParsing);
        this.sendPropertyChanged("asynchronousRulesetParsing");
    }

    public Boolean getConcurrentOpenClose() throws XUException {
        return this.getXUConfig().isConcurrentOpenCloseEnabled();
    }

    public Boolean isConcurrentOpenClose() throws XUException {
        return this.getXUConfig().isConcurrentOpenCloseEnabled();
    }

    public void setConcurrentOpenClose(Boolean enable) throws XUException {
        this.getXUConfig().setConcurrentOpenCloseEnabled(enable);
    }

    public Boolean getJdkLoggingEnabled() {
        return this.jdkLoggingEnabled;
    }

    public Boolean isJdkLoggingEnabled() {
        return this.jdkLoggingEnabled;
    }

    public void setJdkLoggingEnabled(Boolean jdkLoggingEnabled) {
        this.logger.info("XU.INFO.8001", new Object[]{"jdkLoggingEnabled", jdkLoggingEnabled});
        this.jdkLoggingEnabled = jdkLoggingEnabled != false ? Boolean.TRUE : Boolean.FALSE;
        this.logger.setJDKLoggingEnabled(jdkLoggingEnabled);
        this.isFinestLoggable = this.logger.isLoggable(Level.FINEST);
        this.sendPropertyChanged("jdkLoggingEnabled");
    }

    public Boolean getSystemOutLoggingEnabled() {
        return this.systemOutLoggingEnabled;
    }

    public Boolean isSystemOutLoggingEnabled() {
        return this.systemOutLoggingEnabled;
    }

    public void setSystemOutLoggingEnabled(Boolean systemOutLoggingEnabled) {
        this.logger.info("XU.INFO.8001", new Object[]{"systemOutLoggingEnabled", systemOutLoggingEnabled});
        if (systemOutLoggingEnabled.booleanValue()) {
            this.logger.setLogWriter(new PrintWriter(System.out));
        }
        this.sendPropertyChanged("systemOutLoggingEnabled");
    }

    @Deprecated
    public void setTraceAutoFlush(Boolean autoFlush) {
        this.logger.info("XU.INFO.8001", new Object[]{"traceAutoFlush", autoFlush});
        this.logger.setAutoFlush(autoFlush);
        this.sendPropertyChanged("traceAutoFlush");
    }

    @Deprecated
    public Boolean getTraceAutoFlush() throws XUException {
        return this.getXUConfig().getLogAutoFlush();
    }

    @Deprecated
    public Boolean isTraceAutoFlush() throws XUException {
        return this.getXUConfig().getLogAutoFlush();
    }

    public void setLogAutoFlush(Boolean autoFlush) throws XUException {
        this.getXUConfig().setLogAutoFlush(autoFlush);
    }

    public Boolean getLogAutoFlush() throws XUException {
        return this.getXUConfig().getLogAutoFlush();
    }

    public String getTraceLevel() throws XUException {
        return this.getXUConfig().getLogLevel().getName();
    }

    public void setTraceLevel(String traceLevel) throws XUException {
        try {
            Level lvl = Level.parse(traceLevel.trim());
            this.getXUConfig().setLogLevel(lvl);
        }
        catch (IllegalArgumentException e) {
            this.logger.severe("XU.ERROR.10100", e, null, null);
        }
    }

    public synchronized void setPersistenceType(String type) throws XUException {
        this.getXUConfig().getPersistenceConfig().setType(type);
    }

    public String getPersistenceType() throws XUException {
        return this.getXUConfig().getPersistenceConfig().getType();
    }

    public synchronized void setPersistenceConfig(Map<String, String> props) throws XUException {
        try {
            ((SPIPersistenceConfigImpl)this.getXUConfig().getPersistenceConfig()).setProperties(props);
        }
        catch (IlrPersistenceException e) {
            this.logger.severe("XU.ERROR.10100", e, null, null);
            return;
        }
    }

    public void setPersistenceProperties(String str) throws XUException {
        Map<String, String> props = PropertiesConverter.toMap(str);
        this.setPersistenceConfig(props);
    }

    public synchronized Map<String, String> retrievePersistenceConfig() throws XUException {
        return ((SPIPersistenceConfigImpl)this.getXUConfig().getPersistenceConfig()).getProperties();
    }

    public synchronized String getPersistenceProperties() throws XUException {
        return PropertiesConverter.toString(this.retrievePersistenceConfig());
    }

    public void setRulesetFactoryProperties(String rulesetFactoryProperties) {
        this.logger.info("XU.INFO.8001", new Object[]{"rulesetFactoryProperties", rulesetFactoryProperties});
        this.rulesetFactoryProperties = rulesetFactoryProperties;
        this.sendPropertyChanged("rulesetFactoryProperties");
    }

    public final void setRulesetCacheProperties(String rulesetCacheProperties) throws XUException {
        this.logger.info("XU.INFO.8001", new Object[]{"rulesetCacheProperties", rulesetCacheProperties});
        RulesetCacheConfig cfg = this.getXUConfig().getRulesetCacheConfig();
        Map<String, String> props = PropertiesConverter.toMap(rulesetCacheProperties);
        for (Map.Entry<String, String> p : props.entrySet()) {
            cfg.putProperty(p.getKey(), p.getValue());
        }
        this.sendPropertyChanged("rulesetCacheProperties");
    }

    public final String getRulesetCacheProperties() throws XUException {
        return this.getXUConfig().getRulesetCacheConfig().toString();
    }

    public final String getCompiledArchivesCacheProperties() throws XUException {
        return PropertiesConverter.toString(this.getXUConfig().getCompiledArchivesCacheProperties());
    }

    public final void setCompiledArchivesCacheProperties(String props) throws XUException {
        this.getXUConfig().setCompiledArchivesCacheProperties(PropertiesConverter.toMap(props));
    }

    public String getRulesetFactoryProperties() {
        return this.rulesetFactoryProperties;
    }

    public void setPlugins(String plugins) throws ParseException {
        this.setPluginConfigs(JCAPluginsPropertyParser.parsePluginConfigs(plugins));
    }

    public void setPluginConfigs(List<PluginConfig> plugins) {
        this.logger.info("XU.INFO.8001", new Object[]{"plugins", JCAPluginsPropertyParser.toString(plugins)});
        this.pluginManager.update(plugins);
        this.sendPropertyChanged("plugins");
    }

    public String getPlugins() {
        List<PluginConfig> cfg = this.pluginManager.getPluginConfigs();
        return JCAPluginsPropertyParser.toString(cfg);
    }

    public IlrPluginManager getPluginManager() {
        return this.pluginManager;
    }

    public void setMemoryProfilerIncludedPackageNames(String memoryProfilerIncludedPackageNames) {
        this.logger.info("XU.INFO.8001", new Object[]{"memoryProfilerIncludedPackageNames", memoryProfilerIncludedPackageNames});
        this.memoryProfilerIncludedPackageNames = memoryProfilerIncludedPackageNames;
        IlrMemoryProfiler profiler = IlrMemoryInstrumentation.getMemoryProfiler();
        if (profiler != null) {
            List<String> packageNames = Arrays.asList(memoryProfilerIncludedPackageNames.split(","));
            this.logger.finest("setMemoryProfilerIncludedPackageNames " + packageNames);
            profiler.setDefaultIncludedPackageNames(packageNames);
        }
        this.sendPropertyChanged("memoryProfilerIncludedPackageNames");
    }

    public String getMemoryProfilerIncludedPackageNames() {
        return this.memoryProfilerIncludedPackageNames;
    }

    public void setDefaultConnectionManagerProperties(String props) throws XUException {
        Map<String, String> map = PropertiesConverter.toMap(props);
        this.logger.info("XU.INFO.8001", new Object[]{"defaultConnectionManagerProperties", map});
        ConnectionPoolConfig cfg = this.getXUConfig().getConnectionPoolConfig();
        cfg.setProperties(map);
        if (this.connManager != null) {
            this.connManager.setProperties(map);
        }
        this.sendPropertyChanged("defaultConnectionManagerProperties");
    }

    public String getDefaultConnectionManagerProperties() throws XUException {
        return PropertiesConverter.toString(this.getXUConfig().getConnectionPoolConfig().toMap());
    }

    public IlrXUEventDispatcher getEventDispatcher() {
        return this.xuEventDispatcher;
    }

    public ContextFactory getContextFactory() {
        return this.contextFactory;
    }

    public IlrConnectionIdGenerator getConnectionIdGenerator() {
        return this.identifierGenerator;
    }

    public synchronized IlrRulesetUsageInformationMonitorImpl getRulesetUsageMonitor() throws XUException {
        if (this.rulesetUsageMonitor == null && this.isRulesetUsageMonitorEnabled().booleanValue()) {
            this.rulesetUsageMonitor = new IlrRulesetUsageInformationMonitorImpl(this.getLogHandler());
        }
        return this.rulesetUsageMonitor;
    }

    public void setLogWriter(PrintWriter writer) {
        this.logger.finest("ManagedConnectionFactory.setLogWriter", new Object[]{this, writer});
        this.logger.setLogWriter(writer);
        this.isFinestLoggable = this.logger.isLoggable(Level.FINEST);
    }

    public PrintWriter getLogWriter() {
        return this.logger.getLogWriter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlrXUConnectionFactory createConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        String string = this.connectionFactoryLock;
        synchronized (string) {
            WorkManager workManager = this.resourceAdapter != null ? this.resourceAdapter.getWorkManager() : null;
            this.logFinest(".createConnectionFactory(): connectionManager=" + connectionManager + " connectionFactory=" + this.connectionFactory + " pluginManager.isStarted=" + this.pluginManager.isStarted() + " resourceAdapter=" + this.resourceAdapter + " workManager=" + workManager, null);
            if (this.connectionFactory == null) {
                this.connectionFactory = this.instantiateConnectionFactory(connectionManager);
                this.pluginManager.setConnectionFactory(this.connectionFactory);
                this.pluginManager.setXUConfig(new XUConfigImpl(this));
                try {
                    this.pluginManager.setRulesetUsageMonitor(this.getRulesetUsageMonitor());
                }
                catch (XUException e) {
                    this.logger.severe(XUMessageCode.ERROR_CANNOT_USE_RULESET_USAGE_MONITOR, e, null, null);
                }
                if (this.resourceAdapter != null && workManager != null && !this.pluginManager.isStarted()) {
                    this.pluginManager.resourceAdapterStarted(this.resourceAdapter);
                }
            }
            return this.connectionFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlrXUConnectionFactory createConnectionFactory() throws ResourceException {
        String string = this.connectionFactoryLock;
        synchronized (string) {
            this.connManager = new XUConnectionManager(this.getResourceAdapter().getWorkManager(), this.logger);
            try {
                this.connManager.setProperties(this.getXUConfig().getConnectionPoolConfig().toMap());
            }
            catch (XUException e) {
                throw new ResourceException((Throwable)e);
            }
            return this.createConnectionFactory(this.connManager);
        }
    }

    protected IlrXUConnectionFactory instantiateConnectionFactory(ConnectionManager connectionManager) throws ResourceException {
        return new IlrXUConnectionFactory(this, connectionManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlrXUConnectionFactory getConnectionFactory() {
        String string = this.connectionFactoryLock;
        synchronized (string) {
            return this.connectionFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo rq) throws ResourceException {
        IlrManagedXUConnection conn;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("ManagedConnectionFactory.createManagedConnection", rq);
        }
        if (rq == null) {
            conn = this.createManagedConnection(null);
        } else if (rq instanceof IlrXUConnectionRequestInfo) {
            conn = this.createManagedConnection((IlrXUConnectionRequestInfo)rq);
        } else {
            throw new LocalizedNotSupportedException("XU.ERROR.10002", new String[]{rq.toString()});
        }
        WeakList<IlrManagedXUConnection> weakList = this.managedConnections;
        synchronized (weakList) {
            this.managedConnections.add(conn);
            this.managedConnections.removeNullTargetReferences();
        }
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("ManagedConnectionFactory.managedConnectionCreated ", conn);
        }
        return conn;
    }

    protected final IlrManagedXUConnection createManagedConnection(IlrXUConnectionRequestInfo rq) {
        IlrConnectionId id = this.spiConnectionIdGenerator.nextConnectionId();
        IlrManagedXUConnection conn = rq == null ? new IlrManagedXUConnection(id, -1, null, null, null, this, this.logger) : new IlrManagedXUConnection(id, rq.getType(), rq.getRulesetPath(), rq.getXOMClassLoader(), rq.getDataConnectorFactory(), this, this.logger);
        return conn;
    }

    public int hashCode() {
        return this.getXUConfig().hashCode();
    }

    private void logFinest(String msg, Object[] params) {
        this.logger.finest(this.getClass().getName() + msg, params);
    }

    public ManagedConnection matchManagedConnections(Set connSet, Subject subject, ConnectionRequestInfo connRqInfo) throws ResourceException {
        if (this.isFinestLoggable) {
            this.logFinest(".matchManagedConnections", new Object[]{this, connSet, subject, connRqInfo});
            this.logFinest(".matchManagedConnections set size=" + connSet.size(), null);
        }
        for (IlrManagedXUConnection conn : connSet) {
            if (!conn.match(connRqInfo)) continue;
            if (this.isFinestLoggable) {
                this.logFinest(".reuseManagedConnection", new Object[]{this, conn});
            }
            return conn;
        }
        if (this.isFinestLoggable) {
            this.logFinest(".matchManagedConnections noReusableManagedConnection", null);
        }
        return null;
    }

    public final boolean equals(Object object) {
        if (object instanceof IlrManagedXUConnectionFactory) {
            return this.getXUConfig().equals(((IlrManagedXUConnectionFactory)object).getXUConfig());
        }
        return false;
    }

    final void addConnection(IlrXUConnection connection) {
        if (connection.getSpec().isReconnectSupportEnabled()) {
            this.connections.add(connection);
        }
    }

    public IlrXUConnection getConnection(Serializable connectionId) throws ResourceException {
        IlrXUConnection conn = this.connections.get(connectionId);
        if (conn != null && conn.getState() == 1) {
            return conn;
        }
        throw new LocalizedResourceException("XU.ERROR.10040", new Object[]{connectionId.toString()}, null);
    }

    public synchronized Persistence getPersistence(boolean create) throws XUException {
        if (this.persistence == null && create) {
            this.persistence = this.createPersistence();
        }
        return this.persistence;
    }

    private Persistence createPersistence() throws XUException {
        String type = this.getPersistenceType();
        this.logger.finest("Creating persistence: ", type);
        try {
            Persistence persistence;
            if (type.equals("file")) {
                persistence = new IlrFilePersistenceImpl();
            } else if (type.equals("datasource")) {
                persistence = new IlrDatasourcePersistenceImpl();
            } else if (type.equals("jdbc")) {
                persistence = new IlrJDBCPersistenceImpl();
            } else {
                Class<?> clazz = Class.forName(type);
                persistence = (Persistence)clazz.newInstance();
            }
            persistence.setLogger(this.logger.getLogger());
            persistence.setProperties(this.retrievePersistenceConfig());
            persistence.setEventDispatcher(this.xuEventDispatcher);
            persistence.setProfiling(this.profiling);
            return persistence;
        }
        catch (Exception e) {
            throw new XUException("XU.ERROR.10017", null, (Throwable)e);
        }
    }

    protected final IlrRulesetProvider createRulesetProvider() throws XUException {
        this.logger.finest("Creates ruleset provider with WorkManager=" + this.getWorkManager());
        XUConfig cfg = this.getXUConfig();
        IlrRulesetProvider provider = new IlrRulesetProvider(this.logger, this.xuEventDispatcher, this.profiling, PropertiesConverter.toMap(this.getRulesetFactoryProperties()), PropertiesConverter.toMap(this.getRulesetCacheProperties()), cfg.getCompiledArchivesCacheProperties(), this.getRulesetUsageMonitor(), this.getWorkManager());
        provider.setPeriodicWorkManager(this.getPeriodicWorkManager());
        return provider;
    }

    private PeriodicWorkManager getPeriodicWorkManager() {
        if (this.resourceAdapter == null) {
            return new PeriodicWorkManager(null);
        }
        return this.resourceAdapter.getPeriodicWorkManager();
    }

    private WorkManager getWorkManager() {
        if (this.resourceAdapter == null) {
            return new WorkManagerImpl(null);
        }
        return this.resourceAdapter.getWorkManager();
    }

    public final synchronized IlrRulesetProvider getRulesetProvider() throws XUException {
        if (this.rulesetProvider == null) {
            this.rulesetProvider = this.createRulesetProvider();
        }
        return this.rulesetProvider;
    }

    public final synchronized XUConfig getXUConfig() {
        if (this.config == null) {
            this.config = new SPIXUConfigImpl(this);
        }
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XUInfoImpl getXUDump() throws XUException {
        WeakList<IlrManagedXUConnection> conns;
        XUInfoImpl dump = new XUInfoImpl(this.logger);
        dump.setDate(new Date());
        WeakList<IlrManagedXUConnection> weakList = conns = this.managedConnections;
        synchronized (weakList) {
            Iterator i$ = conns.iterator();
            while (i$.hasNext()) {
                IlrManagedXUConnection conn;
                IlrManagedXUConnection ilrManagedXUConnection = conn = (IlrManagedXUConnection)i$.next();
                synchronized (ilrManagedXUConnection) {
                    dump.addSPIConnection(conn.getId(), conn.rulesetPath, conn.getType(), conn.getState(), conn.freeEngineManagers, conn.connectionContexts, conn.toString());
                }
            }
        }
        this.getRulesetProvider().dump(dump);
        this.dump(dump);
        IlrXUEventDispatcher dispatcher = this.getEventDispatcher();
        if (dispatcher != null) {
            dispatcher.dump(dump);
        }
        return dump;
    }

    public void dump(XUInfoImpl dump) throws XUException {
        Properties props = new Properties();
        props.setProperty("xuDumpSchedulerEnabled", this.isXuDumpSchedulerEnabled().toString());
        props.setProperty("xuDumpSchedulerInterval", this.getXuDumpSchedulerInterval().toString());
        props.setProperty("rulesetUsageMonitorEnabled", this.isRulesetUsageMonitorEnabled().toString());
        if (this.getRulesetFactoryProperties() != null) {
            props.setProperty("rulesetFactoryProperties", this.getRulesetFactoryProperties());
        }
        if (this.getRulesetCacheProperties() != null) {
            props.setProperty("rulesetCacheProperties", this.getRulesetCacheProperties());
        }
        props.setProperty("concurrentOpenClose", this.isConcurrentOpenClose().toString());
        props.setProperty("asynchronousRulesetParsing", this.isAsynchronousRulesetParsing().toString());
        props.setProperty("jdkLoggingEnabled", this.jdkLoggingEnabled.toString());
        props.setProperty("persistenceProperties", this.getPersistenceProperties());
        props.setProperty("persistenceType", this.getPersistenceType());
        props.setProperty("traceLevel", this.getTraceLevel());
        props.setProperty("traceAutoFlush", this.getTraceAutoFlush().toString());
        props.setProperty("profilingEnabled", this.getProfilingEnabled().toString());
        props.setProperty("plugins", this.getPlugins());
        if (this.getDuplicateConnectionEventListenerEnabled() != null) {
            props.setProperty("duplicateConnectionEventListenerEnabled", this.getDuplicateConnectionEventListenerEnabled().toString());
        }
        props.setProperty("defaultConnectionManagerProperties", this.getDefaultConnectionManagerProperties());
        dump.setSPIFactoryProperties(props);
        this.connections.dump(dump);
        try {
            this.getPersistence(true).dump(dump);
        }
        catch (XUException e) {
            this.logger.severe("XU.ERROR.10601", e, null, null);
        }
        IlrMemoryProfiler profiler = IlrMemoryInstrumentation.getMemoryProfiler();
        if (profiler != null) {
            try {
                IlrXMLWriter xmlWriter = new IlrXMLWriter();
                StringWriter swriter = new StringWriter();
                xmlWriter.write(profiler.getObjectInfo(this), (Writer)swriter);
                dump.setMemoryDump(swriter.getBuffer().toString());
            }
            catch (Exception e) {
                this.logger.severe("XU.ERROR.10601", e, null, null);
            }
        } else {
            this.logger.finest("Memory profiler not enabled");
        }
        if (this.rulesetUsageMonitor != null) {
            this.rulesetUsageMonitor.dump(dump);
        }
    }

    public void sendPropertyChanged(String propertyName) {
        IlrConnectorEvent event = new IlrConnectorEvent(0, this);
        event.setPropertyName(propertyName);
        this.xuEventDispatcher.connectorEventRaised(event);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.xuListeners = (List)in.readObject();
        in.defaultReadObject();
        this.pluginManager = new IlrPluginManager(this.logger, this.xuEventDispatcher);
        this.pluginManager.setConnectionFactory(this.connectionFactory);
        if (this.persistence != null) {
            this.persistence.setLogger(this.logger.getLogger());
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        ArrayList<XUListener> serializableListeners = new ArrayList<XUListener>();
        for (XUListener l : this.xuListeners) {
            if (!(l instanceof Serializable)) continue;
            serializableListeners.add(l);
        }
        stream.writeObject(serializableListeners);
        stream.defaultWriteObject();
    }

    public XUResourceAdapter getResourceAdapter() {
        return this.resourceAdapter;
    }

    public void setResourceAdapter(ResourceAdapter resourceAdapter) {
        this.logFinest(".setResourceAdapter(): resource adapter=" + resourceAdapter, null);
        this.resourceAdapter = (XUResourceAdapter)resourceAdapter;
        this.resourceAdapterEventDispatcher = ((XUResourceAdapter)resourceAdapter).getEventDispatcher();
        this.resourceAdapter.getEventDispatcher().addListener(this.xuEventDispatcher, 1L);
        ((XUResourceAdapter)resourceAdapter).addListener(this.pluginManager);
        ((XUResourceAdapter)resourceAdapter).addListener(this);
    }

    public Set getInvalidConnections(Set connectionSet) throws ResourceException {
        this.logger.finest("IlrManagedXUConnectionFactory.getInvalidConnections");
        return Collections.EMPTY_SET;
    }

    public List<IlrXUDiagnosticResult> diagnostic() throws ResourceException {
        ArrayList<IlrXUDiagnosticResult> results = new ArrayList<IlrXUDiagnosticResult>();
        try {
            Class.forName("org.objectweb.asm.commons.JSRInlinerAdapter");
            this.logger.finest("Diagnostic ASM: ok");
        }
        catch (Throwable e) {
            results.add(new IlrXUDiagnosticResultImpl("asm", 2, e));
            this.logger.finest("Diagnostic ASM: failed, " + e.getMessage());
        }
        try {
            this.logger.finest("Diagnostic Profiler");
            String cname = "ilog.rules.res.mprofiler.IlrMemoryInstrumentation";
            Class<?> c = Class.forName(cname);
            this.logger.finest("Find IlrMemoryInstrumentation in " + c.getClassLoader() + " " + c);
            ClassLoader cl = null;
            try {
                cl = ClassLoader.getSystemClassLoader();
                c = cl.loadClass(cname);
                this.logger.finest("Find IlrMemoryInstrumentation in " + c.getClassLoader() + " " + c);
            }
            catch (Throwable e) {
                this.logger.finest("Cannot find profiler in " + cl);
            }
        }
        catch (Throwable e) {
            results.add(new IlrXUDiagnosticResultImpl("profiler", 2, e));
            this.logger.finest("Diagnostic Profiler: failed, " + e.getMessage());
        }
        return results;
    }

    public DocumentBuilderPool getCREDocumentBuilderPool() throws XUException {
        return this.getBOMPools().getCREDocumentBuilderPool(this.logger);
    }

    public TransformerPool getCRETransformerPool() throws XUException {
        return this.getBOMPools().getCRETransformerPool(this.logger);
    }

    private synchronized BOMConversionPools getBOMPools() throws XUException {
        if (this.bomPools == null) {
            this.bomPools = new BOMConversionPools(this.getXUConfig());
        }
        return this.bomPools;
    }

    public void notifyRulesetArchiveChanged(String canonicalRulesetPath, IlrXUContext ctx) {
        this.logger.fine("XU.FINE.5053", new Object[]{canonicalRulesetPath}, ctx);
        this.getResourceAdapter().notifyRulesetArchiveChanged(canonicalRulesetPath, ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void notifyConnectionOpened(IlrXUConnection conn) {
        ConnectionEventImpl evt = new ConnectionEventImpl(conn.getId(), conn.getSpec().getUserData());
        List<XUListener> list = this.xuListeners;
        synchronized (list) {
            for (XUListener l : this.xuListeners) {
                l.connectionOpened(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void notifyConnectionClosed(IlrXUConnection conn) {
        ConnectionEventImpl evt = new ConnectionEventImpl(conn.getId(), conn.getSpec().getUserData());
        List<XUListener> list = this.xuListeners;
        synchronized (list) {
            for (XUListener l : this.xuListeners) {
                l.connectionClosed(evt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addXUListener(XUListener l) {
        List<XUListener> list = this.xuListeners;
        synchronized (list) {
            this.xuListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changePerformed(IlrRulesetArchiveEvent event) {
        String path = event.getCanonicalRulesetPath();
        try {
            RulesetArchiveEventImpl evt = new RulesetArchiveEventImpl(IlrPath.parsePath(path));
            List<XUListener> list = this.xuListeners;
            synchronized (list) {
                for (XUListener l : this.xuListeners) {
                    l.rulesetArchiveChanged(evt);
                }
            }
        }
        catch (IlrFormatException e) {
            this.logger.severe("XU.ERROR.10048", e, new Object[]{path}, null);
        }
    }

    public final void release() {
    }

    @Override
    public void resourceAdapterStarted(XUResourceAdapter adapter) {
        this.resourceAdapter = adapter;
        try {
            this.getInfoScheduler().setWorkManager(adapter.getWorkManager());
        }
        catch (WorkException e) {
            this.logger.severe("XU.ERROR.11000", e, null, null);
        }
    }

    @Override
    public final void resourceAdapterStopped(XUResourceAdapter adapter) {
    }
}

