/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.res.xu.spi;

import com.ibm.rules.res.xu.engine.internal.EngineListener;
import com.ibm.rules.res.xu.engine.internal.RuleEventImpl;
import com.ibm.rules.res.xu.engine.internal.TaskEventImpl;
import com.ibm.rules.res.xu.event.RuleEvent;
import com.ibm.rules.res.xu.event.TaskEvent;
import ilog.rules.engine.IlrContext;
import ilog.rules.engine.IlrFunction;
import ilog.rules.engine.IlrRule;
import ilog.rules.engine.IlrRuleInstance;
import ilog.rules.engine.IlrTask;
import ilog.rules.engine.IlrTool;
import ilog.rules.res.model.IlrPath;
import ilog.rules.res.xu.cci.IlrConnectionContext;
import ilog.rules.res.xu.cci.IlrConnectionId;
import ilog.rules.res.xu.event.internal.IlrRuleEngineEventImpl;
import ilog.rules.res.xu.event.internal.IlrXUEventDispatcher;
import ilog.rules.res.xu.spi.IlrManagedConnectionContext;
import java.util.Vector;

public final class IlrRuleEngineEventHandler
implements IlrTool {
    private final IlrXUEventDispatcher eventDispatcher;
    private final IlrContext context;
    private final IlrPath canonicalRulesetPath;
    private int toolId = -1;
    private final IlrManagedConnectionContext xuContext;
    private final EngineListener engineListener;

    public IlrRuleEngineEventHandler(IlrContext context, IlrPath canonicalRulesetPath, IlrXUEventDispatcher eventDispatcher, IlrManagedConnectionContext xuContext, EngineListener engineListener) {
        this.context = context;
        this.canonicalRulesetPath = canonicalRulesetPath;
        this.eventDispatcher = eventDispatcher;
        this.xuContext = xuContext;
        this.engineListener = engineListener;
    }

    public void setToolId(int toolId) {
        this.toolId = toolId;
    }

    public int getToolId() {
        return this.toolId;
    }

    public void notifyConnect() {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(22, this.context, new Object[0], this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
    }

    public void notifyDisconnect() {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(1, this.context, new Object[0], this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
    }

    public void notifyAddRule(IlrRule rule) {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(2, this.context, new Object[]{rule}, this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
    }

    public void notifyRemoveRule(IlrRule rule) {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(3, this.context, new Object[]{rule}, this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
    }

    public void notifySetInitialRule(Vector initialStatements) {
    }

    public void notifyDefineFunction(IlrFunction function) {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(4, this.context, new Object[]{function}, this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
    }

    public void notifyActivateRule(IlrRule rule) {
    }

    public void notifyDeactivateRule(IlrRule rule) {
    }

    public void notifyAssertObject(Object object) {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(5, this.context, new Object[]{object}, this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
    }

    public void notifyAssertLogical(Object object) {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(6, this.context, new Object[]{object}, this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
    }

    public void notifyRetractObject(Object object) {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(7, this.context, new Object[]{object}, this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
    }

    public void notifyUpdateObject(Object object) {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(8, this.context, new Object[]{object}, this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
    }

    public void notifyRetractAll() {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(9, this.context, new Object[0], this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
    }

    public void notifyReset() {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(10, this.context, new Object[0], this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
    }

    public void notifyAddInstance(IlrRuleInstance instance, IlrRuleInstance previous) {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(11, this.context, new Object[]{instance, previous}, this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
    }

    public void notifyRemoveInstance(IlrRuleInstance instance) {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(12, this.context, new Object[]{instance}, this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
    }

    public void notifyRemoveAllInstances() {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(13, this.context, new Object[0], this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
    }

    public void notifyBeginInstance(IlrRuleInstance instance) {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(14, this.context, new Object[]{instance}, this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
        RuleEvent evt = this.createRuleEvent(instance.getRule(), instance.getPriority(), instance.getObjects());
        this.engineListener.ruleExecutionStarted(evt);
    }

    public void notifyEndInstance(IlrRuleInstance instance) {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(15, this.context, new Object[]{instance}, this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
        RuleEvent evt = this.createRuleEvent(instance.getRule(), instance.getPriority(), instance.getObjects());
        this.engineListener.ruleExecutionCompleted(evt);
    }

    public void notifyBeginTask(IlrTask task) {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(16, this.context, new Object[]{task}, this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
        TaskEvent evt = this.createTaskEvent(task);
        this.engineListener.taskStarted(evt);
    }

    protected TaskEvent createTaskEvent(IlrTask task) {
        return new TaskEventImpl(this.canonicalRulesetPath, this.getConnectionId(), this.getUserData(), task.getName());
    }

    public void notifyEndTask(IlrTask task) {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(17, this.context, new Object[]{task}, this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
        TaskEvent evt = this.createTaskEvent(task);
        this.engineListener.taskCompleted(evt);
    }

    public void notifyStartRuleFlow(IlrTask task) {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(18, this.context, new Object[]{task}, this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
    }

    public void notifyEndRuleFlow(IlrTask task) {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(19, this.context, new Object[]{task}, this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
    }

    public void notifyBeginSequentialInstance(IlrRule rule, Object[] objs, int priority) {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(20, this.context, new Object[]{rule, objs, new Integer(priority)}, this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
        RuleEvent evt = this.createRuleEvent(rule, priority, objs);
        this.engineListener.ruleExecutionStarted(evt);
    }

    public void notifyEndSequentialInstance(IlrRule rule, Object[] objs, int priority) {
        IlrRuleEngineEventImpl event = new IlrRuleEngineEventImpl(21, this.context, new Object[]{rule, objs, new Integer(priority)}, this.canonicalRulesetPath.toString(), this.xuContext);
        this.eventDispatcher.ruleEngineEventRaised(event);
        RuleEvent evt = this.createRuleEvent(rule, priority, objs);
        this.engineListener.ruleExecutionCompleted(evt);
    }

    private RuleEvent createRuleEvent(IlrRule rule, int priority, Object[] objs) {
        return new RuleEventImpl(this.canonicalRulesetPath, this.getConnectionId(), this.getUserData(), rule.getName(), priority, objs);
    }

    private IlrConnectionId getConnectionId() {
        IlrConnectionContext connectionContext = this.xuContext.getConnectionContext();
        if (connectionContext != null) {
            return connectionContext.getConnectionInformation().getConnectionId();
        }
        return null;
    }

    private Object getUserData() {
        IlrConnectionContext connectionContext = this.xuContext.getConnectionContext();
        if (connectionContext != null) {
            return connectionContext.getConnectionInformation().getConnectionSpec().getUserData();
        }
        return null;
    }
}

