/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import ilog.rules.util.IlrAuthorMap;
import ilog.rules.util.IlrAuthorWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class IlrCodePrintWriter
extends PrintWriter {
    private int indentSize = 4;
    private int indentLevel = 0;
    private boolean needIndent = true;
    private IlrAuthorWriter authorWriter = null;

    public IlrCodePrintWriter(Writer writer) {
        super(writer);
    }

    public IlrCodePrintWriter(Writer writer, int indentSize) {
        super(writer);
        this.indentSize = indentSize;
    }

    public IlrCodePrintWriter(IlrAuthorWriter writer) {
        this((Writer)writer);
        this.authorWriter = writer;
    }

    public IlrCodePrintWriter(IlrAuthorWriter writer, int indentSize) {
        this((Writer)writer, indentSize);
        this.authorWriter = writer;
    }

    private void indent() {
        for (int i = 0; i < this.indentLevel; ++i) {
            this.write(32);
        }
    }

    private void indentIfNeeded() {
        if (this.needIndent) {
            for (int i = 0; i < this.indentLevel; ++i) {
                this.write(32);
            }
        }
        this.needIndent = false;
    }

    public void addIndent(int steps) {
        this.indentLevel += steps * this.indentSize;
    }

    @Override
    public void print(boolean x) {
        this.indentIfNeeded();
        super.print(x);
    }

    @Override
    public void print(char x) {
        this.indentIfNeeded();
        super.print(x);
    }

    @Override
    public void print(int x) {
        this.indentIfNeeded();
        super.print(x);
    }

    @Override
    public void print(long x) {
        this.indentIfNeeded();
        super.print(x);
    }

    @Override
    public void print(float x) {
        this.indentIfNeeded();
        super.print(x);
    }

    @Override
    public void print(double x) {
        this.indentIfNeeded();
        super.print(x);
    }

    @Override
    public void print(char[] x) {
        this.indentIfNeeded();
        super.print(x);
    }

    @Override
    public void print(String x) {
        this.indentIfNeeded();
        super.print(x);
    }

    @Override
    public void print(Object x) {
        this.indentIfNeeded();
        super.print(x);
    }

    @Override
    public void println() {
        this.indentIfNeeded();
        super.println();
        this.needIndent = true;
    }

    @Override
    public void println(boolean x) {
        this.indentIfNeeded();
        super.println(x);
        this.needIndent = true;
    }

    @Override
    public void println(char x) {
        this.indentIfNeeded();
        super.println(x);
        this.needIndent = true;
    }

    @Override
    public void println(int x) {
        this.indentIfNeeded();
        super.println(x);
        this.needIndent = true;
    }

    @Override
    public void println(long x) {
        this.indentIfNeeded();
        super.println(x);
        this.needIndent = true;
    }

    @Override
    public void println(float x) {
        this.indentIfNeeded();
        super.println(x);
        this.needIndent = true;
    }

    @Override
    public void println(double x) {
        this.indentIfNeeded();
        super.println(x);
        this.needIndent = true;
    }

    @Override
    public void println(char[] x) {
        this.indentIfNeeded();
        super.println(x);
        this.needIndent = true;
    }

    @Override
    public void println(String x) {
        this.indentIfNeeded();
        super.println(x);
        this.needIndent = true;
    }

    @Override
    public void println(Object x) {
        this.indentIfNeeded();
        super.println(x);
        this.needIndent = true;
    }

    public void openBlock() {
        this.println('{');
        this.addIndent(1);
    }

    public void closeBlock(boolean semiColon) {
        this.addIndent(-1);
        this.print('}');
        if (semiColon) {
            this.print(';');
        }
        this.println();
    }

    public void endline() {
        this.println(";");
    }

    public void reset() {
        if (this.authorWriter == null) {
            throw new IllegalStateException("No Author Writer");
        }
        this.authorWriter.reset();
    }

    public void resetAuthor() {
        this.authorWriter.resetAuthor();
    }

    public void setAuthor(Object author) {
        if (author == null) {
            this.resetAuthor();
        } else if (this.authorWriter != null) {
            this.authorWriter.setAuthor(author);
        } else {
            throw new IllegalStateException("No Author Writer");
        }
    }

    public IlrAuthorMap getAuthorMap() {
        if (this.authorWriter != null) {
            return this.authorWriter.getAuthorMap();
        }
        throw new IllegalStateException("No Author Writer");
    }
}

