/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import ilog.rules.util.IlrURI;
import ilog.rules.util.IlrURIUtils;
import ilog.rules.util.prefs.IlrMessages;

public class IlrHttp
implements IlrURI {
    public static final String PROTOCOL = "http";
    public static final String DEFAULT_HTTP_URL = "http://";
    public static final String HTTP_SEPARATOR = "/";
    private String pathname;
    private String rootId;

    public IlrHttp(String pathname) {
        this(null, pathname);
    }

    public IlrHttp(String rootId, IlrHttp http) {
        this(rootId, http.getPath());
    }

    public IlrHttp(String rootId, String pathname) {
        this.pathname = pathname;
        this.setRootId(rootId);
    }

    protected Object clone() throws CloneNotSupportedException {
        return new IlrHttp(this.rootId, this.pathname);
    }

    @Override
    public void setRootId(String rootId) {
        this.rootId = rootId;
    }

    @Override
    public String getRootId() {
        return this.rootId;
    }

    @Override
    public String getType() {
        return PROTOCOL;
    }

    @Override
    public String getName() {
        int index = this.pathname.lastIndexOf(HTTP_SEPARATOR);
        if (index != -1) {
            return this.pathname.substring(index + 1);
        }
        return this.pathname;
    }

    @Override
    public String getPath() {
        return this.pathname;
    }

    @Override
    public String getDisplayRootId() {
        return IlrMessages.getMessage(this.rootId);
    }

    @Override
    public String getDisplayPath() {
        return IlrURIUtils.makeRelativeDisplayPathName(this.pathname, this.rootId);
    }

    @Override
    public long lastModified() {
        return 0L;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public boolean isFiltered() {
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IlrHttp) {
            IlrHttp http = (IlrHttp)obj;
            if (this.rootId != null) {
                return this.rootId.equals(http.getRootId()) && this.pathname.equals(http.getPath());
            }
            return this.pathname.equals(http.getPath());
        }
        return false;
    }

    public String toString() {
        if (this.rootId != null) {
            return IlrURIUtils.makeRelativePathName(this.getPath(), this.rootId);
        }
        return this.getPath();
    }
}

