/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import ilog.rules.data.IlrError;
import ilog.rules.util.prefs.IlrMessages;

public class IlrLocalizedError
extends Exception
implements IlrError {
    private String prefixedMessage;
    private Object[] args;

    public IlrLocalizedError(String prefix, String msgId) {
        super(msgId);
        this.prefixedMessage = prefix + "." + msgId;
    }

    public IlrLocalizedError(String prefix, String msgId, Object arg) {
        this(prefix, msgId);
        this.args = IlrLocalizedError.buildArguments(arg);
    }

    public IlrLocalizedError(String prefix, String msgId, Object arg1, Object arg2) {
        this(prefix, msgId);
        this.args = IlrLocalizedError.buildArguments(arg1, arg2);
    }

    public IlrLocalizedError(String prefix, String msgId, Object[] args) {
        this(prefix, msgId);
        this.args = args;
    }

    public String getMessageId() {
        return super.getMessage();
    }

    public Object[] getArguments() {
        return this.args;
    }

    @Override
    public String getMessage() {
        return IlrMessages.getMessage(null, this.prefixedMessage, this.getMessageId(), this.args);
    }

    @Override
    public boolean isWarning() {
        return false;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }

    private static Object[] buildArguments(Object arg) {
        Object[] args = new Object[]{arg};
        return args;
    }

    private static Object[] buildArguments(Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return args;
    }
}

