/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

public class IlrQueue {
    private QueueItem first = null;
    private QueueItem last = null;
    private QueueItem old = null;

    public void push(Object obj) {
        QueueItem item = this.getNewItem();
        item.value = obj;
        if (this.last == null) {
            this.last = item;
            this.first = item;
        } else {
            this.last.next = item;
            this.last = item;
        }
    }

    public Object pop() {
        if (this.first == null) {
            throw new RuntimeException("Queue is empty");
        }
        Object obj = this.first.value;
        QueueItem item = this.first;
        this.first = item.next;
        if (this.first == null) {
            this.last = null;
        }
        this.releaseItem(item);
        return obj;
    }

    public Object peek() {
        if (this.first == null) {
            throw new RuntimeException("Queue is empty");
        }
        Object obj = this.first.value;
        return obj;
    }

    public boolean isEmpty() {
        return this.first == null;
    }

    public void reset() {
        this.first = null;
        this.last = null;
    }

    private QueueItem getNewItem() {
        QueueItem item;
        if (this.old != null) {
            item = this.old;
            this.old = item.next;
            item.next = null;
            item.value = null;
        } else {
            item = new QueueItem();
        }
        return item;
    }

    private void releaseItem(QueueItem item) {
        item.next = this.old;
        this.old = item;
    }

    private class QueueItem {
        Object value = null;
        QueueItem next = null;

        QueueItem() {
        }
    }
}

