/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util;

import ilog.rules.util.prefs.IlrMessages;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class IlrUtils {
    public static Object buildInstance(String className, Object[] args) throws RuntimeException {
        Object object = null;
        try {
            Class<?> clazz = Class.forName(className);
            if (args != null && args.length > 0) {
                Constructor constructor = IlrUtils.getConstructor(clazz, args);
                if (constructor == null) {
                    StringBuffer buf = new StringBuffer("(");
                    buf.append(args[0].getClass().getName());
                    for (int i = 1; i < args.length; ++i) {
                        buf.append(args[i].getClass().getName()).append(", ");
                    }
                    buf.append(")");
                    String msg = IlrMessages.getMessage("ui.error.NoConstructorWithArgs", new Object[]{className, buf.toString()});
                    throw new RuntimeException(msg);
                }
                object = constructor.newInstance(args);
            } else {
                object = clazz.newInstance();
            }
        }
        catch (InvocationTargetException e) {
            String msg = IlrMessages.getMessage("ui.error.CannotInstantiate", new Object[]{className, e.getTargetException().getMessage()});
            throw new RuntimeException(msg);
        }
        catch (Exception ex) {
            String msg = IlrMessages.getMessage("ui.error.CannotInstantiate", new Object[]{className, ex.getMessage()});
            throw new RuntimeException(msg);
        }
        return object;
    }

    public static Constructor getConstructor(Class clazz, Object[] args) {
        Constructor<?>[] consts = clazz.getConstructors();
        for (int i = 0; i < consts.length; ++i) {
            Class<?>[] types = consts[i].getParameterTypes();
            if (types.length != args.length) continue;
            boolean correct = true;
            for (int j = 0; j < args.length; ++j) {
                if (types[j].isAssignableFrom(args[j].getClass())) continue;
                correct = false;
                break;
            }
            if (!correct) continue;
            return consts[i];
        }
        return null;
    }

    public static String className(Object obj) {
        if (obj == null) {
            return "null";
        }
        String name = obj.getClass().getName();
        return name.substring(name.lastIndexOf(46) + 1);
    }

    public static Object[] add(Object[] src, Object object, int index) {
        if (src == null || src.length == 0) {
            return new Object[]{object};
        }
        Object[] newArray = new Object[src.length + 1];
        if (index > 0) {
            System.arraycopy(src, 0, newArray, 0, index);
        }
        newArray[index] = object;
        if (index < src.length) {
            System.arraycopy(src, index, newArray, index + 1, src.length - index);
        }
        return newArray;
    }

    public static Object[] add(Object[] src, Object object) {
        return IlrUtils.add(src, object, src == null ? 0 : src.length);
    }

    public static Object[] remove(Object[] src, int index) {
        if (src == null || src.length == 0 || index == -1) {
            return src;
        }
        Object[] newArray = new Object[src.length - 1];
        if (index > 0) {
            System.arraycopy(src, 0, newArray, 0, index);
        }
        if (index < src.length - 1) {
            System.arraycopy(src, index + 1, newArray, index, src.length - index - 1);
        }
        return newArray;
    }

    public static Object[] remove(Object[] src, Object object) {
        return IlrUtils.remove(src, IlrUtils.indexOf(src, object));
    }

    public static Object[] remove(Object[] array1, Object[] array2) {
        if (array1 == null) {
            return new Object[0];
        }
        if (array1 != null && array2 == null) {
            return array1;
        }
        Object[] result = IlrUtils.copy(array1);
        for (int i = 0; i < array2.length; ++i) {
            int index = IlrUtils.indexOf(result, array2[i]);
            if (index == -1) continue;
            result = IlrUtils.remove(result, array2[i]);
        }
        return result;
    }

    public static int indexOf(Object[] src, Object object) {
        if (src == null || src.length == 0 || object == null) {
            return -1;
        }
        for (int iObject = 0; iObject < src.length; ++iObject) {
            if (!object.equals(src[iObject])) continue;
            return iObject;
        }
        return -1;
    }

    public static Object[] setElementAt(Object[] src, Object object, int index) {
        if (src == null) {
            src = new Object[index + 1];
        }
        if (src.length > index) {
            src[index] = object;
            return src;
        }
        Object[] newArray = new Object[index + 1];
        if (src.length > 0) {
            System.arraycopy(src, 0, newArray, 0, src.length);
        }
        newArray[index] = object;
        return newArray;
    }

    public static Object[] copy(Object[] src) {
        if (src == null || src.length == 0) {
            return new Object[0];
        }
        Object[] newArray = new Object[src.length];
        System.arraycopy(src, 0, newArray, 0, src.length);
        return newArray;
    }

    public static Object[] merge(Object[] array1, Object[] array2) {
        if (array1 == null && array2 == null) {
            return new Object[0];
        }
        if (array1 != null && array2 == null) {
            return array1;
        }
        if (array1 == null && array2 != null) {
            return array2;
        }
        Object[] result = IlrUtils.copy(array1);
        for (int i = 0; i < array2.length; ++i) {
            int index = IlrUtils.indexOf(result, array2[i]);
            if (index != -1) continue;
            result = IlrUtils.add(result, array2[i]);
        }
        return result;
    }

    public static boolean equals(Object[] array1, Object[] array2) {
        if (array1 == null && array2 == null) {
            return true;
        }
        if (array1 != null && array2 == null) {
            return false;
        }
        if (array1 == null && array2 != null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (array1[i] != null && array2[i] == null) {
                return false;
            }
            if (array1[i] == null && array2[i] != null) {
                return false;
            }
            if (array1[i] == null && array2[i] == null || array1[i].equals(array2[i])) continue;
            return false;
        }
        return true;
    }

    public static List list(Object[] objects) {
        if (objects == null || objects.length == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> result = new ArrayList<Object>(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            result.add(objects[i]);
        }
        return result;
    }

    public static String[] patchString(Object[] objects) {
        if (objects == null) {
            return new String[0];
        }
        String[] result = new String[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            result[i] = objects[i].toString();
        }
        return result;
    }

    public static String toUpperCaseFirstLetter(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        if (str.length() == 1) {
            return str.toUpperCase();
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static String replaceAll(String src, String findex, String replacement) {
        String newString = new String(src);
        StringBuffer buffer = new StringBuffer(newString);
        int firstIndex = newString.indexOf(findex);
        int lengthOldString = findex.length();
        int replacementLength = replacement.length();
        while (firstIndex != -1) {
            buffer.delete(firstIndex, firstIndex + lengthOldString);
            buffer.insert(firstIndex, replacement);
            newString = buffer.toString();
            firstIndex = newString.indexOf(findex, firstIndex + replacementLength);
        }
        return newString;
    }
}

