/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.engine;

import ilog.rules.util.engine.IlrXmlRulesetArchiveTag;
import ilog.rules.util.engine.IlrXmlSignatureTag;
import ilog.rules.util.prefs.IlrMessages;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IlrXmlSignatureParser
implements IlrXmlSignatureTag,
IlrXmlRulesetArchiveTag {
    private Document createDocument(InputSource xmlArchive) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(xmlArchive);
    }

    private Node getElement(Node parentNode, String ns, String tag) throws InvalidXmlDocument {
        NodeList nl = parentNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 1 || !n.getNamespaceURI().equals(ns) || !n.getLocalName().equals(tag)) continue;
            return n;
        }
        String msg = IlrMessages.format("messages.RulesetSignature.7", ns + ':' + tag);
        throw new InvalidXmlDocument(msg);
    }

    private String getElementValue(Node parentNode, String ns, String tag) throws InvalidXmlDocument {
        Node n = this.getElement(parentNode, ns, tag);
        Node childValue = n.getFirstChild();
        return childValue == null ? null : childValue.getNodeValue();
    }

    private String getAttributeValue(Node element, String ns, String name) {
        NamedNodeMap attrsNode = element.getAttributes();
        Node n = attrsNode.getNamedItem(name);
        return n == null ? null : n.getNodeValue();
    }

    private NodeList getParameterNodesInArchive(Document doc) throws InvalidXmlDocument {
        Element root = doc.getDocumentElement();
        return root.getChildNodes();
    }

    public Parameter[] parseSignature(InputSource xmlArchive) throws SAXException, IOException, InvalidXmlDocument {
        try {
            Document doc = this.createDocument(xmlArchive);
            NodeList paramNodes = this.getParameterNodesInArchive(doc);
            ArrayList<Parameter> parameters = new ArrayList<Parameter>();
            for (int i = 0; i < paramNodes.getLength(); ++i) {
                Node paramNode = paramNodes.item(i);
                if (paramNode.getNodeType() != 1 || !paramNode.getLocalName().equals("parameter")) continue;
                Parameter p = new Parameter();
                parameters.add(p);
                p.name = this.getElementValue(paramNode, "http://www.ilog.com/products/xml/schemas/signature_2.0", "name");
                p.direction = this.getElementValue(paramNode, "http://www.ilog.com/products/xml/schemas/signature_2.0", "direction");
                Node typeNode = this.getElement(paramNode, "http://www.ilog.com/products/xml/schemas/signature_2.0", "type");
                p.bomType = this.getAttributeValue(typeNode, "http://www.ilog.com/products/xml/schemas/signature_2.0", "bom-type");
                p.xomType = this.getAttributeValue(typeNode, "http://www.ilog.com/products/xml/schemas/signature_2.0", "xom-type");
                p.kind = this.getAttributeValue(typeNode, "http://www.ilog.com/products/xml/schemas/signature_2.0", "kind");
                p.xmlElement = this.getAttributeValue(typeNode, "http://www.ilog.com/products/xml/schemas/signature_2.0", "xml-element");
                p.xmlType = this.getAttributeValue(typeNode, "http://www.ilog.com/products/xml/schemas/signature_2.0", "xml-type");
            }
            Parameter[] paramArray = new Parameter[parameters.size()];
            parameters.toArray(paramArray);
            return paramArray;
        }
        catch (ParserConfigurationException e) {
            String msg = IlrMessages.format("messages.RulesetSignature.8", "");
            throw new InvalidXmlDocument(msg);
        }
    }

    public static final class Parameter {
        public String name;
        public String xomType;
        public String bomType;
        public String direction;
        public String kind;
        public String xmlElement;
        public String xmlType;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Parameter parameter = (Parameter)o;
            if (!this.bomType.equals(parameter.bomType)) {
                return false;
            }
            if (!this.direction.equals(parameter.direction)) {
                return false;
            }
            if (!this.kind.equals(parameter.kind)) {
                return false;
            }
            if (!this.name.equals(parameter.name)) {
                return false;
            }
            if (this.xmlElement != null ? !this.xmlElement.equals(parameter.xmlElement) : parameter.xmlElement != null) {
                return false;
            }
            if (this.xmlType != null ? !this.xmlType.equals(parameter.xmlType) : parameter.xmlType != null) {
                return false;
            }
            return !(this.xomType != null ? !this.xomType.equals(parameter.xomType) : parameter.xomType != null);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.xomType != null ? this.xomType.hashCode() : 0);
            result = 31 * result + this.bomType.hashCode();
            result = 31 * result + this.direction.hashCode();
            result = 31 * result + this.kind.hashCode();
            result = 31 * result + (this.xmlElement != null ? this.xmlElement.hashCode() : 0);
            result = 31 * result + (this.xmlType != null ? this.xmlType.hashCode() : 0);
            return result;
        }
    }

    public final class InvalidXmlDocument
    extends Exception {
        InvalidXmlDocument(String str) {
            super(str);
        }
    }
}

