/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.issue;

import ilog.rules.util.issue.IlrFormattedMessage;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;

public class IlrDefaultFormattedMessage
extends IlrFormattedMessage {
    protected Object[] parameters;

    public IlrDefaultFormattedMessage(String baseName, String id, Object ... parameters) {
        super(baseName, id);
        this.parameters = parameters;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    @Override
    public String getMessage(Locale locale) {
        try {
            String resourceMessage = this.getResourceMessage(locale);
            return MessageFormat.format(resourceMessage, this.parameters);
        }
        catch (MissingResourceException e) {
            return this.id;
        }
    }

    @Override
    public String getMessage(Locale locale, ClassLoader loader) {
        try {
            String resourceMessage = this.getResourceMessage(locale, loader);
            return MessageFormat.format(resourceMessage, this.parameters);
        }
        catch (MissingResourceException e) {
            return this.id;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IlrDefaultFormattedMessage that = (IlrDefaultFormattedMessage)o;
        if (!this.baseName.equals(that.baseName)) {
            return false;
        }
        if (!this.id.equals(that.id)) {
            return false;
        }
        return Arrays.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        int result = this.baseName.hashCode();
        result = 31 * result + this.id.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameters);
        return result;
    }
}

