/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.prefs;

import ilog.rules.util.prefs.IlrPropertyBundle;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class IlrPropertyManager {
    private ClassLoader classLoader;
    private Vector prefixes = new Vector(2);
    private Vector suffixes = new Vector(2);
    private Logger logger;
    private Locale managerLocale;
    private IlrPropertyBundle defaultBundle;
    protected HashMap bundles;
    protected HashMap noBundles;
    protected HashMap dataCache;
    protected HashMap defaultBundles;
    private PropertyBundleIterator iterator;
    private int maxDepth;
    private boolean nostop;

    protected IlrPropertyManager() {
        this.resetBundles();
        this.maxDepth = 2;
        this.defaultBundles = new HashMap();
        this.defaultBundle = this.newBundle("");
        this.iterator = new PropertyBundleIterator(null, this.managerLocale);
    }

    protected synchronized void resetBundles() {
        this.bundles = new HashMap();
        this.noBundles = new HashMap();
        this.dataCache = new HashMap();
    }

    public synchronized String[] getPrefixes() {
        Object[] res = new String[this.prefixes.size()];
        this.prefixes.copyInto(res);
        return res;
    }

    public synchronized void setPrefixes(String[] prefixes) {
        this.prefixes.clear();
        if (prefixes != null) {
            for (int i = 0; i < prefixes.length; ++i) {
                this.prefixes.add(prefixes[i]);
            }
        }
        this.resetBundles();
    }

    public synchronized void insertPrefixAt(String prefix, int index) {
        this.prefixes.add(index, prefix);
        this.resetBundles();
    }

    public synchronized void addPrefix(String prefix) {
        this.prefixes.add(prefix);
        this.resetBundles();
    }

    public synchronized void removePrefixAt(int index) {
        this.prefixes.removeElementAt(index);
        this.resetBundles();
    }

    public synchronized String[] getSuffixes() {
        Object[] res = new String[this.suffixes.size()];
        this.suffixes.copyInto(res);
        return res;
    }

    public synchronized void setSuffixes(String[] suffixes) {
        this.suffixes.clear();
        if (suffixes != null) {
            this.suffixes.addAll(Arrays.asList(suffixes));
        }
        this.resetBundles();
    }

    public synchronized void insertSuffixAt(String suffix, int index) {
        this.suffixes.add(index, suffix);
        this.resetBundles();
    }

    public synchronized void addSuffix(String suffix) {
        this.suffixes.add(suffix);
        this.resetBundles();
    }

    public synchronized void removeSuffixAt(int index) {
        this.suffixes.remove(index);
        this.resetBundles();
    }

    public synchronized int getMaximumDepth() {
        return this.maxDepth;
    }

    public synchronized void setMaximumDepth(int maxDepth) {
        this.maxDepth = maxDepth;
        this.resetBundles();
    }

    void setNoStopSearch(boolean nostop) {
        this.nostop = nostop;
    }

    public IlrPropertyBundle getDefaultBundle() {
        return this.defaultBundle;
    }

    public synchronized Object getData(String key) {
        return this.dataCache.get(key);
    }

    public synchronized void setData(String key, Object value) {
        this.dataCache.put(key, value);
    }

    public synchronized Locale getLocale() {
        return this.managerLocale;
    }

    public synchronized void setLocale(Locale locale) {
        this.managerLocale = locale;
        this.resetBundles();
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = Logger.getLogger("ilog.rules.ui.prefs", "ilog.rules.util.prefs.IlrLoggerMessages");
            this.logger.setLevel(Level.ALL);
        }
        return this.logger;
    }

    public synchronized void setLogger(Logger logger) {
        this.logger = logger;
    }

    protected abstract String getBaseClassName();

    protected IlrPropertyBundle newBundle(String name) {
        return new IlrPropertyBundle(name);
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public synchronized void setClassLoader(ClassLoader cl) {
        if (cl != this.classLoader) {
            this.classLoader = cl;
            this.resetBundles();
        }
    }

    public synchronized IlrPropertyBundle getPropertyBundle(String bundleName) {
        return this.getPropertyBundle(bundleName, this.getLocale());
    }

    public synchronized IlrPropertyBundle getPropertyBundle(String bundleName, Locale locale) {
        String localizedBundleName = this.localizedName(bundleName, locale);
        IlrPropertyBundle bundle = (IlrPropertyBundle)this.bundles.get(localizedBundleName);
        if (bundle == null) {
            if (this.noBundles.get(localizedBundleName) != null) {
                return null;
            }
            StringBuffer basename = new StringBuffer();
            for (int i = 0; i < this.suffixes.size(); ++i) {
                int count = 0;
                for (int j = 0; j < this.prefixes.size(); ++j) {
                    String resourceName;
                    String suffix = (String)this.suffixes.elementAt(i);
                    String prefix = (String)this.prefixes.elementAt(j);
                    if (prefix.endsWith(".")) {
                        prefix = prefix.substring(0, prefix.length() - 1);
                    }
                    if (suffix.endsWith("_")) {
                        suffix = suffix.substring(0, suffix.length() - 1);
                    }
                    if (prefix.length() > 0) {
                        basename.append(prefix).append('.');
                    }
                    if (bundleName.length() > 0) {
                        basename.append(bundleName).append('.');
                    }
                    basename.append(this.getBaseClassName());
                    if (suffix.length() > 0) {
                        basename.append('_').append(suffix);
                    }
                    if (this.resourceExists(resourceName = basename.toString(), locale)) {
                        ++count;
                        ResourceBundle rb = this.loadResources(resourceName, locale);
                        if (rb != null) {
                            if (bundle == null) {
                                bundle = this.newBundle(bundleName);
                                this.bundles.put(localizedBundleName, bundle);
                            }
                            bundle.addProperties(rb);
                        }
                    } else {
                        this.noBundles.put(localizedBundleName, localizedBundleName);
                    }
                    basename.setLength(0);
                }
                if (i == 0 && count == 0) break;
            }
            if (localizedBundleName.equals(this.localizedName("", locale))) {
                if (bundle == null) {
                    bundle = this.newBundle(bundleName);
                    this.bundles.put(localizedBundleName, bundle);
                }
                bundle.addProperties(this.getDefaultBundle().getResourceBundle());
            }
        }
        return bundle;
    }

    public synchronized IlrPropertyBundle findPropertyBundle(String key) {
        return this.findPropertyBundle(key, this.getLocale());
    }

    public synchronized IlrPropertyBundle findPropertyBundle(String key, Locale locale) {
        this.iterator.reset(key, locale);
        while (this.iterator.hasNext()) {
            IlrPropertyBundle pb = (IlrPropertyBundle)this.iterator.next();
            if (!pb.containsKey(key)) continue;
            return pb;
        }
        return null;
    }

    public synchronized String getValue(String key, String defaultValue) {
        return this.getValue(key, defaultValue, this.getLocale());
    }

    public synchronized String getValue(String key, String defaultValue, Locale locale) {
        String res = null;
        this.iterator.reset(key, locale);
        while (this.iterator.hasNext()) {
            IlrPropertyBundle pb = (IlrPropertyBundle)this.iterator.next();
            res = pb.getRawString(key);
            if (res == null) continue;
            return IlrPropertyBundle.cleanName(res);
        }
        return defaultValue;
    }

    public synchronized String getValue(String key) {
        return this.getValue(key, null, this.getLocale());
    }

    public synchronized String getValue(String key, Locale locale) {
        return this.getValue(key, null, locale);
    }

    private ClassLoader findClassLoader() {
        ClassLoader cl = this.getClassLoader();
        if (cl == null && (cl = IlrPropertyManager.class.getClassLoader()) == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }

    public URL findURL(String name) {
        StringBuffer basename = new StringBuffer();
        ClassLoader cl = this.findClassLoader();
        for (int j = 0; j < this.prefixes.size(); ++j) {
            URL url;
            String prefix = (String)this.prefixes.elementAt(j);
            if (prefix.length() > 0) {
                prefix = prefix.replace('.', '/');
                basename.append(prefix).append('/').append(name);
                url = cl.getResource(basename.toString());
                if (url != null) {
                    return url;
                }
            } else {
                url = cl.getResource(name);
                if (url != null) {
                    return url;
                }
            }
            basename.setLength(0);
        }
        return null;
    }

    private boolean resourceExists(String resourceName, Locale locale) {
        final String name = resourceName.replace('.', '/') + ".properties";
        URL url = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader cl = IlrPropertyManager.this.findClassLoader();
                return cl.getResource(name);
            }
        });
        return url != null;
    }

    private ResourceBundle loadResources(String resourceName, Locale locale) {
        try {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            ClassLoader classLoader = this.findClassLoader();
            return ResourceBundle.getBundle(resourceName, locale, classLoader);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public synchronized void addProperties(File file, String bundleName) throws IOException {
        this.addProperties(file, bundleName, this.getLocale());
    }

    public synchronized void addProperties(File file) throws IOException {
        this.addProperties(file, this.getLocale());
    }

    public void setProperty(String key, String value) {
        this.setProperty(key, value, this.getLocale());
    }

    public synchronized void addProperties(File file, String bundleName, Locale locale) throws IOException {
        IlrPropertyBundle bundle = this.getPropertyBundle(bundleName, locale);
        if (bundle == null) {
            String localizedBundleName = this.localizedName(bundleName, locale);
            bundle = this.newBundle(bundleName);
            this.bundles.put(localizedBundleName, bundle);
        }
        bundle.addProperties(file);
    }

    public synchronized void addProperties(File file, Locale locale) throws IOException {
        IlrPropertyBundle bundle = this.getPropertyBundle("", locale);
        IlrPropertyBundle defaultBundle = this.getDefaultBundle();
        bundle.addProperties(file);
        defaultBundle.addProperties(file);
    }

    public void setProperty(String key, String value, Locale locale) {
        if (key != null) {
            IlrPropertyBundle bundle = this.getPropertyBundle("", locale);
            IlrPropertyBundle defaultBundle = this.getDefaultBundle();
            bundle.setProperty(key, value);
            defaultBundle.setProperty(key, value);
        }
    }

    private String localizedName(String name, Locale locale) {
        if (locale == null || locale.equals(this.getLocale()) || this.getLocale() == null && Locale.getDefault().equals(locale)) {
            return name;
        }
        String localizedName = name;
        String localeSuffix = locale.toString();
        if (localeSuffix.length() > 0) {
            localizedName = localizedName + "_" + localeSuffix;
        } else if (locale.getVariant().length() > 0) {
            localizedName = localizedName + "___" + locale.getVariant();
        }
        return localizedName;
    }

    public class PropertyBundleIterator
    implements Iterator {
        private int currentIndex;
        private int maxIndex;
        private IlrPropertyBundle bundle;
        private String key;
        private int counter;
        private Locale usedLocale;

        public PropertyBundleIterator(String key, Locale locale) {
            this.reset(key, locale);
        }

        public void reset(String key, Locale locale) {
            this.key = key;
            this.counter = 0;
            this.currentIndex = 0;
            this.maxIndex = key != null ? key.lastIndexOf(46) : -1;
            this.usedLocale = locale;
            this.bundle = IlrPropertyManager.this.getPropertyBundle("", locale);
        }

        @Override
        public boolean hasNext() {
            if (this.bundle == null) {
                this.advance();
            }
            return this.bundle != null;
        }

        public Object next() {
            if (this.hasNext()) {
                IlrPropertyBundle pb = this.bundle;
                this.bundle = null;
                return pb;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void advance() {
            while (this.bundle == null && this.currentIndex < this.maxIndex && (this.counter <= IlrPropertyManager.this.getMaximumDepth() || IlrPropertyManager.this.nostop)) {
                int index = this.key.indexOf(46, this.currentIndex);
                String current = this.key.substring(0, index);
                this.bundle = IlrPropertyManager.this.getPropertyBundle(current, this.usedLocale);
                ++this.counter;
                this.currentIndex = index + 1;
            }
        }
    }
}

