/*
 * Decompiled with CFR 0.152.
 */
package ilog.rules.util.xml;

import ilog.rules.util.xml.IlrXmlConstants;
import ilog.rules.util.xml.IlrXmlHandler;
import ilog.rules.util.xml.IlrXmlHandlerBase;
import ilog.rules.util.xml.IlrXmlHandlerClassException;
import ilog.rules.util.xml.IlrXmlSAXException;
import ilog.rules.util.xml.IlrXmlWriteException;
import ilog.rules.util.xml.IlrXmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Stack;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class IlrXmlStorageManager
implements IlrXmlConstants {
    private static final SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private XmlHandlerImpl xmlHandler = new XmlHandlerImpl();
    private Stack handlerStack = new Stack();
    private IlrXmlHandler rootHandler = null;
    private IlrXmlHandler initialHandler = null;
    private XMLReader reader = null;
    private Locator locator = null;
    private static ClassLoader classLoader;
    private ArrayList activatedHandlers = new ArrayList(3);
    private HashMap classnameMap;
    private boolean isReading;
    private HashMap hInstances = new HashMap(3);

    public void writeDocument(IlrXmlWriter writer, Object data, IlrXmlHandler handler) throws IlrXmlWriteException, IOException {
        IlrXmlWriter xwriter = new IlrXmlWriter(writer);
        xwriter.println("<?xml version=\"1.0\" standalone=\"yes\"?>");
        this.writeObject(writer, data, handler);
        xwriter.close();
    }

    public void writeObject(IlrXmlWriter writer, Object data, IlrXmlHandler handler) throws IlrXmlWriteException, IOException {
        IlrXmlWriter xwriter = new IlrXmlWriter(writer);
        xwriter.printStartEmptyTag("ilr-xml-handler");
        xwriter.printAttribute("class", handler.getClass().getName());
        xwriter.printAttribute("version", handler.getVersion());
        xwriter.println(">");
        xwriter.incIndent();
        handler.writeObject(writer, data, this);
        xwriter.decIndent();
        xwriter.printEndTag("ilr-xml-handler");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IlrXmlHandler readDocument(InputSource source, IlrXmlHandler handler) throws SAXException, IOException {
        try {
            this.isReading = true;
            this.initialHandler = handler;
            if (this.initialHandler != null) {
                this.initialHandler.setStorageManager(this);
            }
            this.rootHandler = null;
            this.handlerStack.removeAllElements();
            this.activatedHandlers.clear();
            this.getReader().parse(source);
            while (this.peekHandler() != null) {
                this.popHandler();
            }
        }
        finally {
            this.isReading = false;
        }
        if (this.rootHandler instanceof InvalidHandler) {
            throw ((InvalidHandler)this.rootHandler).getException();
        }
        return this.rootHandler;
    }

    public static ClassLoader getClassLoader() {
        return classLoader;
    }

    public static void setClassLoader(ClassLoader cl) {
        classLoader = cl;
    }

    public String getNewClassName(String name) {
        if (this.classnameMap != null) {
            return (String)this.classnameMap.get(name);
        }
        return null;
    }

    public void setNewClassName(String oldName, String newName) {
        if (this.classnameMap == null) {
            this.classnameMap = new HashMap();
        }
        this.classnameMap.put(oldName, newName);
    }

    public boolean isReading() {
        return this.isReading;
    }

    public void release() {
        this.rootHandler = null;
        this.initialHandler = null;
        if (this.handlerStack != null) {
            this.handlerStack.removeAllElements();
        }
        if (this.activatedHandlers != null) {
            this.activatedHandlers.clear();
        }
        if (this.hInstances != null) {
            this.hInstances.clear();
        }
    }

    public boolean isHandlerTag(String elname) {
        return this.isHandlerTag(elname, null);
    }

    public boolean isHandlerTag(String elname, Attributes attributes) {
        return "ilr-xml-handler".equals(elname);
    }

    private String checkClassName(String oldClassName) {
        int index = oldClassName.lastIndexOf(46);
        String packName = oldClassName.substring(0, index);
        String restOfName = oldClassName.substring(index);
        if (packName.equals("ilog.rules.xml")) {
            packName = "ilog.rules.util.xml";
        }
        return packName + restOfName;
    }

    public void installHandler(String elname, Attributes attributes) throws IlrXmlSAXException, SAXException {
        if (this.isHandlerTag(elname, attributes)) {
            String clsName = attributes.getValue("class");
            String version = attributes.getValue("version");
            clsName = this.checkClassName(clsName);
            this.installHandler(clsName, version);
        }
    }

    public void installHandler(String clsName, String version) throws IlrXmlSAXException, SAXException {
        if (clsName != null) {
            try {
                IlrXmlHandler newHandler = this.getHandler(this.lookupClass(clsName, version));
                this.installHandler(newHandler);
            }
            catch (ClassNotFoundException e) {
                throw new IlrXmlSAXException("ilog.rules.xml", "Xml.NoHandlerClass", clsName, this.locator, (Exception)e);
            }
            catch (IlrXmlHandlerClassException e) {
                throw e.createSAXException(this.locator);
            }
        } else {
            throw new IlrXmlSAXException("ilog.rules.xml", "Xml.MissingAttr", "class", this.locator, null);
        }
    }

    public void installHandler(IlrXmlHandler handler) throws SAXException {
        IlrXmlHandler parent = this.peekHandler();
        handler.setDocumentLocator(this.locator);
        handler.activate(parent);
        this.setFree(handler, false);
        this.pushHandler(handler);
    }

    private boolean isFree(IlrXmlHandler handler) {
        return !this.activatedHandlers.contains(handler);
    }

    private void setFree(IlrXmlHandler handler, boolean free) {
        if (free) {
            this.activatedHandlers.remove(handler);
        } else if (!this.activatedHandlers.contains(handler)) {
            this.activatedHandlers.add(handler);
        }
    }

    Class lookupClass(String baseClassName, String version) throws ClassNotFoundException {
        String newName = this.getNewClassName(baseClassName);
        if (newName != null) {
            baseClassName = newName;
        }
        if (version != null) {
            try {
                return IlrXmlStorageManager.findClass(baseClassName + "_" + version);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        return IlrXmlStorageManager.findClass(baseClassName);
    }

    private static Class findClass(String name) throws ClassNotFoundException {
        if (classLoader == null) {
            return Class.forName(name);
        }
        return Class.forName(name, true, classLoader);
    }

    private XMLReader getReader() throws SAXException {
        try {
            if (this.reader == null) {
                SAXParser saxParser = saxParserFactory.newSAXParser();
                this.reader = saxParser.getXMLReader();
                this.reader.setContentHandler(this.xmlHandler);
                this.reader.setDTDHandler(this.xmlHandler);
                this.reader.setEntityResolver(this.xmlHandler);
                this.reader.setErrorHandler(this.xmlHandler);
            }
            return this.reader;
        }
        catch (FactoryConfigurationError e) {
            throw new IlrXmlSAXException("ilog.rules.xml", "Xml.CreateParserError", null, null);
        }
        catch (ParserConfigurationException e) {
            throw new IlrXmlSAXException("ilog.rules.xml", "Xml.CreateParserError", null, e);
        }
    }

    public IlrXmlHandler readDocument(InputSource source) throws SAXException, IOException {
        return this.readDocument(source, null);
    }

    public void addHandler(IlrXmlHandler hInstance) {
        ArrayList<IlrXmlHandler> instances = (ArrayList<IlrXmlHandler>)this.hInstances.get(hInstance.getClass());
        if (instances == null) {
            instances = new ArrayList<IlrXmlHandler>();
        }
        instances.add(hInstance);
        this.hInstances.put(hInstance.getClass(), instances);
        hInstance.setStorageManager(this);
    }

    public IlrXmlHandler getHandler(Class hClass) throws IlrXmlHandlerClassException {
        ArrayList instances = (ArrayList)this.hInstances.get(hClass);
        IlrXmlHandler handler = null;
        if (instances != null) {
            for (int i = 0; i < instances.size(); ++i) {
                IlrXmlHandler hdlr = (IlrXmlHandler)instances.get(i);
                if (!this.isFree(hdlr)) continue;
                handler = hdlr;
                break;
            }
        }
        if (handler == null) {
            try {
                handler = (IlrXmlHandler)hClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new IlrXmlHandlerClassException(hClass.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new IlrXmlHandlerClassException(hClass.getName(), e);
            }
            catch (ClassCastException e) {
                throw new IlrXmlHandlerClassException(hClass.getName(), e);
            }
            this.addHandler(handler);
        }
        return handler;
    }

    private void pushHandler(IlrXmlHandler handler) {
        this.handlerStack.push(handler);
    }

    private IlrXmlHandler popHandler() {
        this.rootHandler = (IlrXmlHandler)this.handlerStack.pop();
        return this.rootHandler;
    }

    protected IlrXmlHandler peekHandler() {
        if (this.handlerStack.isEmpty()) {
            return null;
        }
        return (IlrXmlHandler)this.handlerStack.peek();
    }

    private IlrXmlHandler handlerAt(int i) {
        return (IlrXmlHandler)this.handlerStack.elementAt(i);
    }

    private static class InvalidHandler
    extends IlrXmlHandlerBase {
        private IlrXmlHandler handler;
        private SAXException exception;

        public InvalidHandler(IlrXmlHandler handler, SAXException exception) {
            this.handler = handler;
            this.exception = exception;
        }

        public IlrXmlHandler getHandler() {
            return this.handler;
        }

        public SAXException getException() {
            return this.exception;
        }
    }

    private class XmlHandlerImpl
    implements EntityResolver,
    DTDHandler,
    ContentHandler,
    ErrorHandler {
        private XmlHandlerImpl() {
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
            IlrXmlHandler handler = IlrXmlStorageManager.this.peekHandler();
            if (handler != null) {
                return handler.resolveEntity(publicId, systemId);
            }
            return null;
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
            IlrXmlHandler handler = IlrXmlStorageManager.this.peekHandler();
            if (handler != null) {
                handler.skippedEntity(name);
            }
        }

        @Override
        public void notationDecl(String name, String publicId, String systemId) throws SAXException {
            IlrXmlHandler handler = IlrXmlStorageManager.this.peekHandler();
            if (handler != null) {
                handler.notationDecl(name, publicId, systemId);
            }
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            IlrXmlHandler handler = IlrXmlStorageManager.this.peekHandler();
            if (handler != null) {
                handler.startPrefixMapping(prefix, uri);
            }
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
            IlrXmlHandler handler = IlrXmlStorageManager.this.peekHandler();
            if (handler != null) {
                handler.endPrefixMapping(prefix);
            }
        }

        @Override
        public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
            IlrXmlHandler handler = IlrXmlStorageManager.this.peekHandler();
            if (handler != null) {
                handler.unparsedEntityDecl(name, publicId, systemId, notationName);
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            IlrXmlStorageManager.this.locator = locator;
        }

        @Override
        public void startDocument() throws SAXException {
            IlrXmlHandler handler = IlrXmlStorageManager.this.peekHandler();
            if (handler != null) {
                handler.startDocument();
            }
        }

        @Override
        public void endDocument() throws SAXException {
            IlrXmlHandler handler = IlrXmlStorageManager.this.peekHandler();
            if (handler != null) {
                handler.endDocument();
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            IlrXmlHandler handler = IlrXmlStorageManager.this.peekHandler();
            if (handler != null) {
                handler.characters(ch, start, length);
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            IlrXmlHandler handler = IlrXmlStorageManager.this.peekHandler();
            if (handler != null) {
                handler.ignorableWhitespace(ch, start, length);
            }
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            IlrXmlHandler handler = IlrXmlStorageManager.this.peekHandler();
            if (handler != null) {
                handler.processingInstruction(target, data);
            }
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            IlrXmlHandler handler = IlrXmlStorageManager.this.peekHandler();
            if (handler != null) {
                handler.warning(e);
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            IlrXmlHandler handler = IlrXmlStorageManager.this.peekHandler();
            if (handler != null) {
                handler.error(e);
            }
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            IlrXmlHandler handler = IlrXmlStorageManager.this.peekHandler();
            if (handler != null) {
                handler.fatalError(e);
            }
        }

        private InvalidHandler checkValid(IlrXmlHandler handler) {
            if (handler instanceof InvalidHandler) {
                return (InvalidHandler)handler;
            }
            return null;
        }

        private void localError(SAXException e) {
            IlrXmlStorageManager.this.pushHandler(new InvalidHandler(IlrXmlStorageManager.this.popHandler(), e));
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (IlrXmlStorageManager.this.initialHandler != null) {
                IlrXmlStorageManager.this.installHandler(IlrXmlStorageManager.this.initialHandler);
                IlrXmlStorageManager.this.initialHandler = null;
            }
            if (IlrXmlStorageManager.this.isHandlerTag(qName, attributes)) {
                IlrXmlStorageManager.this.installHandler(qName, attributes);
            } else {
                IlrXmlHandler handler = IlrXmlStorageManager.this.peekHandler();
                if (handler != null) {
                    try {
                        handler.startElement(uri, localName, qName, attributes);
                    }
                    catch (SAXException e) {
                        this.localError(e);
                    }
                } else {
                    throw new IlrXmlSAXException("ilog.rules.xml", "Xml.NoHandlerTag", qName, IlrXmlStorageManager.this.locator, null);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (IlrXmlStorageManager.this.isHandlerTag(qName)) {
                IlrXmlHandler child = IlrXmlStorageManager.this.popHandler();
                InvalidHandler invalidHandler = this.checkValid(child);
                IlrXmlHandler handler = IlrXmlStorageManager.this.peekHandler();
                if (handler != null) {
                    if (invalidHandler == null) {
                        handler.childProcessed(child);
                    } else {
                        child = invalidHandler.getHandler();
                        try {
                            handler.childError(child, invalidHandler.getException());
                        }
                        catch (SAXException e) {
                            this.localError(e);
                        }
                    }
                } else if (invalidHandler != null) {
                    throw invalidHandler.getException();
                }
                child.deactivate(handler);
                IlrXmlStorageManager.this.setFree(child, true);
            } else {
                IlrXmlHandler handler = IlrXmlStorageManager.this.peekHandler();
                if (handler != null) {
                    try {
                        handler.endElement(uri, localName, qName);
                    }
                    catch (SAXException e) {
                        this.localError(e);
                    }
                }
            }
        }
    }
}

