--
--
-- Licensed Materials - Property of IBM
-- 5724X98 5724Y15 5655V82 5724X99 5724Y16 5655V89 5725B69 5655W88 5725C52 5655W90 5655Y31
-- Copyright IBM Corp. 1987, 2015 All Rights Reserved
-- US Government Users Restricted Rights - Use, duplication or
-- disclosure restricted by GSA ADP Schedule Contract with
-- IBM Corp.
--
--
/*
 * NOTES :
 * 1) HAVE TO CREATE AN INDEX ON THE FOREIGN KEY BEFORE CREATING IT FOR REAL (BUG#3491)
 * 2) MAX SIZE FOR VARCHAR IS 255.
 */

DROP INDEX XOM_RESOURCES_IDX ON XOM_RESOURCES;
DROP INDEX XOM_LIBRARIES_IDX ON XOM_LIBRARIES;
DROP TABLE IF EXISTS XOM_LIBRARY_VALUES;
DROP TABLE IF EXISTS XOM_RESOURCES;
DROP TABLE IF EXISTS XOM_LIBRARIES;

CREATE TABLE IF NOT EXISTS XOM_LIBRARIES (
  ID INT NOT NULL AUTO_INCREMENT,
  NAME VARCHAR(255) NOT NULL,
  MAJOR_VERSION INT NOT NULL,
  MINOR_VERSION INT NOT NULL,
  CREATION_DATE BIGINT NOT NULL,
  CONSTRAINT XL_PK PRIMARY KEY (ID),
  CONSTRAINT XL_UNIQUE UNIQUE (NAME, MAJOR_VERSION, MINOR_VERSION)
) ENGINE=InnoDB;

CREATE TABLE IF NOT EXISTS XOM_RESOURCES (
  ID INT NOT NULL AUTO_INCREMENT,
  NAME VARCHAR(255) NOT NULL,
  MAJOR_VERSION INT NOT NULL,
  MINOR_VERSION INT NOT NULL,
  SHA1 VARCHAR(40) NOT NULL,
  CREATION_DATE BIGINT NOT NULL,
  DATA LONGBLOB NOT NULL,
  CONSTRAINT XR_PK PRIMARY KEY (ID),
  CONSTRAINT XR_UNIQUE1 UNIQUE (NAME, MAJOR_VERSION, MINOR_VERSION),
  CONSTRAINT XR_UNIQUE2 UNIQUE (NAME, SHA1)
) ENGINE=InnoDB;

CREATE TABLE IF NOT EXISTS XOM_LIBRARY_VALUES (
  ID INT NOT NULL AUTO_INCREMENT,
  LIBRARY_ID INT NOT NULL,
  URL VARCHAR(255) NOT NULL,
  INDEX XL_VL_FKEY (LIBRARY_ID),
  CONSTRAINT XL_VL_PK PRIMARY KEY (ID),
  CONSTRAINT XL_VL_FK FOREIGN KEY (LIBRARY_ID) REFERENCES XOM_LIBRARIES (ID) ON DELETE CASCADE,
  CONSTRAINT XL_VL_UN UNIQUE (LIBRARY_ID, URL)
) ENGINE=InnoDB;

CREATE INDEX XOM_LIBRARIES_IDX ON XOM_LIBRARIES (NAME, MAJOR_VERSION, MINOR_VERSION);

CREATE INDEX XOM_RESOURCES_IDX ON XOM_RESOURCES (NAME, SHA1);

