--
--
-- Licensed Materials - Property of IBM
-- 5724X98 5724Y15 5655V82 5724X99 5724Y16 5655V89 5725B69 5655W88 5725C52 5655W90 5655Y31
-- Copyright IBM Corp. 1987, 2015 All Rights Reserved
-- US Government Users Restricted Rights - Use, duplication or
-- disclosure restricted by GSA ADP Schedule Contract with
-- IBM Corp.
--
--
DROP SEQUENCE XOM_LIBRARY_VALUES_SEQUENCE;
DROP SEQUENCE XOM_RESOURCES_SEQUENCE;
DROP SEQUENCE XOM_LIBRARIES_SEQUENCE;
DROP TABLE XOM_LIBRARY_VALUES;
DROP TABLE XOM_RESOURCES;
DROP TABLE XOM_LIBRARIES;

CREATE TABLE XOM_LIBRARIES (
  ID INT NOT NULL,
  NAME VARCHAR(256) NOT NULL,
  MAJOR_VERSION INT NOT NULL,
  MINOR_VERSION INT NOT NULL,
  CREATION_DATE INT NOT NULL,
  CONSTRAINT XL_PK PRIMARY KEY (ID),
  CONSTRAINT XL_UNIQUE UNIQUE (NAME, MAJOR_VERSION, MINOR_VERSION)
);

CREATE TABLE XOM_RESOURCES (
  ID INT NOT NULL,
  NAME VARCHAR(256) NOT NULL,
  MAJOR_VERSION INT NOT NULL,
  MINOR_VERSION INT NOT NULL,
  SHA1 VARCHAR(40) NOT NULL,
  CREATION_DATE INT NOT NULL,
  DATA BLOB NOT NULL,
  CONSTRAINT XR_PK PRIMARY KEY (ID),
  CONSTRAINT XR_UNIQUE1 UNIQUE (NAME, MAJOR_VERSION, MINOR_VERSION),
  CONSTRAINT XR_UNIQUE2 UNIQUE (NAME, SHA1)
);

CREATE TABLE XOM_LIBRARY_VALUES (
  ID INT NOT NULL,
  LIBRARY_ID INT NOT NULL,
  URL VARCHAR(256) NOT NULL,
  CONSTRAINT XL_VLS_PK PRIMARY KEY (ID),
  CONSTRAINT XL_VLS_FK FOREIGN KEY (LIBRARY_ID) REFERENCES XOM_LIBRARIES (ID) ON DELETE CASCADE,
  CONSTRAINT XL_VLS_UN UNIQUE (LIBRARY_ID, URL)
);

CREATE SEQUENCE XOM_LIBRARIES_SEQUENCE
  START WITH 1
  INCREMENT BY 1
  NOMAXVALUE;

CREATE SEQUENCE XOM_RESOURCES_SEQUENCE
  START WITH 1
  INCREMENT BY 1
  NOMAXVALUE;

CREATE SEQUENCE XOM_LIBRARY_VALUES_SEQUENCE
  START WITH 1
  INCREMENT BY 1
  NOMAXVALUE;
